/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Parameter;
import joptima.functions.ConstrainableFunction;

public class Gaussian
extends ConstrainableFunction {
    private static final double sqrttwopi = Math.sqrt(Math.PI * 2);
    public double m_norm;
    public double m_mean;
    public double m_sigma;
    private String m_name = "Gaussian";

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.countUnconstrained()];
        try {
            int cursor = 0;
            if (!this.m_constrained[0]) {
                parameters[cursor++] = new Parameter(this, "norm");
            }
            if (!this.m_constrained[1]) {
                parameters[cursor++] = new Parameter(this, "mean");
            }
            if (!this.m_constrained[2]) {
                parameters[cursor++] = new Parameter(this, "sigma");
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void constrain(String parametername) {
        if ("norm".equals(parametername)) {
            this.m_constrained[0] = true;
        }
        if ("mean".equals(parametername)) {
            this.m_constrained[1] = true;
        }
        if ("sigma".equals(parametername)) {
            this.m_constrained[2] = true;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    public Gaussian() {
        this(1.0, 0.0, 1.0);
    }

    public Gaussian(double norm, double mean, double sigma) {
        this.m_norm = norm;
        this.m_mean = mean;
        this.m_sigma = sigma;
        this.m_constrained = new boolean[3];
    }

    @Override
    public double calculate(double x) {
        return this.m_norm / this.m_sigma / sqrttwopi * Math.exp(-(x - this.m_mean) * (x - this.m_mean) / (2.0 * this.m_sigma * this.m_sigma));
    }

    public double getNorm() {
        return this.m_norm;
    }

    public void setNorm(double norm) {
        this.m_norm = norm;
    }

    public double getMean() {
        return this.m_mean;
    }

    public void setMean(double mean) {
        this.m_mean = mean;
    }

    public double getSigma() {
        return this.m_sigma;
    }

    public void setSigma(double sigma) {
        this.m_sigma = sigma;
    }
}

