/*
 * Decompiled with CFR 0.152.
 */
package joptima.fortran;

import joptima.fortran.Fzero_methods;
import joptima.fortran.linalg.Blas_f77;

public class Fzero {
    public static void fzero(Fzero_methods zeroclass, double[] b, double[] c, double r, double re, double ae, int[] iflag) {
        double fz;
        int[] itest = new int[37];
        int[] itmp = new int[16];
        double er = 2.4E-16;
        double z = r;
        if (r <= Math.min(b[1], c[1]) || r >= Math.max(b[1], c[1])) {
            z = c[1];
        }
        double rw = Math.max(re, er);
        double aw = Math.max(ae, 0.0);
        int ic = 0;
        double t = z;
        double fc = fz = zeroclass.f_to_zero(t);
        t = b[1];
        double fb = zeroclass.f_to_zero(t);
        int kount = 2;
        if (Blas_f77.sign_f77(1.0, fz) != Blas_f77.sign_f77(1.0, fb)) {
            c[1] = z;
        } else if (z != c[1]) {
            t = c[1];
            fc = zeroclass.f_to_zero(t);
            kount = 3;
            if (Blas_f77.sign_f77(1.0, fz) != Blas_f77.sign_f77(1.0, fc)) {
                b[1] = z;
                fb = fz;
            }
        }
        double a = c[1];
        double fa = fc;
        double acbs = Math.abs(b[1] - c[1]);
        double fx = Math.max(Math.abs(fb), Math.abs(fc));
        while (true) {
            double tol;
            double cmb;
            double acmb;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b[1];
                fa = fb;
                b[1] = c[1];
                fb = fc;
                c[1] = a;
                fc = fa;
            }
            if ((acmb = Math.abs(cmb = 0.5 * (c[1] - b[1]))) <= (tol = rw * Math.abs(b[1]) + aw)) {
                if (Blas_f77.sign_f77(1.0, fb) == Blas_f77.sign_f77(1.0, fc)) {
                    iflag[1] = 4;
                    return;
                }
                if (Math.abs(fb) > fx) {
                    iflag[1] = 3;
                    return;
                }
                iflag[1] = 1;
                return;
            }
            if (fb == 0.0) {
                iflag[1] = 2;
                return;
            }
            if (kount >= 500) {
                iflag[1] = 5;
                return;
            }
            double p = (b[1] - a) * fb;
            double q = fa - fb;
            if (p < 0.0) {
                p = -p;
                q = -q;
            }
            a = b[1];
            fa = fb;
            if (++ic >= 4 && 8.0 * acmb >= acbs) {
                b[1] = 0.5 * (c[1] + b[1]);
            } else {
                if (ic >= 4) {
                    ic = 0;
                    acbs = acmb;
                }
                b[1] = p <= Math.abs(q) * tol ? b[1] + Blas_f77.sign_f77(tol, cmb) : (p >= cmb * q ? 0.5 * (c[1] + b[1]) : b[1] + p / q);
            }
            t = b[1];
            fb = zeroclass.f_to_zero(t);
            ++kount;
            if (Blas_f77.sign_f77(1.0, fb) != Blas_f77.sign_f77(1.0, fc)) continue;
            c[1] = a;
            fc = fa;
        }
    }
}

