/*
 * Decompiled with CFR 0.152.
 */
package joptima;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import joptima.Function;
import joptima.Minimizable;
import joptima.Parameter;

public abstract class Fitter
implements Minimizable,
Function {
    protected List m_functions = new ArrayList();
    protected int m_nparameters = 0;
    protected String m_name;

    public void addFunction(Function f) {
        this.m_functions.add(f);
        this.m_nparameters += f.getParameters().length;
    }

    public void removeAllFunctions() {
        this.m_functions = new ArrayList();
        this.m_nparameters = 0;
    }

    @Override
    public double calculate(double x) {
        double value = 0.0;
        Iterator i = this.m_functions.iterator();
        while (i.hasNext()) {
            value += ((Function)i.next()).calculate(x);
        }
        return value;
    }

    @Override
    public String getName() {
        if (null != this.m_name) {
            return this.m_name;
        }
        Iterator it = this.m_functions.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            if (0 < buf.length()) {
                buf.append('+');
            }
            buf.append(((Function)it.next()).getName());
        }
        return buf.toString();
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] p = new Parameter[this.m_nparameters];
        int pindex = 0;
        Iterator it = this.m_functions.iterator();
        while (it.hasNext()) {
            Parameter[] subp = ((Function)it.next()).getParameters();
            for (int i = 0; i < subp.length; ++i) {
                p[pindex++] = subp[i];
            }
        }
        return p;
    }
}

