/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.SimpleOptimizableFunction;
import edu.stanford.rsl.jpop.fortran.Blas_f77;

public class SimpleFunctionOptimizer {
    protected double leftEndPoint = Double.MIN_VALUE;
    protected double rightEndPoint = Double.MAX_VALUE;
    protected double absoluteTolerance = 3.0E-8;
    protected double relativeTolerance = 3.0E-4;
    protected boolean printWarnings = true;
    protected boolean useInitialGuess = false;
    protected double initialGuess = 0.0;

    public double getLeftEndPoint() {
        return this.leftEndPoint;
    }

    public void setLeftEndPoint(double leftEndPoint) {
        this.leftEndPoint = leftEndPoint;
    }

    public double getRightEndPoint() {
        return this.rightEndPoint;
    }

    public void setRightEndPoint(double rightEndPoint) {
        this.rightEndPoint = rightEndPoint;
    }

    public double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    public void setAbsoluteTolerance(double absoluteTolerance) {
        this.absoluteTolerance = absoluteTolerance;
    }

    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    public void setRelativeTolerance(double relativeTolerance) {
        this.relativeTolerance = relativeTolerance;
    }

    public boolean isPrintWarnings() {
        return this.printWarnings;
    }

    public void setPrintWarnings(boolean printWarnings) {
        this.printWarnings = printWarnings;
    }

    public boolean isUseInitialGuess() {
        return this.useInitialGuess;
    }

    public void setUseInitialGuess(boolean useInitialGuess) {
        this.useInitialGuess = useInitialGuess;
    }

    public double getInitialGuess() {
        return this.initialGuess;
    }

    public void setInitialGuess(double initialGuess) {
        this.initialGuess = initialGuess;
    }

    public double minimize(SimpleOptimizableFunction function) {
        return SimpleFunctionOptimizer.fmin(this.leftEndPoint, this.rightEndPoint, function, this.absoluteTolerance);
    }

    @Deprecated
    public static double fmin(double leftEndPoint, double rightEndPoint, SimpleOptimizableFunction function, double toleranceFactor) {
        double fx;
        double v;
        double c = 0.5 * (3.0 - Math.sqrt(5.0));
        double d = 0.0;
        double eps = 1.2E-16;
        double tol1 = eps + 1.0;
        eps = Math.sqrt(eps);
        double w = v = leftEndPoint + c * (rightEndPoint - leftEndPoint);
        double x = v;
        double e = 0.0;
        double fv = fx = function.evaluate(x);
        double fw = fx;
        double tol3 = toleranceFactor / 3.0;
        double xm = 0.5 * (leftEndPoint + rightEndPoint);
        tol1 = eps * Math.abs(x) + tol3;
        double t2 = 2.0 * tol1;
        while (Math.abs(x - xm) > t2 - 0.5 * (rightEndPoint - leftEndPoint)) {
            double fu;
            double u;
            double r = 0.0;
            double q = 0.0;
            double p = 0.0;
            if (Math.abs(e) > tol1) {
                r = (x - w) * (fx - fv);
                q = (x - v) * (fx - fw);
                p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                } else {
                    q = -q;
                }
                r = e;
                e = d;
            }
            if (Math.abs(p) < Math.abs(0.5 * q * r) && p > q * (leftEndPoint - x) && p < q * (rightEndPoint - x)) {
                d = p / q;
                u = x + d;
                if (u - leftEndPoint < t2 || rightEndPoint - u < t2) {
                    d = tol1;
                    if (x >= xm) {
                        d = -d;
                    }
                }
            } else {
                e = x < xm ? rightEndPoint - x : leftEndPoint - x;
                d = c * e;
            }
            if (fx <= (fu = function.evaluate(u = Math.abs(d) >= tol1 ? x + d : (d > 0.0 ? x + tol1 : x - tol1)))) {
                if (u < x) {
                    leftEndPoint = u;
                } else {
                    rightEndPoint = u;
                }
            }
            if (fu <= fx) {
                if (u < x) {
                    rightEndPoint = x;
                } else {
                    leftEndPoint = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
                xm = 0.5 * (leftEndPoint + rightEndPoint);
                tol1 = eps * Math.abs(x) + tol3;
                t2 = 2.0 * tol1;
                continue;
            }
            if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
                xm = 0.5 * (leftEndPoint + rightEndPoint);
                tol1 = eps * Math.abs(x) + tol3;
                t2 = 2.0 * tol1;
                continue;
            }
            if (fu > fv && v != x && v != w) {
                xm = 0.5 * (leftEndPoint + rightEndPoint);
                tol1 = eps * Math.abs(x) + tol3;
                t2 = 2.0 * tol1;
                continue;
            }
            v = u;
            fv = fu;
            xm = 0.5 * (leftEndPoint + rightEndPoint);
            tol1 = eps * Math.abs(x) + tol3;
            t2 = 2.0 * tol1;
        }
        return x;
    }

    protected static void warn(String warning) {
        System.out.println("Warning: " + warning);
    }

    public double findRoot(SimpleOptimizableFunction function) {
        double[] b = new double[]{0.0, this.leftEndPoint};
        double[] c = new double[]{0.0, this.rightEndPoint};
        int[] iflag = new int[]{0, 0};
        if (!this.useInitialGuess) {
            this.initialGuess = this.leftEndPoint;
        }
        SimpleFunctionOptimizer.fzero(function, b, c, this.initialGuess, this.relativeTolerance, this.absoluteTolerance, iflag);
        if (this.printWarnings) {
            switch (iflag[1]) {
                case 3: {
                    SimpleFunctionOptimizer.warn("Absolute value of zero position is greater than either of the absolute values of the end points! i.e.  Math.abs(evaluate(findRoot(function))) >  Math.max(Math.abs(evaluate(leftEndPoint)),        Math.abs(evaluate(rightEndPoint)))");
                    break;
                }
                case 4: {
                    SimpleFunctionOptimizer.warn("No change in sign of evaluate(x) was found although the  interval (leftEndPoint, rightEndPoint) collapsed to the requested tolerance.  You should examine this case and decide whether  findRoot(function) is near a local minimum of evaluate(x), or it is near a zero of even multiplicity, or neither of these.");
                    break;
                }
                case 5: {
                    SimpleFunctionOptimizer.warn("Too many (> 500) function evaluations used.");
                }
            }
        }
        return b[1];
    }

    @Deprecated
    public static void fzero(SimpleOptimizableFunction function, double[] b, double[] c, double r, double re, double ae, int[] iflag) {
        double fz;
        double er = 2.4E-16;
        double z = r;
        if (r <= Math.min(b[1], c[1]) || r >= Math.max(b[1], c[1])) {
            z = c[1];
        }
        double rw = Math.max(re, er);
        double aw = Math.max(ae, 0.0);
        int ic = 0;
        double t = z;
        double fc = fz = function.evaluate(t);
        t = b[1];
        double fb = function.evaluate(t);
        int kount = 2;
        if (Blas_f77.sign_f77(1.0, fz) != Blas_f77.sign_f77(1.0, fb)) {
            c[1] = z;
        } else if (z != c[1]) {
            t = c[1];
            fc = function.evaluate(t);
            kount = 3;
            if (Blas_f77.sign_f77(1.0, fz) != Blas_f77.sign_f77(1.0, fc)) {
                b[1] = z;
                fb = fz;
            }
        }
        double a = c[1];
        double fa = fc;
        double acbs = Math.abs(b[1] - c[1]);
        double fx = Math.max(Math.abs(fb), Math.abs(fc));
        while (true) {
            double tol;
            double cmb;
            double acmb;
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b[1];
                fa = fb;
                b[1] = c[1];
                fb = fc;
                c[1] = a;
                fc = fa;
            }
            if ((acmb = Math.abs(cmb = 0.5 * (c[1] - b[1]))) <= (tol = rw * Math.abs(b[1]) + aw)) {
                if (Blas_f77.sign_f77(1.0, fb) == Blas_f77.sign_f77(1.0, fc)) {
                    iflag[1] = 4;
                    return;
                }
                if (Math.abs(fb) > fx) {
                    iflag[1] = 3;
                    return;
                }
                iflag[1] = 1;
                return;
            }
            if (fb == 0.0) {
                iflag[1] = 2;
                return;
            }
            if (kount >= 500) {
                iflag[1] = 5;
                return;
            }
            double p = (b[1] - a) * fb;
            double q = fa - fb;
            if (p < 0.0) {
                p = -p;
                q = -q;
            }
            a = b[1];
            fa = fb;
            if (++ic >= 4 && 8.0 * acmb >= acbs) {
                b[1] = 0.5 * (c[1] + b[1]);
            } else {
                if (ic >= 4) {
                    ic = 0;
                    acbs = acmb;
                }
                b[1] = p <= Math.abs(q) * tol ? b[1] + Blas_f77.sign_f77(tol, cmb) : (p >= cmb * q ? 0.5 * (c[1] + b[1]) : b[1] + p / q);
            }
            t = b[1];
            fb = function.evaluate(t);
            ++kount;
            if (Blas_f77.sign_f77(1.0, fb) != Blas_f77.sign_f77(1.0, fc)) continue;
            c[1] = a;
            fc = fa;
        }
    }
}

