/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.AdditiveFunctionAssembler;
import edu.stanford.rsl.jpop.FunctionAssembler;
import edu.stanford.rsl.jpop.FunctionController;
import edu.stanford.rsl.jpop.OptimizableFunction;
import edu.stanford.rsl.jpop.ParallelFunctionController;
import edu.stanford.rsl.jpop.fortran.UncminForJava;
import java.util.Arrays;

public class FunctionOptimizer {
    private int dimension;
    private double[] initialX;
    private double[] workSpaceX;
    private double[] functionValueAtX;
    private double[] gradientWorkspace;
    private int[] terminationCode;
    private double[][] hessianWorkSpace;
    private double[] diagonalWorkspace;
    private UncminForJava uncmin;
    private FunctionController controller;
    private OptimizationMode optimizationMode = OptimizationMode.Function;

    public FunctionOptimizer(int dimension) {
        this();
        this.setDimension(dimension);
    }

    public FunctionOptimizer() {
        this.controller = new ParallelFunctionController();
        this.controller.setAssembler(new AdditiveFunctionAssembler());
        this.uncmin = new UncminForJava(this.controller);
        this.setDimension(5);
    }

    public void setFunctionAssembler(FunctionAssembler assembler) {
        this.controller.setAssembler(assembler);
    }

    public void setFunctionController(FunctionController controller) {
        this.controller = controller;
        this.uncmin = new UncminForJava(controller);
    }

    public double[] optimizeFunction(OptimizableFunction function) {
        double[] typsiz = new double[this.dimension + 1];
        double[] fscale = new double[2];
        int[] method = new int[2];
        int[] iexp = new int[2];
        int[] msg = new int[2];
        int[] ndigit = new int[2];
        int[] itnlim = new int[2];
        int[] iagflg = new int[2];
        int[] iahflg = new int[2];
        double[] dlt = new double[2];
        double[] gradtl = new double[2];
        double[] stepmx = new double[2];
        double[] steptl = new double[2];
        if (this.optimizationMode == OptimizationMode.Function) {
            this.uncmin.optimizeFunction0(this.dimension, this.initialX, function, this.workSpaceX, this.functionValueAtX, this.gradientWorkspace, this.terminationCode, this.hessianWorkSpace, this.diagonalWorkspace);
        } else if (this.optimizationMode == OptimizationMode.Gradient) {
            UncminForJava.initialize(this.dimension, this.initialX, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl);
            iagflg[1] = 1;
            iahflg[1] = 0;
            iexp[1] = 0;
            this.uncmin.optimizeFunction7(this.dimension, this.initialX, function, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, this.workSpaceX, this.functionValueAtX, this.gradientWorkspace, this.terminationCode, this.hessianWorkSpace, this.diagonalWorkspace);
        } else if (this.optimizationMode == OptimizationMode.Hessian) {
            UncminForJava.initialize(this.dimension, this.initialX, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl);
            iagflg[1] = 1;
            iahflg[1] = 1;
            iexp[1] = 0;
            this.uncmin.optimizeFunction7(this.dimension, this.initialX, function, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, this.workSpaceX, this.functionValueAtX, this.gradientWorkspace, this.terminationCode, this.hessianWorkSpace, this.diagonalWorkspace);
        }
        return this.getOptimum();
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.initialX = new double[dimension];
        this.workSpaceX = new double[dimension + 1];
        this.functionValueAtX = new double[2];
        this.gradientWorkspace = new double[dimension + 1];
        this.terminationCode = new int[2];
        this.hessianWorkSpace = new double[dimension + 1][dimension + 1];
        this.diagonalWorkspace = new double[dimension + 1];
    }

    public void setInitialX(double[] x) {
        this.initialX = x.length > this.dimension ? Arrays.copyOfRange(x, 0, this.dimension) : x;
    }

    public double[] getOptimum() {
        return Arrays.copyOfRange(this.workSpaceX, 1, this.workSpaceX.length);
    }

    public double[] getGradientAtOptimum() {
        return Arrays.copyOfRange(this.gradientWorkspace, 1, this.gradientWorkspace.length);
    }

    public double getFunctionAtOptimum() {
        return this.functionValueAtX[1];
    }

    public double[][] getHessianAtOptimum() {
        double[][] hessian = new double[this.hessianWorkSpace.length - 1][this.hessianWorkSpace.length - 1];
        for (int i = 0; i < hessian.length; ++i) {
            System.arraycopy(this.hessianWorkSpace[i + 1], 1, hessian[i], 0, hessian[i].length);
        }
        return hessian;
    }

    public OptimizationMode getOptimizationMode() {
        return this.optimizationMode;
    }

    public void setOptimizationMode(OptimizationMode optimizationMode) {
        this.optimizationMode = optimizationMode;
    }

    public TerminationCode getTerminationCode() {
        switch (this.terminationCode[1]) {
            case 0: {
                return TerminationCode.OptimalSolution;
            }
            case 1: {
                return TerminationCode.GradientSmall;
            }
            case 2: {
                return TerminationCode.StepsizeSmall;
            }
            case 3: {
                return TerminationCode.LowestPointFound;
            }
            case 4: {
                return TerminationCode.IterationLimit;
            }
            case 5: {
                return TerminationCode.TooManyLargeStepsProbableUnboundFunction;
            }
        }
        return null;
    }

    public static enum TerminationCode {
        OptimalSolution,
        GradientSmall,
        StepsizeSmall,
        LowestPointFound,
        IterationLimit,
        TooManyLargeStepsProbableUnboundFunction;

    }

    public static enum OptimizationMode {
        Function,
        Gradient,
        Hessian;

    }
}

