/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import com.joptimizer.util.CholeskyFactorization;
import com.joptimizer.util.Utils;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class CholeskyFactorizationTest
extends TestCase {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testInvert1() throws Exception {
        this.log.debug((Object)"testInvert1");
        double[][] QData = new double[][]{{1.0, 0.12, 0.13, 0.14, 0.15}, {0.12, 2.0, 0.23, 0.24, 0.25}, {0.13, 0.23, 3.0, 0.0, 0.0}, {0.14, 0.24, 0.0, 4.0, 0.0}, {0.15, 0.25, 0.0, 0.0, 5.0}};
        RealMatrix Q = MatrixUtils.createRealMatrix((double[][])QData);
        CholeskyFactorization myc = new CholeskyFactorization(QData);
        Array2DRowRealMatrix L = new Array2DRowRealMatrix(myc.getL());
        Array2DRowRealMatrix LT = new Array2DRowRealMatrix(myc.getLT());
        this.log.debug((Object)("L: " + L));
        this.log.debug((Object)("LT: " + LT));
        this.log.debug((Object)("L.LT: " + L.multiply((RealMatrix)LT)));
        this.log.debug((Object)("LT.L: " + LT.multiply((RealMatrix)L)));
        double norm = L.multiply((RealMatrix)LT).subtract(Q).getNorm();
        this.log.debug((Object)("norm: " + norm));
        CholeskyFactorizationTest.assertTrue((norm < 1.0E-15 ? 1 : 0) != 0);
        RealMatrix LInv = new SingularValueDecomposition((RealMatrix)L).getSolver().getInverse();
        this.log.debug((Object)("LInv: " + ArrayUtils.toString((Object)LInv.getData())));
        RealMatrix LInvT = LInv.transpose();
        this.log.debug((Object)("LInvT: " + ArrayUtils.toString((Object)LInvT.getData())));
        RealMatrix LTInv = new SingularValueDecomposition((RealMatrix)LT).getSolver().getInverse();
        this.log.debug((Object)("LTInv: " + ArrayUtils.toString((Object)LTInv.getData())));
        RealMatrix LTInvT = LTInv.transpose();
        this.log.debug((Object)("LTInvT: " + ArrayUtils.toString((Object)LTInvT.getData())));
        this.log.debug((Object)("LInv.LInvT: " + ArrayUtils.toString((Object)LInv.multiply(LInvT).getData())));
        this.log.debug((Object)("LTInv.LTInvT: " + ArrayUtils.toString((Object)LTInv.multiply(LTInvT).getData())));
        RealMatrix Id = MatrixUtils.createRealIdentityMatrix((int)Q.getRowDimension());
        norm = Q.multiply(LTInv.multiply(LInv)).subtract(Id).getNorm();
        this.log.debug((Object)("norm: " + norm));
        CholeskyFactorizationTest.assertTrue((norm < 5.0E-15 ? 1 : 0) != 0);
        RealMatrix QInv = MatrixUtils.createRealMatrix((double[][])myc.getInverse());
        norm = Q.multiply(QInv).subtract(Id).getNorm();
        this.log.debug((Object)("norm: " + norm));
        CholeskyFactorizationTest.assertTrue((norm < 1.0E-15 ? 1 : 0) != 0);
        double det1 = Utils.calculateDeterminant(QData, QData.length);
        double det2 = 1.0;
        List<Double> eigenvalues = myc.getEigenvalues();
        for (double ev : eigenvalues) {
            det2 *= ev;
        }
        this.log.debug((Object)("det1: " + det1));
        this.log.debug((Object)("det2: " + det2));
        CholeskyFactorizationTest.assertEquals((double)det1, (double)det2, (double)1.0E-13);
    }
}

