/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class CholeskyTest
extends TestCase {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testDecomposition1() throws Exception {
        this.log.debug((Object)"testDecomposition1");
        Array2DRowRealMatrix P1 = new Array2DRowRealMatrix((double[][])new double[][]{{8.08073550734687, 1.59028724315583}, {1.59028724315583, 0.3250861184011492}});
        CholeskyDecomposition cFact1 = new CholeskyDecomposition((RealMatrix)P1);
        this.log.debug((Object)("L: " + cFact1.getL()));
        this.log.debug((Object)("LT: " + cFact1.getLT()));
        RealMatrix P1Inv = cFact1.getL().multiply(cFact1.getLT());
        double norm1 = P1Inv.subtract((RealMatrix)P1).getNorm();
        this.log.debug((Object)("norm1: " + norm1));
        CholeskyTest.assertTrue((norm1 < 1.0E-12 ? 1 : 0) != 0);
    }

    public void testDecomposition2() throws Exception {
        this.log.debug((Object)"testDecomposition2");
        Array2DRowRealMatrix P1 = new Array2DRowRealMatrix((double[][])new double[][]{{8.185301256666552E9, 1.5977225251367908E9}, {1.5977225251367908E9, 3.118660129093004E8}});
        CholeskyDecomposition cFact1 = new CholeskyDecomposition((RealMatrix)P1);
        this.log.debug((Object)("L: " + cFact1.getL()));
        this.log.debug((Object)("LT: " + cFact1.getLT()));
        double norm1 = cFact1.getL().multiply(cFact1.getLT()).subtract((RealMatrix)P1).getNorm();
        this.log.debug((Object)("norm1: " + norm1));
        CholeskyTest.assertTrue((norm1 < 1.0E-5 ? 1 : 0) != 0);
        DescriptiveStatistics ds = new DescriptiveStatistics(new double[]{8.5E9, 0.00572});
        RealMatrix P2 = P1.scalarMultiply(1.0 / ds.getGeometricMean());
        CholeskyDecomposition cFact2 = new CholeskyDecomposition(P2);
        this.log.debug((Object)("L: " + cFact2.getL()));
        this.log.debug((Object)("LT: " + cFact2.getLT()));
        double norm2 = cFact2.getL().multiply(cFact2.getLT()).subtract(P2).getNorm();
        this.log.debug((Object)("norm2: " + norm2));
        CholeskyTest.assertTrue((norm2 < 1.0E-9 ? 1 : 0) != 0);
    }
}

