/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.optimizers.NewtonLEConstrainedFSP;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewtonLEConstrainedFSPTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize() throws Exception {
        this.log.debug((Object)"testOptimize");
        DoubleMatrix2D pMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        double[][] P = pMatrix.assign(Mult.mult(theta)).toArray();
        double[] q = qVector.assign(Mult.mult(-1.0)).toArray();
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, q, 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.8, 0.1, 0.1});
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        NewtonLEConstrainedFSP opt = new NewtonLEConstrainedFSP();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedFSPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        NewtonLEConstrainedFSPTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-16);
        NewtonLEConstrainedFSPTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-16);
        NewtonLEConstrainedFSPTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-16);
    }

    public void testOptimize2() throws Exception {
        this.log.debug((Object)"testOptimize2");
        ConvexMultivariateRealFunction objectiveFunction = new ConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                double x = X[0];
                return x - Math.log(1.0 - x * x);
            }

            @Override
            public double[] gradient(double[] X) {
                double x = X[0];
                return new double[]{1.0 + 2.0 * x / (1.0 - x * x)};
            }

            @Override
            public double[][] hessian(double[] X) {
                double x = X[0];
                return new double[][]{{4.0 * Math.pow(x, 2.0) / Math.pow(1.0 - x * x, 2.0) + 2.0 / (1.0 - x * x)}};
            }

            @Override
            public int getDim() {
                return 1;
            }
        };
        OptimizationRequest or = new OptimizationRequest();
        or.setCheckKKTSolutionAccuracy(true);
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0});
        NewtonLEConstrainedFSP opt = new NewtonLEConstrainedFSP();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedFSPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        NewtonLEConstrainedFSPTest.assertEquals((double)-0.41421356, (double)sol[0], (double)1.0E-7);
        NewtonLEConstrainedFSPTest.assertEquals((double)-0.22598716, (double)value, (double)1.0E-7);
    }

    public void testOptimize3() throws Exception {
        this.log.debug((Object)"testOptimize3");
        ConvexMultivariateRealFunction objectiveFunction = new ConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                double x = X[0];
                double y = X[1];
                return 100.0 * (2.0 * x + y) - Math.log(x) - Math.log(y);
            }

            @Override
            public double[] gradient(double[] X) {
                double x = X[0];
                double y = X[1];
                return new double[]{200.0 - 1.0 / x, 100.0 - 1.0 / y};
            }

            @Override
            public double[][] hessian(double[] X) {
                double x = X[0];
                double y = X[1];
                return new double[][]{{1.0 / Math.pow(x, 2.0), 0.0}, {0.0, 1.0 / Math.pow(y, 2.0)}};
            }

            @Override
            public int getDim() {
                return 2;
            }
        };
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0900980486377967, 0.9099019513622053});
        or.setA(new double[][]{{1.0, 1.0}});
        or.setB(new double[]{1.0});
        NewtonLEConstrainedFSP opt = new NewtonLEConstrainedFSP(true);
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            NewtonLEConstrainedFSPTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        NewtonLEConstrainedFSPTest.assertEquals((double)0.0, (double)sol[0], (double)0.01);
        NewtonLEConstrainedFSPTest.assertEquals((double)1.0, (double)sol[1], (double)0.01);
        NewtonLEConstrainedFSPTest.assertEquals((double)1.0, (double)(sol[0] + sol[1]), (double)1.0E-12);
    }
}

