/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.LogTransformedPosynomial;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.QuadraticMultivariateRealFunction;
import com.joptimizer.functions.StrictlyConvexMultivariateRealFunction;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.util.Utils;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class JOptimizerTest
extends TestCase {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testSimplest() throws Exception {
        this.log.debug((Object)"testSimplest");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setInitialPoint(new double[]{1.0});
        or.setToleranceFeas(1.0E-8);
        or.setTolerance(1.0E-9);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-9);
    }

    public void testNewtownUnconstrained() throws Exception {
        this.log.debug((Object)"testNewtownUnconstrained");
        Array2DRowRealMatrix PMatrix = new Array2DRowRealMatrix((double[][])new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        ArrayRealVector qVector = new ArrayRealVector(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        RealMatrix P = PMatrix.scalarMultiply(theta);
        RealVector q = qVector.mapMultiply(-1.0);
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.getData(), q.toArray(), 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.04, 0.5, 0.46});
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        RealMatrix QInv = Utils.squareMatrixInverse(P);
        RealVector benchSol = QInv.operate(q).mapMultiply(-1.0);
        this.log.debug((Object)("benchSol   : " + ArrayUtils.toString((Object)benchSol.toArray())));
        this.log.debug((Object)("benchValue : " + objectiveFunction.value(benchSol.toArray())));
        JOptimizerTest.assertEquals((double)benchSol.getEntry(0), (double)sol[0], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)benchSol.getEntry(1), (double)sol[1], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)benchSol.getEntry(2), (double)sol[2], (double)1.0E-15);
    }

    public void testNewtonLEConstrainedFSP() throws Exception {
        this.log.debug((Object)"testNewtonLEConstrainedFSP");
        DoubleMatrix2D PMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = PMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        double[][] A = new double[][]{{1.0, 1.0, 1.0}};
        double[] b = new double[]{1.0};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.04, 0.5, 0.46});
        or.setA(A);
        or.setB(b);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-15);
    }

    public void testNewtonLEConstrainedISP() throws Exception {
        this.log.debug((Object)"testNewtonLEConstrainedISP");
        DoubleMatrix2D PMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = PMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{1.0, 1.0, 1.0});
        or.setA(new double[][]{{1.0, 1.0, 1.0}});
        or.setB(new double[]{1.0});
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-15);
    }

    public void testPrimalDualMethod() throws Exception {
        this.log.debug((Object)"testPrimalDualMethod");
        DoubleMatrix2D PMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = PMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        double[][] A = new double[][]{{1.0, 1.0, 1.0}};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.2, 0.6});
        or.setFi(inequalities);
        or.setA(A);
        or.setB(b);
        or.setToleranceFeas(1.0E-12);
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-9);
        JOptimizerTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-9);
        JOptimizerTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-9);
    }

    public void testBarrierMethod() throws Exception {
        this.log.debug((Object)"testBarrierMethod");
        DoubleMatrix2D PMatrix = this.F2.make(new double[][]{{1.68, 0.34, 0.38}, {0.34, 3.09, -1.59}, {0.38, -1.59, 1.54}});
        DoubleMatrix1D qVector = this.F1.make(new double[]{0.018, 0.025, 0.01});
        double theta = 0.01522;
        DoubleMatrix2D P = PMatrix.assign(Mult.mult(theta));
        DoubleMatrix1D q = qVector.assign(Mult.mult(-1.0));
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        double[][] A = new double[][]{{1.0, 1.0, 1.0}};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setInteriorPointMethod("BARRIER_METHOD");
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.3, 0.3, 0.4});
        or.setFi(inequalities);
        or.setA(A);
        or.setB(b);
        or.setTolerance(1.0E-12);
        or.setToleranceInnerStep(1.0E-5);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.04632311555988555, (double)sol[0], (double)1.0E-8);
        JOptimizerTest.assertEquals((double)0.5086308460954377, (double)sol[1], (double)1.0E-8);
        JOptimizerTest.assertEquals((double)0.44504603834467693, (double)sol[2], (double)1.0E-8);
    }

    public void testLinearProgramming2D() throws Exception {
        this.log.debug((Object)"testLinearProgramming2D");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{-1.0, -1.0}, 4.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[4];
        double[][] G = new double[][]{{1.3333333333333333, -1.0}, {-0.5, 1.0}, {-2.0, -1.0}, {0.3333333333333333, 1.0}};
        double[] H = new double[]{2.0, 0.5, 2.0, 0.5};
        inequalities[0] = new LinearMultivariateRealFunction(G[0], -H[0]);
        inequalities[1] = new LinearMultivariateRealFunction(G[1], -H[1]);
        inequalities[2] = new LinearMultivariateRealFunction(G[2], -H[2]);
        inequalities[3] = new LinearMultivariateRealFunction(G[3], -H[3]);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setToleranceFeas(1.0E-9);
        or.setTolerance(1.0E-9);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)1.5, (double)sol[0], (double)1.0E-9);
        JOptimizerTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-9);
    }

    public void testSimpleLinear() throws Exception {
        this.log.debug((Object)"testSimpleLinear");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{1.0, 0.0}, -3.0), new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 1.0}, -3.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setToleranceFeas(1.0E-12);
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-12);
        JOptimizerTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-12);
    }

    public void testQuadraticProgramming2D() throws Exception {
        this.log.debug((Object)"testQuadraticProgramming2D");
        double[][] P = new double[][]{{1.0, 0.4}, {0.4, 1.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        double[][] A = new double[][]{{1.0, 1.0}};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.1, 0.9});
        or.setA(A);
        or.setB(b);
        or.setToleranceFeas(1.0E-12);
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.5, (double)sol[0], (double)1.0E-13);
        JOptimizerTest.assertEquals((double)0.5, (double)sol[1], (double)1.0E-13);
    }

    public void testLinearCostQuadraticInequalityOptimizationProblem() throws Exception {
        this.log.debug((Object)"testLinearCostQuadraticInequalityOptimizationProblem");
        double[] minimizeF = new double[]{-1.0, -1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] qVector = new double[]{0.0, 0.0};
        double r = -2.0;
        inequalities[0] = new QuadraticMultivariateRealFunction(PMatrix, qVector, r);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)Math.sqrt(2.0), (double)sol[0], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)Math.sqrt(2.0), (double)sol[1], (double)1.0E-6);
    }

    public void testLinearCostLinearEqualityQuadraticInequalityOptimizationProblem() throws Exception {
        this.log.debug((Object)"testLinearCostLinearEqualityQuadraticInequalityOptimizationProblem");
        double[] minimizeF = new double[]{1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0};
        double r = 0.0;
        inequalities[0] = new QuadraticMultivariateRealFunction(PMatrix, qVector, r);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setA(equalityAMatrix);
        or.setB(equalityBVector);
        or.setCheckKKTSolutionAccuracy(true);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)(0.5 * (-1.0 - Math.sqrt(17.0))), (double)sol[0], (double)1.0E-5);
        JOptimizerTest.assertEquals((double)(0.5 * (9.0 + Math.sqrt(17.0))), (double)sol[1], (double)1.0E-5);
    }

    public void testSimpleQCQuadraticProgramming() throws Exception {
        this.log.debug((Object)"testSimpleQCQuadraticProgramming");
        double[][] P = new double[][]{{2.0, 0.0}, {0.0, 2.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        double[][] A = new double[][]{{1.0, 1.0}};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 2.0, new double[]{0.0, 0.0})};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.8});
        or.setA(A);
        or.setB(b);
        or.setFi(inequalities);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.5, (double)sol[0], (double)1.0E-10);
        JOptimizerTest.assertEquals((double)0.5, (double)sol[1], (double)1.0E-10);
    }

    public void testQCQuadraticProgramming() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{0.0, 1.0}, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] P1 = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] c1 = new double[]{0.0, -1.0};
        inequalities[0] = new QuadraticMultivariateRealFunction(P1, c1, -1.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{1.2, 2.0});
        or.setFi(inequalities);
        or.setCheckKKTSolutionAccuracy(true);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)-1.0, (double)sol[1], (double)1.0E-7);
    }

    public void testLinearProgramming() throws Exception {
        this.log.debug((Object)"testLinearProgramming");
        double[] c0 = new double[]{0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c0, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[2];
        double[] c1 = new double[]{-1.0, -1.0};
        inequalities[0] = new LinearMultivariateRealFunction(c1, 0.0);
        double[] c2 = new double[]{1.0, -1.0};
        inequalities[1] = new LinearMultivariateRealFunction(c2, -1.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{1.4, 0.5});
        or.setFi(inequalities);
        or.setMu(100.0);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.5, (double)sol[0], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)-0.5, (double)sol[1], (double)1.0E-6);
    }

    public void testQCQuadraticProgramming2() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming2");
        double[][] P = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{2.0, 2.0});
        or.setToleranceFeas(1.0E-12);
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-15);
        JOptimizerTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-15);
    }

    public void testQCQuadraticProgramming2D() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming2D");
        double[][] P = new double[][]{{1.0, 0.4}, {0.4, 1.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.75, new double[]{-2.0, -2.0})};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{-2.0, -2.0});
        or.setFi(inequalities);
        or.setCheckKKTSolutionAccuracy(true);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[0], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[1], (double)1.0E-7);
    }

    public void testQCQuadraticProgramming2DNoInitialPoint() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming2DNoInitialPoint");
        double[][] P = new double[][]{{1.0, 0.4}, {0.4, 1.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 1.75, new double[]{-2.0, -2.0})};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setCheckKKTSolutionAccuracy(true);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[0], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[1], (double)1.0E-7);
    }

    public void testQCQuadraticProgramming2DNoInitialPointPhaseI() throws Exception {
        this.log.debug((Object)"testQCQuadraticProgramming2DNoInitialPointPhaseI");
        double[] f0 = new double[]{0.0, 0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(f0, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new ConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                double x = X[0];
                double y = X[1];
                double s = X[2];
                return Math.pow(x + 2.0, 2.0) + Math.pow(y + 2.0, 2.0) - 1.75 - s;
            }

            @Override
            public double[] gradient(double[] X) {
                double x = X[0];
                double y = X[1];
                double s = X[2];
                return new double[]{2.0 * (x + 2.0), 2.0 * (y + 2.0), -1.0};
            }

            @Override
            public double[][] hessian(double[] X) {
                double x = X[0];
                double y = X[1];
                double s = X[2];
                double[][] ret = new double[3][3];
                ret[0][0] = 2.0;
                ret[1][1] = 2.0;
                return ret;
            }

            @Override
            public int getDim() {
                return 3;
            }
        }};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{-2.0, -2.0, 10.0});
        or.setFi(inequalities);
        or.setCheckKKTSolutionAccuracy(true);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)-2.0, (double)sol[0], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)-2.0, (double)sol[1], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)-1.75, (double)sol[2], (double)1.0E-7);
    }

    public void testSOConeProgramming2D() throws Exception {
        this.log.debug((Object)"testSOConeProgramming2D");
        double[] c = new double[]{-1.0, -1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c, 6.0);
        double[][] A = new double[][]{{0.25, -1.0}};
        double[] b = new double[]{0.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[4];
        double[][] P1 = new double[][]{{-0.2222222222222222, 0.0}, {0.0, 2.0}};
        double[] Q1 = new double[]{-0.2222222222222222, 0.0};
        double r1 = -0.1111111111111111;
        inequalities[0] = new QuadraticMultivariateRealFunction(P1, Q1, r1);
        inequalities[1] = new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, -1.0);
        double[][] P2 = new double[][]{{-0.5, 0.0}, {0.0, 2.0}};
        double[] Q2 = new double[]{1.0, 0.0};
        double r2 = -1.0;
        inequalities[2] = new QuadraticMultivariateRealFunction(P2, Q2, r2);
        inequalities[3] = new LinearMultivariateRealFunction(new double[]{1.0, 0.0}, -2.0);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.0, 0.0});
        or.setFi(inequalities);
        or.setA(A);
        or.setB(b);
        or.setToleranceFeas(1.0E-6);
        or.setTolerance(2.0E-6);
        or.setMaxIteration(500);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)1.3333333333333333, (double)sol[0], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)0.3333333333333333, (double)sol[1], (double)1.0E-6);
    }

    public void testSemidefiniteProgramming() throws Exception {
        this.log.debug((Object)"testSemidefiniteProgramming");
        double[] c = new double[]{0.0, 0.0, 1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(c, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[2];
        double[][] P0 = new double[][]{{1.0, 0.4, 0.0}, {0.4, 1.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] q0 = new double[]{0.0, 0.0, -1.0};
        double r0 = 0.0;
        inequalities[0] = new QuadraticMultivariateRealFunction(P0, q0, r0);
        double[][] P1 = new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] q1 = new double[]{4.0, 4.0, 0.0};
        double r1 = 8.0 - Math.pow(1.75, 2.0);
        inequalities[1] = new QuadraticMultivariateRealFunction(P1, q1, r1);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{-2.0, -2.0, 10.0});
        or.setFi(inequalities);
        or.setTolerance(1.0E-10);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[0], (double)1.0E-11);
        JOptimizerTest.assertEquals((double)(-2.0 + 1.75 / Math.sqrt(2.0)), (double)sol[1], (double)1.0E-11);
    }

    public void testGeometricProgramming1() throws Exception {
        this.log.debug((Object)"testGeometricProgramming1");
        double[] a01 = new double[]{1.0};
        double b01 = 0.0;
        double[] a11 = new double[]{-1.0};
        double b11 = Math.log(2.0);
        double[] a21 = new double[]{1.0};
        double b21 = Math.log(0.3333333333333333);
        LogTransformedPosynomial objectiveFunction = new LogTransformedPosynomial(new double[][]{a01}, new double[]{b01});
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LogTransformedPosynomial(new double[][]{a11}, new double[]{b11}), new LogTransformedPosynomial(new double[][]{a21}, new double[]{b21})};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setInitialPoint(new double[]{Math.log(2.5)});
        or.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)Math.log(2.0), (double)sol[0], (double)1.0E-11);
    }

    public void testGeometricProgramming2D() throws Exception {
        this.log.debug((Object)"testGeometricProgramming2D");
        double[] a01 = new double[]{2.0, 1.0};
        double b01 = 0.0;
        double[] a02 = new double[]{3.0, 1.0};
        double b02 = 0.0;
        LogTransformedPosynomial objectiveFunction = new LogTransformedPosynomial(new double[][]{a01, a02}, new double[]{b01, b02});
        double[] a11 = new double[]{1.0, 0.0};
        double b11 = Math.log(1.0);
        double[] a21 = new double[]{0.0, 1.0};
        double b21 = Math.log(1.0);
        double[] a31 = new double[]{-1.0, -1.0};
        double b31 = Math.log(0.7);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LogTransformedPosynomial(new double[][]{a11}, new double[]{b11}), new LogTransformedPosynomial(new double[][]{a21}, new double[]{b21}), new LogTransformedPosynomial(new double[][]{a31}, new double[]{b31})};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setInitialPoint(new double[]{Math.log(0.9), Math.log(0.9)});
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)Math.log(0.7), (double)sol[0], (double)1.0E-8);
        JOptimizerTest.assertEquals((double)Math.log(1.0), (double)sol[1], (double)1.0E-8);
    }

    public void testOptimize7() throws Exception {
        this.log.debug((Object)"testOptimize7");
        StrictlyConvexMultivariateRealFunction objectiveFunction = new StrictlyConvexMultivariateRealFunction(){

            @Override
            public double value(double[] X) {
                DoubleMatrix1D Z = JOptimizerTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Math.exp(Z.zDotProduct(Z));
            }

            @Override
            public double[] gradient(double[] X) {
                DoubleMatrix1D Z = JOptimizerTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                return Z.assign(Mult.mult(2.0 * Math.exp(Z.zDotProduct(Z)))).toArray();
            }

            @Override
            public double[][] hessian(double[] X) {
                DoubleMatrix1D Z = JOptimizerTest.this.F1.make(new double[]{X[0] - 1.0, X[1] - 2.0});
                double d = Math.exp(Z.zDotProduct(Z));
                DoubleMatrix2D ID = JOptimizerTest.this.F2.identity(2);
                DoubleMatrix2D ret = JOptimizerTest.this.ALG.multOuter(Z, Z, null).assign(ID, Functions.plus).assign(Mult.mult(2.0 * d));
                return ret.toArray();
            }

            @Override
            public int getDim() {
                return 2;
            }
        };
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{FunctionsUtils.createCircle(2, 3.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{0.2, 0.2});
        or.setFi(inequalities);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        JOptimizerTest.assertEquals((double)1.0, (double)sol[0], (double)1.0E-7);
        JOptimizerTest.assertEquals((double)2.0, (double)sol[1], (double)1.0E-7);
    }

    public void testQP() throws Exception {
        this.log.debug((Object)"testQP");
        double[][] pMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(pMatrix, null, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{1.0, 0.0, 0.0}, 10.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setInitialPoint(new double[]{-11.0, 1.0, 1.0});
        or.setFi(inequalities);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
        JOptimizerTest.assertEquals((double)-10.0, (double)sol[0], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)0.0, (double)sol[1], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)0.0, (double)sol[2], (double)1.0E-6);
        JOptimizerTest.assertEquals((double)50.0, (double)value, (double)1.0E-6);
    }

    public void testQPScala() throws Exception {
        this.log.debug((Object)"testQPScala");
        double[][] P = new double[2][2];
        P[0] = new double[]{1.0, 0.4};
        P[1] = new double[]{0.4, 1.0};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        double[][] A = new double[1][2];
        A[0] = new double[]{1.0, 1.0};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, -0.2), new LinearMultivariateRealFunction(new double[]{0.0, -1.0}, -0.2), new LinearMultivariateRealFunction(new double[]{-1.0, -1.0}, 0.9), new LinearMultivariateRealFunction(new double[]{1.0, 1.0}, -1.1)};
        OptimizationRequest OR = new OptimizationRequest();
        OR.setF0(objectiveFunction);
        OR.setA(A);
        OR.setB(b);
        OR.setFi(inequalities);
        OR.setToleranceFeas(1.0E-12);
        OR.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(OR);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        double[] res = opt.getOptimizationResponse().getSolution();
        int status = opt.getOptimizationResponse().getReturnCode();
        this.log.debug((Object)("status : " + status));
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)res)));
    }

    public void testQPScala2() throws Exception {
        this.log.debug((Object)"testQPScala2");
        double[][] P = new double[4][4];
        P[0] = new double[]{0.08, -0.05, -0.05, -0.05};
        P[1] = new double[]{-0.05, 0.16, -0.02, -0.02};
        P[2] = new double[]{-0.05, -0.02, 0.35, 0.06};
        P[3] = new double[]{-0.05, -0.02, 0.06, 0.35};
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P, null, 0.0);
        double[][] A = new double[1][2];
        A[0] = new double[]{1.0, 1.0};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{1.0, 1.0, 1.0, 1.0}, -10000.0), new LinearMultivariateRealFunction(new double[]{-0.05, 0.2, -0.15, -0.3}, -1000.0), new LinearMultivariateRealFunction(new double[]{-1.0, 0.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, -1.0, 0.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, -1.0, 0.0}, 0.0), new LinearMultivariateRealFunction(new double[]{0.0, 0.0, 0.0, -1.0}, 0.0)};
        OptimizationRequest OR = new OptimizationRequest();
        OR.setF0(objectiveFunction);
        OR.setFi(inequalities);
        OR.setToleranceFeas(1.0E-12);
        OR.setTolerance(1.0E-12);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(OR);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        double[] res = opt.getOptimizationResponse().getSolution();
        int status = opt.getOptimizationResponse().getReturnCode();
        this.log.debug((Object)("status : " + status));
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)res)));
    }

    public void testLP() throws Exception {
        this.log.debug((Object)"testLP");
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(new double[]{0.0, 100.0}, 0.0);
        double[][] A = new double[1][2];
        A[0] = new double[]{1.0, -1.0};
        double[] b = new double[]{1.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0, 0.0}, 0.0)};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(A);
        or.setB(b);
        or.setFi(inequalities);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertEquals((double)0.0, (double)sol[0], (double)1.0E-9);
        JOptimizerTest.assertEquals((double)-1.0, (double)sol[1], (double)1.0E-9);
    }

    public void testLFProgramming2D() throws Exception {
        this.log.debug((Object)"testLFProgramming2D");
        double[] n = new double[]{2.0, 4.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(n, 0.0);
        double[][] Gmh = new double[][]{{-1.0, 1.0, 0.0}, {3.0, 1.0, -3.2}, {0.2, -1.0, 0.32}, {0.0, 0.0, -1.0}};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[4];
        for (int i = 0; i < 4; ++i) {
            inequalities[i] = new LinearMultivariateRealFunction(Gmh[i], 0.0);
        }
        double[][] Amb = new double[][]{{2.0, 3.0, 0.0}};
        double[] bm = new double[]{1.0};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(Amb);
        or.setB(bm);
        or.setFi(inequalities);
        or.setTolerance(1.0E-6);
        or.setToleranceFeas(1.0E-6);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        double x = sol[0] / sol[2];
        double y = sol[1] / sol[2];
        JOptimizerTest.assertEquals((double)0.9, (double)x, (double)1.0E-5);
        JOptimizerTest.assertEquals((double)0.5, (double)y, (double)1.0E-5);
    }

    public void testCCFProgramming2D() throws Exception {
        this.log.debug((Object)"testCCFProgramming2D");
        double[] n = new double[]{2.0, 4.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(n, 0.0);
        double c0 = 0.65;
        double c1 = 0.65;
        double R = 0.25;
        double[][] PMatrix = new double[][]{{1.0, 0.0, -c0}, {0.0, 1.0, -c1}, {-c0, -c1, c0 * c0 + c1 * c1 - R * R}};
        double[][] Gmh = new double[][]{{0.0, 0.0, -1.0}};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new QuadraticMultivariateRealFunction(PMatrix, null, 0.0), new LinearMultivariateRealFunction(Gmh[0], 0.0)};
        double[][] Amb = new double[][]{{2.0, 3.0, 0.0}};
        double[] bm = new double[]{1.0};
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setA(Amb);
        or.setB(bm);
        or.setFi(inequalities);
        or.setTolerance(1.0E-6);
        or.setToleranceFeas(1.0E-6);
        or.setNotFeasibleInitialPoint(new double[]{0.6, -0.06666666666666667, 0.1});
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + objectiveFunction.value(sol)));
        double x = sol[0] / sol[2];
        double y = sol[1] / sol[2];
        JOptimizerTest.assertEquals((double)0.772036, (double)x, (double)1.0E-6);
        JOptimizerTest.assertEquals((double)0.43181, (double)y, (double)1.0E-6);
    }

    public void testLinearProgramming7D() throws Exception {
        this.log.debug((Object)"testLinearProgramming7D");
        double[] CVector = new double[]{0.0, 0.0, 0.0, 1.0, 0.833, 0.833, 0.833};
        double[][] AMatrix = new double[][]{{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0}};
        double[] BVector = new double[]{1.0};
        double[][] GMatrix = new double[][]{{0.014, 0.009, 0.021, 1.0, 1.0, 0.0, 0.0}, {0.001, 0.002, -0.002, 1.0, 0.0, 1.0, 0.0}, {0.003, -0.005, 0.002, 1.0, 0.0, 0.0, 1.0}, {0.006, 0.002, 0.007, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}};
        double[] HVector = new double[]{0.0, 0.0, 0.0, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(CVector, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[GMatrix.length];
        for (int i = 0; i < GMatrix.length; ++i) {
            inequalities[i] = new LinearMultivariateRealFunction(new ArrayRealVector(GMatrix[i]).mapMultiply(-1.0).toArray(), -HVector[i]);
        }
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        or.setFi(inequalities);
        or.setA(AMatrix);
        or.setB(BVector);
        or.setInitialPoint(new double[]{0.25, 0.25, 0.5, 0.01, 0.01, 0.01, 0.01});
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            JOptimizerTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        this.log.debug((Object)("sol: " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value  : " + objectiveFunction.value(sol)));
        JOptimizerTest.assertTrue((sol[0] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertTrue((sol[1] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertTrue((sol[2] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertTrue((sol[4] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertTrue((sol[5] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertTrue((sol[6] > 0.0 ? 1 : 0) != 0);
        JOptimizerTest.assertEquals((double)(sol[0] + sol[1] + sol[2]), (double)1.0, (double)1.0E-8);
        JOptimizerTest.assertTrue((0.006 * sol[0] + 0.002 * sol[1] + 0.007 * sol[2] > 0.001 ? 1 : 0) != 0);
    }
}

