/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.optimizers.PrimalDualMethod;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPhaseIPDM {
    private PrimalDualMethod originalProblem;
    private int originalDim = -1;
    private int dim = -1;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public BasicPhaseIPDM(PrimalDualMethod originalProblem) {
        this.originalProblem = originalProblem;
        this.originalDim = originalProblem.getDim();
        this.dim = originalProblem.getDim() + 1;
    }

    public DoubleMatrix1D findFeasibleInitialPoint() throws Exception {
        int maxIneqIndex;
        DoubleMatrix1D originalFiX0;
        DoubleMatrix1D X0;
        this.log.debug((Object)"findFeasibleInitialPoint");
        OptimizationRequest or = new OptimizationRequest();
        DoubleMatrix1D C = this.F1.make(this.dim);
        C.set(this.dim - 1, 1.0);
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(C.toArray(), 0.0);
        or.setF0(objectiveFunction);
        or.setToleranceFeas(this.originalProblem.getToleranceFeas());
        or.setTolerance(this.originalProblem.getTolerance());
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[this.originalProblem.getFi().length];
        for (int i = 0; i < inequalities.length; ++i) {
            ConvexMultivariateRealFunction fi;
            final ConvexMultivariateRealFunction originalFi = this.originalProblem.getFi()[i];
            inequalities[i] = fi = new ConvexMultivariateRealFunction(){

                @Override
                public double value(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, BasicPhaseIPDM.this.originalDim);
                    return originalFi.value(X.toArray()) - y.get(BasicPhaseIPDM.this.dim - 1);
                }

                @Override
                public double[] gradient(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, BasicPhaseIPDM.this.originalDim);
                    DoubleMatrix1D origGrad = BasicPhaseIPDM.this.F1.make(originalFi.gradient(X.toArray()));
                    DoubleMatrix1D ret = BasicPhaseIPDM.this.F1.make(1, -1.0);
                    ret = BasicPhaseIPDM.this.F1.append(origGrad, ret);
                    return ret.toArray();
                }

                @Override
                public double[][] hessian(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, BasicPhaseIPDM.this.originalDim);
                    double[][] originalFiHess = originalFi.hessian(X.toArray());
                    if (originalFiHess == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER) {
                        return FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER;
                    }
                    DoubleMatrix2D origHess = originalFiHess != FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER ? BasicPhaseIPDM.this.F2.make(originalFi.hessian(X.toArray())) : BasicPhaseIPDM.this.F2.make(X.size(), X.size());
                    DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{origHess, null}, {null, BasicPhaseIPDM.this.F2.make(1, 1)}};
                    return BasicPhaseIPDM.this.F2.compose(parts).toArray();
                }

                @Override
                public int getDim() {
                    return BasicPhaseIPDM.this.dim;
                }
            };
        }
        or.setFi(inequalities);
        DoubleMatrix2D AEorig = this.originalProblem.getA();
        DoubleMatrix1D BEorig = this.originalProblem.getB();
        if (AEorig != null) {
            DoubleMatrix2D zeroCols = this.F2.make(AEorig.rows(), 1);
            DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{AEorig, zeroCols}};
            DoubleMatrix2D AE = this.F2.compose(parts);
            DoubleMatrix1D BE = BEorig.copy();
            or.setA(AE.toArray());
            or.setB(BE.toArray());
        }
        if ((X0 = this.originalProblem.getNotFeasibleInitialPoint()) == null) {
            X0 = AEorig != null ? this.findOneRoot(AEorig.toArray(), BEorig.toArray()) : this.F1.make(this.originalProblem.getDim(), 1.0 / (double)this.originalProblem.getDim());
        }
        if (AEorig != null) {
            DoubleMatrix1D originalRPriX0 = AEorig.zMult(X0, BEorig.copy(), 1.0, -1.0, false);
            double norm = Math.sqrt(this.ALG.norm2(originalRPriX0));
            this.log.debug((Object)("norm: " + norm));
            if (norm > this.originalProblem.getToleranceFeas()) {
                throw new Exception("The initial point for Basic Phase I Method must be equalities-feasible");
            }
        }
        if ((originalFiX0 = this.originalProblem.getFi(X0)).get(maxIneqIndex = Utils.getMaxIndex(originalFiX0.toArray())) + this.originalProblem.getTolerance() < 0.0) {
            return X0;
        }
        DoubleMatrix1D initialPoint = this.F1.make(1, Math.sqrt(this.originalProblem.getToleranceFeas()));
        initialPoint = this.F1.append(X0, initialPoint);
        for (int i = 0; i < originalFiX0.size(); ++i) {
            initialPoint.set(this.dim - 1, Math.max(initialPoint.get(this.dim - 1), originalFiX0.get(i) * Math.pow(this.originalProblem.getToleranceFeas(), -0.5)));
        }
        or.setInitialPoint(initialPoint.toArray());
        PhaseIPrimalDualMethod opt = new PhaseIPrimalDualMethod();
        opt.setOptimizationRequest(or);
        if (opt.optimize() == 2) {
            throw new Exception("Failed to find an initial feasible point");
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        DoubleMatrix1D sol = this.F1.make(response.getSolution());
        DoubleMatrix1D ret = sol.viewPart(0, this.originalDim);
        DoubleMatrix1D ineq = this.originalProblem.getFi(ret);
        maxIneqIndex = Utils.getMaxIndex(ineq.toArray());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ineq        : " + ArrayUtils.toString((Object)ineq.toArray())));
            this.log.debug((Object)("max ineq pos: " + maxIneqIndex));
            this.log.debug((Object)("max ineq val: " + ineq.get(maxIneqIndex)));
        }
        if (ineq.get(maxIneqIndex) >= 0.0) {
            throw new Exception("Infeasible problem");
        }
        return ret;
    }

    private DoubleMatrix1D findOneRoot(double[][] A, double[] b) throws Exception {
        return this.F1.make(this.originalProblem.findEqFeasiblePoint(A, b));
    }

    private class PhaseIPrimalDualMethod
    extends PrimalDualMethod {
        private PhaseIPrimalDualMethod() {
        }

        @Override
        protected boolean checkCustomExitConditions(DoubleMatrix1D Y) {
            int ineqMaxIndex;
            DoubleMatrix1D X = Y.viewPart(0, BasicPhaseIPDM.this.dim - 1);
            DoubleMatrix1D ineqX = BasicPhaseIPDM.this.originalProblem.getFi(X);
            boolean b1 = ineqX.get(ineqMaxIndex = Utils.getMaxIndex(ineqX.toArray())) + this.getTolerance() < 0.0 || Y.get(Y.size() - 1) < 0.0;
            DoubleMatrix1D originalRPriX = BasicPhaseIPDM.this.F1.make(0);
            if (this.getA() != null) {
                originalRPriX = BasicPhaseIPDM.this.originalProblem.getA().zMult(X, BasicPhaseIPDM.this.originalProblem.getB().copy(), 1.0, -1.0, false);
            }
            boolean b2 = Math.sqrt(BasicPhaseIPDM.this.ALG.norm2(originalRPriX)) < BasicPhaseIPDM.this.originalProblem.getToleranceFeas();
            BasicPhaseIPDM.this.log.debug((Object)("b1: " + b1));
            BasicPhaseIPDM.this.log.debug((Object)("b2: " + b2));
            BasicPhaseIPDM.this.log.debug((Object)("checkCustomExitConditions: " + (b1 && b2)));
            return b1 && b2;
        }
    }
}

