/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;

public class LogTransformedPosynomial
implements ConvexMultivariateRealFunction {
    private DoubleMatrix2D A = null;
    private DoubleMatrix2D AT = null;
    private DoubleMatrix1D b = null;
    private int dim = -1;
    private Algebra ALG = Algebra.DEFAULT;

    public LogTransformedPosynomial(double[][] akArray, double[] bkArray) {
        this.A = DoubleFactory2D.dense.make(akArray);
        this.b = DoubleFactory1D.dense.make(bkArray);
        if (this.A.rows() != this.b.size()) {
            throw new IllegalArgumentException("Impossible to create the function");
        }
        this.AT = this.ALG.transpose(this.A);
        this.dim = this.A.columns();
    }

    @Override
    public double value(double[] X) {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
        DoubleMatrix1D g = this.ALG.mult(this.A, x).assign(this.b, Functions.plus).assign(Functions.exp);
        return Math.log(g.zSum());
    }

    @Override
    public double[] gradient(double[] X) {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
        DoubleMatrix1D g = this.ALG.mult(this.A, x).assign(this.b, Functions.plus).assign(Functions.exp);
        double den = g.zSum();
        double[] R = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            double d = 0.0;
            for (int k = 0; k < this.A.rows(); ++k) {
                d += g.get(k) * this.A.get(k, i);
            }
            R[i] = d / den;
        }
        return R;
    }

    @Override
    public double[][] hessian(double[] X) {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
        DoubleMatrix1D g = this.ALG.mult(this.A, x).assign(this.b, Functions.plus).assign(Functions.exp);
        double den = g.zSum();
        DoubleMatrix1D r = DoubleFactory1D.dense.make(this.dim);
        for (int i = 0; i < this.dim; ++i) {
            double d = 0.0;
            for (int k = 0; k < this.A.rows(); ++k) {
                d += g.get(k) * this.A.get(k, i);
            }
            r.set(i, d);
        }
        DoubleMatrix2D ret = DoubleFactory2D.dense.make(this.dim, this.dim);
        ret.assign(this.ALG.multOuter(r, r, null).assign(Mult.mult(-1.0 / Math.pow(den, 2.0))), Functions.plus);
        for (int k = 0; k < this.A.rows(); ++k) {
            ret.assign(this.ALG.multOuter(this.A.viewRow(k), this.A.viewRow(k), null).assign(Mult.mult(g.get(k))).assign(Mult.mult(1.0 / den)), Functions.plus);
        }
        return ret.toArray();
    }

    @Override
    public int getDim() {
        return this.dim;
    }
}

