/*
 * Decompiled with CFR 0.152.
 */
package com.cureos.numerics;

import com.cureos.numerics.Calcfc;
import com.cureos.numerics.Cobyla;
import com.cureos.numerics.CobylaExitStatus;
import org.junit.Assert;
import org.junit.Test;

public class CobylaTest {
    private double rhobeg = 0.5;
    private double rhoend = 1.0E-6;
    private int iprint = 1;
    private int maxfun = 3500;

    @Test
    public void test01FindMinimum() {
        System.out.format("%nOutput from test problem 1 (Simple quadratic)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                return 10.0 * Math.pow(x[0] + 1.0, 2.0) + Math.pow(x[1], 2.0);
            }
        };
        double[] x = new double[]{1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 2, 0, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{-1.0, 0.0}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test02FindMinimum() {
        System.out.format("%nOutput from test problem 2 (2D unit circle calculation)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 1.0 - x[0] * x[0] - x[1] * x[1];
                return x[0] * x[1];
            }
        };
        double[] x = new double[]{1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 2, 1, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{Math.sqrt(0.5), -Math.sqrt(0.5)}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test03FindMinimum() {
        System.out.format("%nOutput from test problem 3 (3D ellipsoid calculation)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 1.0 - x[0] * x[0] - 2.0 * x[1] * x[1] - 3.0 * x[2] * x[2];
                return x[0] * x[1] * x[2];
            }
        };
        double[] x = new double[]{1.0, 1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 3, 1, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{1.0 / Math.sqrt(3.0), 1.0 / Math.sqrt(6.0), -0.3333333333333333}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test04FindMinimum() {
        System.out.format("%nOutput from test problem 4 (Weak Rosenbrock)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                return Math.pow(x[0] * x[0] - x[1], 2.0) + Math.pow(1.0 + x[0], 2.0);
            }
        };
        double[] x = new double[]{1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 2, 0, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{-1.0, 1.0}, (double[])x, (double)1.0E-4);
    }

    @Test
    public void test05FindMinimum() {
        System.out.format("%nOutput from test problem 5 (Intermediate Rosenbrock)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                return 10.0 * Math.pow(x[0] * x[0] - x[1], 2.0) + Math.pow(1.0 + x[0], 2.0);
            }
        };
        double[] x = new double[]{1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 2, 0, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{-1.0, 1.0}, (double[])x, (double)3.0E-4);
    }

    @Test
    public void test06FindMinimum() {
        System.out.format("%nOutput from test problem 6 (Equation (9.1.15) in Fletcher's book)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = x[1] - x[0] * x[0];
                con[1] = 1.0 - x[0] * x[0] - x[1] * x[1];
                return -x[0] - x[1];
            }
        };
        double[] x = new double[]{1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 2, 2, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{Math.sqrt(0.5), Math.sqrt(0.5)}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test07FindMinimum() {
        System.out.format("%nOutput from test problem 7 (Equation (14.4.2) in Fletcher)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 5.0 * x[0] - x[1] + x[2];
                con[1] = x[2] - x[0] * x[0] - x[1] * x[1] - 4.0 * x[1];
                con[2] = x[2] - 5.0 * x[0] - x[1];
                return x[2];
            }
        };
        double[] x = new double[]{1.0, 1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 3, 3, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{0.0, -3.0, -3.0}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test08FindMinimum() {
        System.out.format("%nOutput from test problem 8 (Rosen-Suzuki)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 8.0 - x[0] * x[0] - x[1] * x[1] - x[2] * x[2] - x[3] * x[3] - x[0] + x[1] - x[2] + x[3];
                con[1] = 10.0 - x[0] * x[0] - 2.0 * x[1] * x[1] - x[2] * x[2] - 2.0 * x[3] * x[3] + x[0] + x[3];
                con[2] = 5.0 - 2.0 * x[0] * x[0] - x[1] * x[1] - x[2] * x[2] - 2.0 * x[0] + x[1] + x[3];
                return x[0] * x[0] + x[1] * x[1] + 2.0 * x[2] * x[2] + x[3] * x[3] - 5.0 * x[0] - 5.0 * x[1] - 21.0 * x[2] + 7.0 * x[3];
            }
        };
        double[] x = new double[]{1.0, 1.0, 1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 4, 3, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{0.0, 1.0, 2.0, -1.0}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test09FindMinimum() {
        System.out.format("%nOutput from test problem 9 (Hock and Schittkowski 100)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 127.0 - 2.0 * x[0] * x[0] - 3.0 * Math.pow(x[1], 4.0) - x[2] - 4.0 * x[3] * x[3] - 5.0 * x[4];
                con[1] = 282.0 - 7.0 * x[0] - 3.0 * x[1] - 10.0 * x[2] * x[2] - x[3] + x[4];
                con[2] = 196.0 - 23.0 * x[0] - x[1] * x[1] - 6.0 * x[5] * x[5] + 8.0 * x[6];
                con[3] = -4.0 * x[0] * x[0] - x[1] * x[1] + 3.0 * x[0] * x[1] - 2.0 * x[2] * x[2] - 5.0 * x[5] + 11.0 * x[6];
                return Math.pow(x[0] - 10.0, 2.0) + 5.0 * Math.pow(x[1] - 12.0, 2.0) + Math.pow(x[2], 4.0) + 3.0 * Math.pow(x[3] - 11.0, 2.0) + 10.0 * Math.pow(x[4], 6.0) + 7.0 * x[5] * x[5] + Math.pow(x[6], 4.0) - 4.0 * x[5] * x[6] - 10.0 * x[5] - 8.0 * x[6];
            }
        };
        double[] x = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 7, 4, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{2.330499, 1.951372, -0.4775414, 4.365726, -0.624487, 1.038131, 1.594227}, (double[])x, (double)1.0E-5);
    }

    @Test
    public void test10FindMinimum() {
        System.out.format("%nOutput from test problem 10 (Hexagon area)%n", new Object[0]);
        Calcfc calcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                con[0] = 1.0 - x[2] * x[2] - x[3] * x[3];
                con[1] = 1.0 - x[8] * x[8];
                con[2] = 1.0 - x[4] * x[4] - x[5] * x[5];
                con[3] = 1.0 - x[0] * x[0] - Math.pow(x[1] - x[8], 2.0);
                con[4] = 1.0 - Math.pow(x[0] - x[4], 2.0) - Math.pow(x[1] - x[5], 2.0);
                con[5] = 1.0 - Math.pow(x[0] - x[6], 2.0) - Math.pow(x[1] - x[7], 2.0);
                con[6] = 1.0 - Math.pow(x[2] - x[4], 2.0) - Math.pow(x[3] - x[5], 2.0);
                con[7] = 1.0 - Math.pow(x[2] - x[6], 2.0) - Math.pow(x[3] - x[7], 2.0);
                con[8] = 1.0 - x[6] * x[6] - Math.pow(x[7] - x[8], 2.0);
                con[9] = x[0] * x[3] - x[1] * x[2];
                con[10] = x[2] * x[8];
                con[11] = -x[4] * x[8];
                con[12] = x[4] * x[7] - x[5] * x[6];
                con[13] = x[8];
                return -0.5 * (x[0] * x[3] - x[1] * x[2] + x[2] * x[8] - x[4] * x[8] + x[4] * x[7] - x[5] * x[6]);
            }
        };
        double[] x = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        CobylaExitStatus result = Cobyla.FindMinimum(calcfc, 9, 14, x, this.rhobeg, this.rhoend, this.iprint, this.maxfun);
        Assert.assertArrayEquals(null, (double[])new double[]{x[0], x[1], x[2], x[3], x[0], x[1], x[2], x[3], 0.0}, (double[])x, (double)1.0E-4);
    }
}

