/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jplot3dp.Printable;

class Vec
implements Printable {
    public double x;
    public double y;
    public double z;

    public Vec() {
    }

    public Vec(double d, double d1, double d2) {
        this.x = d;
        this.y = d1;
        this.z = d2;
    }

    public Vec(Vec vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public double dotProduct(Vec vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec normalize() {
        double d = this.norm();
        return new Vec(this.x / d, this.y / d, this.z / d);
    }

    public Vec add(Vec vec) {
        return new Vec(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vec substract(Vec vec) {
        return new Vec(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Vec scalarMult(double d) {
        return new Vec(d * this.x, d * this.y, d * this.z);
    }

    public Vec scalarDivide(double d) {
        return new Vec(this.x / d, this.y / d, this.z / d);
    }

    public Vec crossProduct(Vec vec) {
        return new Vec(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    @Override
    public void writeToStream(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeDouble(this.x);
        dataoutputstream.writeDouble(this.y);
        dataoutputstream.writeDouble(this.z);
    }

    @Override
    public void readFromStream(DataInputStream datainputstream) throws IOException {
        this.x = datainputstream.readDouble();
        this.y = datainputstream.readDouble();
        this.z = datainputstream.readDouble();
    }

    public String toString() {
        return "Vector: (" + this.x + "," + this.y + "," + this.z + ")";
    }
}

