/*
 * Decompiled with CFR 0.152.
 */
package jplot3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class Utils {
    Utils() {
    }

    public static ImageIcon loadIcon(String s) {
        String pre = "/jplot3dp/images/";
        URL micon = Utils.class.getResource(pre + s);
        return new ImageIcon(micon);
    }

    public static Color changeAlpha(Color color, int i) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), i);
    }

    public static Color blendColors(Color color, Color color1, double d) {
        if (color == null || color1 == null) {
            return null;
        }
        int i = (int)((double)color1.getRed() * d + (double)color.getRed() * (1.0 - d));
        int j = (int)((double)color1.getGreen() * d + (double)color.getGreen() * (1.0 - d));
        int k = (int)((double)color1.getBlue() * d + (double)color.getBlue() * (1.0 - d));
        int l = color.getAlpha();
        return new Color(i, j, k, l);
    }

    public static Container labeledComponent(String s, JComponent jcomponent, boolean flag) {
        Box box = new Box(flag ? 0 : 1);
        box.add(new JLabel(s));
        jcomponent.setAlignmentX(0.0f);
        box.add(jcomponent);
        return box;
    }

    public static void makeHot(final JComponent comp) {
        final Border borderE = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        class _cls1Border3D
        implements Border {
            private boolean m_raised;

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component component, Graphics g, int i, int j, int k, int l) {
                g.setColor(Color.WHITE);
                g.draw3DRect(i, j, k - 1, l - 1, this.m_raised);
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(1, 2, 1, 2);
            }

            public _cls1Border3D(boolean flag) {
                this.m_raised = flag;
            }
        }
        final _cls1Border3D borderR = new _cls1Border3D(true);
        final _cls1Border3D borderL = new _cls1Border3D(false);
        comp.setBorder(borderE);
        comp.addMouseListener(new MouseAdapter(){
            {
            }

            private boolean isEnabled() {
                if (comp instanceof JButton) {
                    return ((JButton)comp).isEnabled();
                }
                return true;
            }

            @Override
            public void mouseEntered(MouseEvent mouseevent) {
                if (this.isEnabled()) {
                    comp.setBorder((mouseevent.getModifiersEx() & 0x400) != 0 ? borderL : borderR);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseevent) {
                comp.setBorder(borderE);
            }

            @Override
            public void mouseReleased(MouseEvent mouseevent) {
                if (!this.isEnabled()) {
                    comp.setBorder(borderE);
                } else if (mouseevent.getButton() == 1 && !comp.getBorder().equals(borderE)) {
                    comp.setBorder(borderR);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseevent) {
                if (this.isEnabled() && mouseevent.getButton() == 1) {
                    comp.setBorder(borderL);
                }
            }
        });
    }

    public static void writeColor(DataOutputStream dataoutputstream, Color color) throws IOException {
        dataoutputstream.writeInt(color.getRed());
        dataoutputstream.writeInt(color.getGreen());
        dataoutputstream.writeInt(color.getBlue());
        dataoutputstream.writeInt(color.getAlpha());
    }

    public static Color readColor(DataInputStream datainputstream) throws IOException {
        return new Color(datainputstream.readInt(), datainputstream.readInt(), datainputstream.readInt(), datainputstream.readInt());
    }
}

