/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jplot.Utils;

public class XMLRead {
    private String globalContext = "";
    private Vector vectors = new Vector();
    private Vector v = new Vector();

    public XMLRead() {
        this.vectors.add(this.v);
    }

    private boolean isKey(String s, String key) {
        return s.length() > key.length() + 1 && s.substring(1, key.length() + 1).equals(key);
    }

    private boolean isClosingKey(String s, String key) {
        return s.length() > key.length() + 2 && s.charAt(1) == '/' && s.substring(2, key.length() + 2).equals(key);
    }

    private void syntaxError(String s) {
        System.out.println("Syntax error occured in this line:\n\t" + s + "\n");
    }

    private String[] toTokens(String s) {
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != ' ' || inQuotes) {
                sb.append(c);
                continue;
            }
            v.add(sb.toString());
            sb.delete(0, sb.length());
        }
        v.add(sb.toString());
        String[] array = new String[v.size()];
        return v.toArray(array);
    }

    public boolean parse(File file, String context) {
        boolean readAll = false;
        if (context.equals("/") || context.equals("")) {
            readAll = true;
        }
        this.globalContext = readAll ? "" : context;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            this.parse(in, context);
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse XML settings from file " + file.toString());
            return false;
        }
        return true;
    }

    public boolean parse(BufferedReader in, String context) {
        boolean readAll = false;
        if (context.equals("/") || context.equals("")) {
            readAll = true;
        }
        this.globalContext = readAll ? "" : context;
        try {
            String s;
            block2: while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() < 1 || !readAll && !this.isKey(s, context)) continue;
                while ((s = in.readLine()) != null) {
                    if ((s = s.trim()).length() < 1) continue;
                    if (readAll || this.isClosingKey(s, context)) break block2;
                    if (s.charAt(0) != '<') {
                        this.v.add(s);
                        continue;
                    }
                    int len = s.indexOf(62);
                    String s2 = s.substring(1, len);
                    String[] tokens = this.toTokens(s2);
                    if (tokens[0].startsWith("/")) {
                        tokens[0] = tokens[0].substring(1, tokens[0].length());
                    }
                    if (tokens.length > 1) {
                        this.v.add(tokens[0] + "<");
                        for (int i = 1; i < tokens.length; ++i) {
                            int k = tokens[i].indexOf(61);
                            String key = tokens[i].substring(0, k);
                            this.v.add(key + "<");
                            int end = tokens[i].length();
                            if (tokens[i].charAt(end - 1) == '/') {
                                --end;
                            }
                            this.v.add(tokens[i].substring(k + 1, end));
                            this.v.add(key + ">");
                        }
                        if (!s2.endsWith("/")) continue;
                        this.v.add(tokens[0] + ">");
                        continue;
                    }
                    if (s.charAt(1) == '/') {
                        this.v.add(tokens[0] + ">");
                        continue;
                    }
                    this.v.add(tokens[0] + "<");
                    if (len >= s.length() - 1) continue;
                    int k = s.lastIndexOf(60);
                    if (k < len) {
                        k = s.length();
                    }
                    this.v.add(s.substring(len + 1, k).trim());
                }
                break block2;
            }
            in.close();
        }
        catch (IOException e) {
            Utils.oops(null, "Can't parse XML settings from BufferedReader");
            return false;
        }
        return true;
    }

    public void parse(File file) {
        this.parse(file, "/");
    }

    public boolean open(String context) {
        boolean res = false;
        this.globalContext = context;
        Vector<String> a = new Vector<String>();
        boolean opened = false;
        String[] tokens = context.split("/");
        int i = 0;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.endsWith("<") && s.substring(0, s.length() - 1).equals(tokens[i])) {
                if (i == tokens.length - 1) {
                    opened = true;
                    continue;
                }
                ++i;
                continue;
            }
            if (opened && s.endsWith(">") && s.substring(0, s.length() - 1).equals(tokens[i])) {
                if (i == 0) {
                    opened = false;
                    break;
                }
                --i;
                continue;
            }
            if (!opened) continue;
            a.add(s);
        }
        if (a.size() > 0) {
            this.vectors.add(a);
            this.v = a;
            res = true;
        }
        return res;
    }

    public void close() {
        if (this.vectors.size() > 1) {
            this.vectors.remove(this.v);
            this.v = (Vector)this.vectors.lastElement();
        }
    }

    public void hide(String context) {
        String[] tokens = context.split("/");
        boolean opened = false;
        int i = 0;
        for (int k = 0; k < this.v.size(); ++k) {
            String s = (String)this.v.get(k);
            if (!s.endsWith("<") || !s.substring(0, s.length() - 1).equals(tokens[i])) continue;
            if (i == tokens.length - 1) {
                s = "gone***" + s;
                this.v.set(k, s);
                break;
            }
            ++i;
        }
    }

    public void unHide() {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.startsWith("gone***")) continue;
            String string = s.substring(7, s.length());
        }
    }

    public void printVector() {
        int i = 0;
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            System.out.print(s + "\t");
            if (s.endsWith(">")) {
                System.out.println();
            }
            ++i;
        }
    }

    public Vector<String> getData() {
        return this.v;
    }

    private boolean gotoElement(Enumeration e, String element) {
        boolean found = false;
        String[] tokens = element.split("/");
        block0: for (int i = 0; i < tokens.length; ++i) {
            found = false;
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.substring(0, s.length() - 1).equals(tokens[i])) continue;
                found = true;
                continue block0;
            }
        }
        return found;
    }

    private String get(String context, Enumeration e, String element) {
        String res = "";
        boolean found = false;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            String sub = s.substring(0, s.length() - 1);
            if (sub.equals(element)) {
                found = true;
                break;
            }
            if (!sub.equals(context)) continue;
            break;
        }
        if (found) {
            res = (String)e.nextElement();
            if (e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }

    public Dimension getDimension(String element, Dimension d) {
        Enumeration e = this.v.elements();
        this.gotoElement(e, element);
        if (!e.hasMoreElements()) {
            return d;
        }
        String w = this.get(element, e, "width");
        if (w.equals("")) {
            return d;
        }
        String h = this.get(element, e, "height");
        if (h.equals("")) {
            return d;
        }
        d.width = Integer.parseInt(w);
        d.height = Integer.parseInt(h);
        return d;
    }

    public Color getColor(String element, Color c) {
        Enumeration e = this.v.elements();
        this.gotoElement(e, element);
        if (!e.hasMoreElements()) {
            return c;
        }
        String r = this.get(element, e, "red");
        if (r.equals("")) {
            return c;
        }
        String g = this.get(element, e, "green");
        if (r.equals("")) {
            return c;
        }
        String b = this.get(element, e, "blue");
        if (b.equals("")) {
            return c;
        }
        return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
    }

    public Stroke getStroke(String element, BasicStroke c) {
        Enumeration e = this.v.elements();
        this.gotoElement(e, element);
        if (!e.hasMoreElements()) {
            return c;
        }
        String thikness = this.get(element, e, "thikness");
        if (thikness.equals("")) {
            return c;
        }
        String lineJoin = this.get(element, e, "lineJoin");
        if (lineJoin.equals("")) {
            return c;
        }
        String miterLimit = this.get(element, e, "miterLimit");
        if (miterLimit.equals("")) {
            return c;
        }
        String dashPhase = this.get(element, e, "dashPhase");
        if (dashPhase.equals("")) {
            return c;
        }
        String endCap = this.get(element, e, "endCap");
        if (endCap.equals("")) {
            return c;
        }
        String dashArray = this.get(element, e, "dashArray");
        if (dashArray.equals("")) {
            return c;
        }
        float[] d = new float[]{Float.parseFloat(dashArray)};
        BasicStroke strock = new BasicStroke(Float.parseFloat(thikness), Integer.parseInt(endCap), Integer.parseInt(lineJoin), Float.parseFloat(miterLimit), d, Float.parseFloat(dashPhase));
        return strock;
    }

    public Font getFont(String element, Font f) {
        Enumeration e = this.v.elements();
        this.gotoElement(e, element);
        if (!e.hasMoreElements()) {
            return f;
        }
        String name = this.get(element, e, "name");
        if (name.equals("")) {
            return f;
        }
        String style = this.get(element, e, "style");
        if (style.equals("")) {
            return f;
        }
        String size = this.get(element, e, "size");
        if (size.equals("")) {
            return f;
        }
        return new Font(name, Integer.parseInt(style), Integer.parseInt(size));
    }

    public int getInt(String element, int val) {
        int res = val;
        Enumeration e = this.v.elements();
        if (this.gotoElement(e, element) && e.hasMoreElements()) {
            String ss = (String)e.nextElement();
            ss = ss.trim();
            try {
                res = Integer.parseInt(ss);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (e.hasMoreElements() && e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }

    public double getDouble(String element, double val) {
        double res = val;
        Enumeration e = this.v.elements();
        if (this.gotoElement(e, element) && e.hasMoreElements()) {
            String ss = (String)e.nextElement();
            ss = ss.trim();
            try {
                res = Double.parseDouble(ss);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (e.hasMoreElements() && e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }

    public float getFloat(String element, float val) {
        float res = val;
        Enumeration e = this.v.elements();
        if (this.gotoElement(e, element) && e.hasMoreElements()) {
            String ss = (String)e.nextElement();
            ss = ss.trim();
            try {
                res = Float.parseFloat(ss);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (e.hasMoreElements() && e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }

    public String getString(String element, String val) {
        String res = val;
        Enumeration e = this.v.elements();
        if (this.gotoElement(e, element) && e.hasMoreElements()) {
            try {
                res = (String)e.nextElement();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (e.hasMoreElements() && e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }

    public boolean getBoolean(String element, boolean val) {
        boolean res = val;
        Enumeration e = this.v.elements();
        if (this.gotoElement(e, element) && e.hasMoreElements()) {
            try {
                res = Boolean.valueOf((String)e.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (e.hasMoreElements() && e.hasMoreElements()) {
                e.nextElement();
            }
        }
        return res;
    }
}

