/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import jplot.JPlot;
import jplot.PrintFilePainter;
import jplot.PrintTextPainter;
import jplot.SmallButton;
import jplot.SmallToggleButton;
import jplot.Utils;
import jplot.panels.PanelGridUI;

public class SimpleEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JEditorPane textArea;
    private File file;
    private JFrame frame;
    private String text;
    private JComboBox fonts;
    private JComboBox sizes;
    private int size;
    private int style;
    private Font currentFont = new Font("Monospaced", 0, 12);
    private Color currentColor = Color.black;
    private SmallToggleButton b_bold;
    private SmallToggleButton b_italic;
    private JScrollPane scrollpane;
    private boolean textChanged;
    private JPanel thisPanel;
    private JPanel parent;
    private FindPanel findPanel;
    private boolean isEditable;
    private Dimension panelSize;
    private final DefaultHighlighter.DefaultHighlightPainter g;

    public SimpleEditor(JPanel parent, String title, boolean isEditable, int width, int height) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.size = 12;
        this.style = 0;
        this.thisPanel = this;
        this.parent = parent;
        this.isEditable = isEditable;
        this.panelSize = new Dimension(width, height);
        JPanel mainPanel = new JPanel(new BorderLayout());
        EmptyBorder eb = new EmptyBorder(2, 2, 2, 2);
        BevelBorder bb = new BevelBorder(1);
        mainPanel.setBorder(new CompoundBorder(eb, bb));
        this.textArea = new JEditorPane();
        this.textArea.setEditable(isEditable);
        this.textArea.setFont(this.currentFont);
        this.scrollpane = new JScrollPane(this.textArea);
        mainPanel.add((Component)this.scrollpane, "Center");
        JToolBar toolbar = new JToolBar();
        ImageIcon icon = this.getImageIcon(parent, "exit.jpg");
        AbstractAction action = new AbstractAction("Close", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.frame.dispose();
            }
        };
        this.addButton(toolbar, action, "Close this panel");
        icon = this.getImageIcon(parent, "Save24.gif");
        action = new AbstractAction("Save", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.save();
            }
        };
        this.addButton(toolbar, action, "Save the current file");
        icon = this.getImageIcon(parent, "Print24.gif");
        action = new AbstractAction("Print", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.printText();
            }
        };
        this.addButton(toolbar, action, "Print the current content");
        toolbar.addSeparator();
        icon = this.getImageIcon(parent, "Refresh24.gif");
        action = new AbstractAction("Reload", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.addButton(toolbar, action, "Reload the current file");
        icon = this.getImageIcon(parent, "Find24.gif");
        action = new AbstractAction("Find", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.find();
            }
        };
        this.addButton(toolbar, action, "Find a piece of text in this file");
        toolbar.addSeparator();
        this.fonts = new JComboBox<String>(JPlot.fontNames);
        this.fonts.setMaximumSize(this.fonts.getPreferredSize());
        this.fonts.setEditable(true);
        this.fonts.setSelectedItem("Monospaced");
        this.fonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.setSelectedFont();
            }
        });
        toolbar.add(this.fonts);
        toolbar.addSeparator();
        this.sizes = new JComboBox<String>(new String[]{"7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "26", "32"});
        this.sizes.setMaximumSize(this.sizes.getPreferredSize());
        this.sizes.setEditable(true);
        this.sizes.setSelectedItem("12");
        this.sizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fontSize = 0;
                try {
                    fontSize = Integer.parseInt(SimpleEditor.this.sizes.getSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                SimpleEditor.this.size = fontSize;
                SimpleEditor.this.setSelectedFont();
            }
        });
        toolbar.add(this.sizes);
        toolbar.addSeparator();
        icon = this.getImageIcon(parent, "Bold16.gif");
        this.b_bold = new SmallToggleButton(false, icon, icon, "Bold font");
        this.b_bold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.setSelectedFont();
            }
        });
        toolbar.add(this.b_bold);
        this.b_bold.resetBorder();
        icon = this.getImageIcon(parent, "Italic16.gif");
        this.b_italic = new SmallToggleButton(false, icon, icon, "Italic font");
        this.b_italic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.setSelectedFont();
            }
        });
        toolbar.add(this.b_italic);
        this.b_italic.resetBorder();
        mainPanel.add((Component)toolbar, "North");
        this.add((Component)this.makeMenuBar(), "North");
        this.add((Component)mainPanel, "Center");
        this.textChanged = false;
        this.textArea.setSelectionColor(new Color(248, 248, 215));
        this.g = new DefaultHighlighter.DefaultHighlightPainter(new Color(248, 248, 215));
        this.frame = new JFrame(title);
        this.frame.getContentPane().add(this);
        this.frame.pack();
    }

    public SimpleEditor(JPanel parent, String title, boolean isEditable) {
        this(parent, title, isEditable, 640, 550);
    }

    private void addButton(JToolBar toolbar, Action action, String tip) {
        SmallButton sb = new SmallButton(action, tip);
        toolbar.add(sb);
        sb.resetBorder();
    }

    private ImageIcon getImageIcon(JPanel parent, String name) {
        ImageIcon im = null;
        try {
            URL imageURL = parent.getClass().getResource("/images/" + name);
            Toolkit tk = Toolkit.getDefaultToolkit();
            im = new ImageIcon(tk.createImage(imageURL));
        }
        catch (Exception e) {
            Utils.oops(this.frame, "Impossible to load the TextEditor's icon '" + name + "'.\nSomething's wrong with the installation.");
        }
        return im;
    }

    JMenuBar makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fm = menuBar.add(new JMenu("File"));
        fm.setMnemonic('F');
        ImageIcon icon = this.getImageIcon(this.parent, "Open16.gif");
        JMenuItem mi = fm.add(new JMenuItem("Open...", icon));
        mi.setMnemonic('O');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.openFile();
            }
        });
        icon = this.getImageIcon(this.parent, "Save16.gif");
        mi = fm.add(new JMenuItem("Save...", icon));
        mi.setMnemonic('S');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.save();
            }
        });
        icon = this.getImageIcon(this.parent, "SaveAs16.gif");
        mi = fm.add(new JMenuItem("Save as...", icon));
        mi.setMnemonic('A');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.saveAs();
            }
        });
        fm.addSeparator();
        icon = this.getImageIcon(this.parent, "Print16.gif");
        mi = fm.add(new JMenuItem("Print", icon));
        mi.setMnemonic('P');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.printText();
            }
        });
        fm.addSeparator();
        mi = fm.add(new JMenuItem("Quit"));
        mi.setMnemonic('Q');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.dispose();
            }
        });
        JMenu edit = menuBar.add(new JMenu("Edit"));
        edit.setMnemonic('E');
        icon = this.getImageIcon(this.parent, "Refresh16.gif");
        mi = edit.add(new JMenuItem("Reload", icon));
        mi.setMnemonic('R');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.refresh(SimpleEditor.this.file);
            }
        });
        icon = this.getImageIcon(this.parent, "Find16.gif");
        mi = edit.add(new JMenuItem("Find", icon));
        mi.setMnemonic('F');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleEditor.this.find();
            }
        });
        return menuBar;
    }

    private void setSelectedFont() {
        this.style = this.b_bold.isSelected() ? (this.b_italic.isSelected() ? 3 : 1) : (this.b_italic.isSelected() ? 2 : 0);
        this.currentFont = new Font((String)this.fonts.getSelectedItem(), this.style, this.size);
        this.textArea.setFont(this.currentFont);
        this.textArea.repaint();
    }

    private void fileToString() {
        StringBuffer sb = new StringBuffer();
        if (this.file.exists() && this.file.canRead()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                while ((s = in.readLine()) != null) {
                    sb.append(s).append("\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.text = sb.toString().trim();
    }

    public void clear() {
        try {
            Document d = this.textArea.getDocument();
            d.remove(0, d.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void refresh(File f) {
        this.file = f;
        this.fileToString();
        this.refresh(this.text);
    }

    public void refresh(String txt) {
        if (txt.startsWith("<!DOC") || txt.startsWith("<!doc") || txt.startsWith("<html>") || txt.startsWith("<HTML>")) {
            this.textArea.setContentType("text/html");
        } else {
            this.textArea.setContentType("text/plain");
        }
        this.textArea.setText(txt);
        if (this.isEditable) {
            this.textArea.setCaretPosition(0);
        }
        this.textArea.revalidate();
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.file));
            pw.println(this.textArea.getText());
            pw.close();
        }
        catch (IOException e) {
            Utils.bummer(this.frame, "Impossible to write to " + this.file.toString());
        }
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser(new File("."));
        DataFileFilter ff = new DataFileFilter();
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showDialog(this.thisPanel, "Save As") == 0) {
            int res;
            this.file = chooser.getSelectedFile();
            if (this.file.exists() && (res = JOptionPane.showConfirmDialog(this.thisPanel, "The file exists: do you want to overwrite this file?", "", 0)) == 1) {
                return;
            }
            this.save();
        }
    }

    public void openFile() {
        JFileChooser chooser = new JFileChooser(new File("."));
        DataFileFilter ff = new DataFileFilter();
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showOpenDialog(this.thisPanel) == 0) {
            if (this.textChanged) {
                int result = JOptionPane.showConfirmDialog(this.thisPanel, "The file has been changed, shouldn't we save it first?");
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    this.save();
                }
            }
            this.refresh(chooser.getSelectedFile());
        }
    }

    public void dispose() {
        this.clear();
        this.frame.dispose();
    }

    private void printText() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(){

            @Override
            public void run() {
                PrinterJob job = PrinterJob.getPrinterJob();
                if (job != null) {
                    PageFormat pf = new PageFormat();
                    PrintTextPainter ptp = new PrintTextPainter(SimpleEditor.this.text);
                    ptp.setFont(SimpleEditor.this.currentFont);
                    ptp.setForeground(SimpleEditor.this.currentColor);
                    job.setPrintable(ptp, pf);
                    job.setCopies(1);
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception e) {
                            System.out.println("Oops, error while printing...");
                        }
                    }
                }
            }
        };
        t.start();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void printFile() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(){

            @Override
            public void run() {
                PrinterJob job = PrinterJob.getPrinterJob();
                if (job != null) {
                    PageFormat pf = new PageFormat();
                    PrintFilePainter pfp = new PrintFilePainter(SimpleEditor.this.file.toString());
                    pfp.setFont(SimpleEditor.this.currentFont);
                    pfp.setForeground(SimpleEditor.this.currentColor);
                    job.setPrintable(pfp, pf);
                    job.setCopies(1);
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        t.start();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.panelSize;
    }

    public void show(int x, int y, File f) {
        this.refresh(f);
        this.frame.setLocation(x, y);
        this.frame.setState(0);
        this.frame.setVisible(true);
    }

    public void show(int x, int y, String t) {
        this.refresh(t);
        this.frame.setLocation(x, y);
        this.frame.setState(0);
        this.frame.setVisible(true);
    }

    private void find() {
        if (this.findPanel == null) {
            this.findPanel = new FindPanel();
        }
        this.findPanel.show(this.frame, 100, 100);
    }

    private class DataFileFilter
    extends FileFilter {
        private DataFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".res") || pathname.getName().endsWith(".dat");
        }

        @Override
        public String getDescription() {
            return "data files (*.res, *.dat)";
        }
    }

    class FindPanel
    extends PanelGridUI {
        private static final long serialVersionUID = 1L;
        private JDialog dialog;
        private JTextField textField;
        private int startIndex = 0;
        private int findIndex;
        private final Dimension preferredSize = new Dimension(260, 80);

        public FindPanel() {
            JLabel label = new JLabel("Search:");
            label.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            this.addComponent(label, 1, 1);
            this.textField = new JTextField();
            this.textField.setColumns(15);
            this.addFilledComponent(this.textField, 1, 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        private boolean find(String word) {
            this.findIndex = -1;
            int wordLen = word.length();
            int N = SimpleEditor.this.text.length() - wordLen;
            for (int i = this.startIndex; i < N; ++i) {
                String s = SimpleEditor.this.text.substring(i, i + wordLen);
                if (!s.equals(word)) continue;
                this.findIndex = i;
                try {
                    SimpleEditor.this.textArea.getHighlighter().removeAllHighlights();
                    SimpleEditor.this.textArea.getHighlighter().addHighlight(i, i + wordLen, SimpleEditor.this.g);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            return this.findIndex > -1;
        }

        private void findAction() {
            int i = 0;
            if (!this.textField.getText().equals("")) {
                this.startIndex = SimpleEditor.this.textArea.getCaretPosition();
                boolean tryFind = true;
                while (tryFind) {
                    if (!this.find(this.textField.getText())) {
                        int result = JOptionPane.showConfirmDialog(SimpleEditor.this.frame, "Reaching the end of the text,\nrestart the scan from the top?", "Search failed", 2, 1);
                        if (result == 2) {
                            tryFind = false;
                        } else {
                            this.startIndex = 0;
                        }
                    } else {
                        tryFind = false;
                    }
                    if (i++ <= 0) continue;
                }
                if (this.findIndex != -1) {
                    SimpleEditor.this.textArea.setCaretPosition(++this.findIndex);
                }
            }
        }

        public void show(Frame parent, int x, int y) {
            if (this.dialog == null) {
                JPanel panel = new JPanel(new BorderLayout());
                this.dialog = new JDialog(parent, "Find", true);
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SimpleEditor.this.textArea.getHighlighter().removeAllHighlights();
                        FindPanel.this.dialog.dispose();
                    }
                });
                JPanel p = new JPanel(new FlowLayout());
                p.setBorder(BorderFactory.createEtchedBorder());
                JButton b = new JButton("Find");
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindPanel.this.findAction();
                    }
                });
                p.add(b);
                b = new JButton("Quit");
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SimpleEditor.this.textArea.getHighlighter().removeAllHighlights();
                        FindPanel.this.dialog.dispose();
                    }
                });
                p.add(b);
                panel.add((Component)this, "Center");
                panel.add((Component)p, "South");
                this.dialog.getContentPane().add(panel);
                this.dialog.setLocation(x, y);
                this.dialog.pack();
            }
            this.dialog.setVisible(true);
        }
    }
}

