/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import jhplot.JHPlot;
import jhplot.io.images.ExportVGraphics;
import jplot.DataArray;
import jplot.DataFile;
import jplot.GraphGeneral;
import jplot.GraphSettings;
import jplot.GraphXY;
import jplot.LinePars;
import jplot.PiperOptions;
import jplot.PrintFilePainter;
import jplot.SmallButton;
import jplot.StyleChooser;
import jplot.Utils;
import jplot.XMLRead;
import jplot.XMLWrite;
import jplot.panels.PanelAxes;
import jplot.panels.PanelLabel;
import jplot.panels.PanelLegend;
import jplot.panels.PanelPlot;
import jplot.panels.PanelSave;
import jplot.panels.PanelScaling;

public class JPlot
extends JPanel {
    public static final boolean debug = false;
    public static int WIDTH = 600;
    public static int HEIGHT = 600;
    public static final String AppName = "JPlot";
    public JFrame frame;
    public JFrame about;
    public JFrame plotFrame;
    private JMenuBar menubar;
    public Vector<PanelPlot> plotPanels;
    private JPlot jplot;
    private JTabbedPane tabbedPane;
    private JToolBar toolBar;
    private Vector<DataArray> dataArrays = new Vector();
    private GraphGeneral graph;
    private static int dIndex = 0;
    private PanelAxes axesPanel;
    private PanelScaling scalingPanel;
    private PiperOptions piperPanel;
    private PanelSave export;
    public PanelLabel labelPanel;
    public PanelLegend legendPanel;
    public StyleChooser styleChooser;
    private StyleChooser globalStyleChooser;
    private File scriptFile;
    public static String[] fontNames = new String[]{"no fonts found"};
    public boolean loaded;
    private boolean hideGraph;
    private GraphSettings gs;
    private JPanel mainPanel;
    private JMenu plotMenu;
    private JMenuItem scalingMenuItem;
    private JMenuItem piperMenuItem;
    private JCheckBoxMenuItem mi_2D;
    private JCheckBoxMenuItem mi_piper;
    private JCheckBoxMenuItem mi_multi;
    private JCheckBoxMenuItem mi_java;
    private JCheckBoxMenuItem mi_motif;
    private JCheckBoxMenuItem mi_mac;
    private JCheckBoxMenuItem mi_windows;
    private JCheckBoxMenuItem mi_gtk;
    private JCheckBoxMenuItem mi_autoUpdate;
    private JFileChooser dataChooser;
    private Timer timer;
    public static final String FS = System.getProperty("file.separator");
    private boolean isStandAlone = false;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private static final String macLaf = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String metalLaf = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String motifLaf = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windowsLaf = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String gtkLaf = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static String currentLookAndFeel;
    private int xPos = 450;
    private int yPos = 20;
    private int autoUpdateInterval = 1000;

    public JPlot(JFrame parent, Vector files, File script, boolean lonely) {
        this.setLayout(new BorderLayout());
        this.isStandAlone = lonely;
        this.loaded = false;
        this.plotFrame = null;
        this.hideGraph = false;
        this.frame = parent;
        this.jplot = this;
        this.scriptFile = script;
        dIndex = 0;
        if (this.isStandAlone) {
            this.setBorder(new EtchedBorder());
            this.menubar = this.makeMenuBar();
            this.add((Component)this.menubar, "North");
            this.gs = new GraphSettings(parent);
            if (this.scriptFile != null) {
                this.gs.setTitleName(this.scriptFile.toString());
            }
            this.gs.setTitleString();
        } else {
            this.gs = new GraphSettings(null);
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.toolBar = this.get2DToolBar();
        this.mainPanel.add((Component)this.toolBar, "North");
        this.graph = new GraphXY(this.jplot, this.gs);
        this.tabbedPane = new JTabbedPane();
        this.plotPanels = new Vector();
        this.tabbedPane.setFont(new Font("serif", 0, 12));
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.mainPanel, "Center");
        Thread t = new Thread(){

            @Override
            public void run() {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (fontNames.length == 1) {
                    fontNames = env.getAvailableFontFamilyNames();
                }
                JPlot.this.legendPanel = new PanelLegend(JPlot.this.jplot, JPlot.this.gs);
                JPlot.this.axesPanel = new PanelAxes(JPlot.this.jplot, JPlot.this.gs);
                JPlot.this.labelPanel = new PanelLabel(JPlot.this.jplot, JPlot.this.gs);
                JPlot.this.styleChooser = new StyleChooser((Frame)((JPlot)JPlot.this).jplot.frame, "Style chooser", new LinePars());
                JPlot.this.scalingPanel = new PanelScaling(JPlot.this.jplot, JPlot.this.gs);
                JPlot.this.piperPanel = new PiperOptions(JPlot.this.jplot, JPlot.this.gs);
                JPlot.this.loaded = true;
            }
        };
        t.start();
        if (this.scriptFile != null) {
            this.loadScript();
        }
    }

    public JPlot(JFrame parent) {
        this(parent, new Vector(), null, false);
    }

    public JPlot(JFrame parent, Vector files) {
        this(parent, files, null, false);
    }

    JMenuBar makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = menuBar.add(new JMenu("File"));
        file.setMnemonic('F');
        ImageIcon icon = this.getImageIcon("New16.gif");
        JMenuItem mi = file.add(new JMenuItem("New project", icon));
        mi.setMnemonic('N');
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.clear();
            }
        });
        mi.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        return menuBar;
    }

    private URL getHTMLUrl(String name) {
        URL url = null;
        try {
            url = this.frame.getClass().getResource("/html/" + name);
        }
        catch (Exception e) {
            Utils.oops(this.frame, "Impossible to load the About content.\nSomething's wrong with the installation.");
        }
        return url;
    }

    public void updateGraphIfShowing(boolean b) {
        if (this.plotFrame != null && this.plotPanels.size() > 0) {
            this.showGraph(true, b);
            int i = 0;
            if (this.plotPanels.size() > 1) {
                i = this.tabbedPane.getSelectedIndex();
            }
            this.plotPanels.get(i).update();
        } else {
            this.showGraph(false, b);
        }
    }

    public void updateGraphIfShowing() {
        this.updateGraphIfShowing(true);
    }

    public GraphGeneral getGraph() {
        return this.graph;
    }

    public GraphSettings getGraphSettings() {
        return this.gs;
    }

    public void setGraphSettings(GraphSettings gs) {
        this.gs = gs;
    }

    public StyleChooser getStyleChooser() {
        return this.styleChooser;
    }

    public PanelAxes getAxesPanel() {
        return this.axesPanel;
    }

    public PanelScaling ScalingPanel() {
        return this.scalingPanel;
    }

    public PanelLabel getLabelPanel() {
        return this.labelPanel;
    }

    public PanelLegend getLegendPanel() {
        return this.legendPanel;
    }

    private void optionsAction(int k) {
        if (this.loaded) {
            int x = (int)this.frame.getLocation().getX() + 20;
            int y = (int)this.frame.getLocation().getY() + 20;
            if (k == 0) {
                this.axesPanel.show(x, y);
            } else if (k == 1) {
                this.scalingPanel.showIt(this.frame, x, y);
            } else if (k == 2) {
                this.labelPanel.show(this.frame, x, y);
            } else if (k == 3) {
                this.legendPanel.show(this.frame, x, y);
            } else if (k == 4) {
                this.piperPanel.show(this.frame, x, y);
            }
        }
    }

    public ImageIcon getImageIcon(String name) {
        ImageIcon im = null;
        try {
            URL imageURL = this.jplot.getClass().getResource("/images/" + name);
            Toolkit tk = Toolkit.getDefaultToolkit();
            im = new ImageIcon(tk.createImage(imageURL));
        }
        catch (Exception e) {
            Utils.oops(this.frame, "Impossible to load JPlot's icon '" + name + "'.\nSomething's wrong with the installation.");
        }
        return im;
    }

    public boolean switchGraphType(int graphType) {
        int result;
        boolean res = false;
        if (this.gs.getGraphType() == graphType) {
            return res;
        }
        if (this.gs.dataChanged() && ((result = JOptionPane.showConfirmDialog(this.frame, "The current data set corresponds to a different graph-\ntype.  Loading the data will reset all the settings to\ntheir default values and they have not been saved.\n\nDo you want to save the settings now?", "Warning", 1, 1)) == 0 && !this.saveScript() || result == 2)) {
            return false;
        }
        this.gs.reset();
        this.gs.setGraphType(graphType);
        this.axesPanel = new PanelAxes(this.jplot, this.gs);
        this.labelPanel = new PanelLabel(this.jplot, this.gs);
        this.scalingPanel = new PanelScaling(this.jplot, this.gs);
        if (this.toolBar != null) {
            this.mainPanel.remove(this.toolBar);
        }
        if (graphType == 1) {
            this.toolBar = this.getPiperToolBar();
            if (this.isStandAlone) {
                this.plotMenu.remove(this.scalingMenuItem);
                this.plotMenu.add(this.piperMenuItem);
            }
        } else {
            this.toolBar = this.get2DToolBar();
            if (this.isStandAlone) {
                this.plotMenu.remove(this.piperMenuItem);
                this.plotMenu.add(this.scalingMenuItem);
            }
            this.graph = new GraphXY(this.jplot, this.gs);
        }
        this.mainPanel.add((Component)this.toolBar, "North");
        this.mainPanel.repaint();
        res = true;
        if (this.isStandAlone) {
            this.mi_2D.setSelected(graphType == 0);
            this.mi_piper.setSelected(graphType == 1);
            this.mi_multi.setSelected(graphType == 2);
        }
        return res;
    }

    private void addButton(JToolBar toolbar, Action action, String tip) {
        SmallButton sb = new SmallButton(action, tip);
        toolbar.add(sb);
        sb.resetBorder();
    }

    JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar();
        return toolbar;
    }

    private JToolBar get2DToolBar() {
        JToolBar toolbar = this.getToolBar();
        ImageIcon icon = this.getImageIcon("Refresh24.gif");
        AbstractAction action = new AbstractAction("Show", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.updateGraphIfShowing();
            }
        };
        this.addButton(toolbar, action, "Refresh the current graph");
        toolbar.addSeparator();
        icon = this.getImageIcon("Axes24.png");
        action = new AbstractAction("Axes", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(0);
            }
        };
        this.addButton(toolbar, action, "Axes parameters");
        icon = this.getImageIcon("Scaling24.png");
        action = new AbstractAction("Scaling", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(1);
            }
        };
        this.addButton(toolbar, action, "Scaling");
        icon = this.getImageIcon("Labels24.png");
        action = new AbstractAction("Labels", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(2);
            }
        };
        this.addButton(toolbar, action, "Text and labels");
        icon = this.getImageIcon("Legend24.png");
        action = new AbstractAction("Legend", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(3);
            }
        };
        this.addButton(toolbar, action, "Legend options");
        return toolbar;
    }

    private JToolBar getPiperToolBar() {
        JToolBar toolbar = this.getToolBar();
        ImageIcon icon = this.getImageIcon("graph_piper.png");
        AbstractAction action = new AbstractAction("Show", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.showGraph(true);
            }
        };
        this.addButton(toolbar, action, "Show the current graph");
        toolbar.addSeparator();
        icon = this.getImageIcon("Axes24.png");
        action = new AbstractAction("Axes", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(0);
            }
        };
        this.addButton(toolbar, action, "Axes parameters");
        icon = this.getImageIcon("Scaling24.png");
        action = new AbstractAction("Axes", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(4);
            }
        };
        this.addButton(toolbar, action, "Piper diagram options");
        icon = this.getImageIcon("Labels24.png");
        action = new AbstractAction("Labels", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(2);
            }
        };
        this.addButton(toolbar, action, "Text and labels");
        icon = this.getImageIcon("Legend24.png");
        action = new AbstractAction("Legend", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPlot.this.optionsAction(3);
            }
        };
        this.addButton(toolbar, action, "Legend options");
        return toolbar;
    }

    private boolean parseDatafile() {
        if (JHPlot.ReadFile) {
            if (this.plotPanels.size() == 0) {
                Utils.oops(this.frame, "No datafile loaded yet, open one first.");
                return false;
            }
            double x = 0.0;
            this.dataArrays.removeAllElements();
            int idx = 0;
            Enumeration<PanelPlot> e = this.plotPanels.elements();
            while (e.hasMoreElements()) {
                DataFile df = e.nextElement().getDataFile();
                if (!df.fillDataArrays(this.dataArrays, this.gs.getGraphType(), idx)) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }

    private void showGlobal() {
        if (this.plotPanels.size() > 0) {
            int i;
            PanelPlot pp;
            LinePars init;
            LinePars lp;
            if (this.globalStyleChooser == null) {
                this.globalStyleChooser = new StyleChooser((Frame)this.jplot.frame, "Global style-chooser", true);
            }
            if ((lp = this.globalStyleChooser.show(350, 100, init = (pp = this.plotPanels.get(i = this.tabbedPane.getSelectedIndex())).getDataFile().getLinePars(0))) != null) {
                this.gs.setDataChanged(lp.dataChanged());
                pp.getDataFile().setLinePars(lp);
                this.updateGraphIfShowing();
                pp.update();
            }
        } else {
            Utils.oops(this.frame, "Select global settings of what?\nLoad a dataset and make a selection first.");
        }
    }

    public boolean showGraph(boolean b, boolean toFront) {
        if (this.parseDatafile()) {
            if (this.dataArrays.size() > 0) {
                if (this.plotFrame == null) {
                    if (b) {
                        this.plotFrame = new JFrame(AppName);
                        this.plotFrame.setPreferredSize(new Dimension(600, 400));
                        ImageIcon icone = new ImageIcon(this.getClass().getClassLoader().getResource("jhplot/images/logo_jhepwork_24x24.jpg"));
                        this.plotFrame.setIconImage(icone.getImage());
                        JPanel p = new JPanel(new BorderLayout());
                        p.add((Component)this.graph, "Center");
                        JToolBar tb = new JToolBar();
                        ImageIcon icon = this.getImageIcon("exit.jpg");
                        AbstractAction action = new AbstractAction("Close", icon){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JPlot.this.dismissGraph();
                            }
                        };
                        this.addButton(tb, action, "Close the graph");
                        icon = this.getImageIcon("Refresh24.gif");
                        action = new AbstractAction("Refresh", icon){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JPlot.this.graph.show(JPlot.this.dataArrays);
                            }
                        };
                        this.addButton(tb, action, "Refresh the graph");
                        tb.addSeparator();
                        icon = this.getImageIcon("Export24.gif");
                        action = new AbstractAction("Export", icon){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JPlot.this.exportImage();
                            }
                        };
                        this.addButton(tb, action, "Export the graph");
                        icon = this.getImageIcon("Print24.gif");
                        action = new AbstractAction("Print", icon){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JPlot.this.printGraph();
                            }
                        };
                        this.addButton(tb, action, "Print the graph");
                        p.add((Component)tb, "North");
                        this.plotFrame.getContentPane().add(p);
                        this.plotFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                JPlot.this.dismissGraph();
                            }
                        });
                        this.plotFrame.setLocation(this.xPos, this.yPos);
                        this.plotFrame.pack();
                        this.plotFrame.setVisible(true);
                    }
                    this.graph.show(this.dataArrays);
                } else {
                    if (b) {
                        this.plotFrame.setState(0);
                        if (toFront) {
                            this.plotFrame.setVisible(true);
                        }
                    }
                    this.graph.show(this.dataArrays);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean showGraph(boolean b) {
        return this.showGraph(b, true);
    }

    public boolean showGraph() {
        return this.showGraph(true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void quitDialog() {
        if (this.gs.dataChanged()) {
            int result = JOptionPane.showConfirmDialog(this.jplot, "The settings have changed, save project first?", "", 1);
            if (result == 0) {
                if (!this.saveScript()) return;
                this.quit();
                return;
            } else {
                if (result != 1) return;
                this.quit();
            }
            return;
        } else {
            this.quit();
        }
    }

    public void quit() {
        if (this.graph != null) {
            this.graph.clear();
            this.graph = null;
        }
        this.clearData();
        this.clear();
        if (this.scalingPanel != null) {
            this.scalingPanel = null;
        }
        if (this.axesPanel != null) {
            this.axesPanel = null;
        }
        this.piperPanel = null;
        this.export = null;
        this.labelPanel = null;
        this.legendPanel = null;
        this.styleChooser = null;
        this.globalStyleChooser = null;
        if (this.gs != null) {
            this.gs = null;
        }
        if (this.mainPanel != null) {
            this.mainPanel = null;
        }
        this.frame.dispose();
        if (this.isStandAlone) {
            System.exit(1);
        }
        System.gc();
    }

    public void dismissGraph() {
        if (this.plotFrame != null) {
            this.plotFrame.dispose();
            this.plotFrame = null;
        }
    }

    private void printText() {
        if (this.scriptFile == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(){

            @Override
            public void run() {
                PrinterJob job = PrinterJob.getPrinterJob();
                if (job != null) {
                    PageFormat pf = new PageFormat();
                    PrintFilePainter pfp = new PrintFilePainter(JPlot.this.scriptFile.toString());
                    job.setPrintable(pfp, pf);
                    job.setCopies(1);
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        t.start();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void printGraph() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    prnJob.setPrintable(JPlot.this.graph);
                    if (prnJob.printDialog()) {
                        prnJob.print();
                    }
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void chooseDatafile() {
        if (this.dataChooser == null) {
            this.dataChooser = new JFileChooser();
            try {
                String path = new File(".").getCanonicalPath();
                this.dataChooser.setCurrentDirectory(new File(path));
            }
            catch (IOException path) {
                // empty catch block
            }
        }
        DataFileFilter1 ff1 = new DataFileFilter1();
        DataFileFilter2 ff2 = new DataFileFilter2();
        this.dataChooser.addChoosableFileFilter(ff1);
        this.dataChooser.addChoosableFileFilter(ff2);
        this.dataChooser.setFileFilter(ff1);
        if (this.dataChooser.showDialog(this.jplot, "Select") == 0) {
            this.insertDatafile(this.dataChooser.getSelectedFile());
        }
    }

    public boolean insertDataReader(BufferedReader in, LinePars lp) {
        boolean res = true;
        JHPlot.ReadFile = true;
        DataArray data = new DataArray(dIndex, lp);
        res = data.parse(in);
        if (!res) {
            Utils.oops(this.frame, "Impossible to parse data ");
            res = false;
            return res;
        }
        this.insertData(dIndex, data);
        ++dIndex;
        return res;
    }

    public boolean insertDatafile(File file) {
        boolean res = true;
        JHPlot.ReadFile = true;
        if (!file.exists()) {
            Utils.oops(this.frame, "Impossible to open file " + file.toString() + " for reading!");
            res = false;
        }
        return res;
    }

    public void replaceData(int index_data, DataArray data) {
        this.dataArrays.setElementAt(data, index_data);
    }

    public void clearData() {
        this.plotPanels.clear();
        this.tabbedPane.removeAll();
        this.dataArrays.clear();
    }

    public void clearData(int i) {
        if (i < this.plotPanels.size()) {
            this.plotPanels.remove(i);
            this.tabbedPane.remove(i);
            this.dataArrays.remove(i);
        }
    }

    public int sizeData() {
        return this.dataArrays.size();
    }

    public void replaceLinePars(int index_data, LinePars lp) {
        DataArray current = this.dataArrays.elementAt(index_data);
        current.setLinePars(lp);
        this.dataArrays.setElementAt(current, index_data);
    }

    public GraphSettings getGS() {
        return this.gs;
    }

    public void setGS(GraphSettings s) {
        this.gs = s;
        this.updateGraphIfShowing();
    }

    public boolean insertData(int index_data, DataArray data) {
        File file = new File(Integer.toString(index_data));
        boolean res = true;
        if (data == null) {
            Utils.oops(this.frame, "No data for reading!");
            res = false;
        } else {
            DataFile df = new DataFile(data, this.plotPanels.size(), this.gs);
            if (this.plotPanels.size() > 0 && df.getGraphType() != this.gs.getGraphType()) {
                Utils.oops(this.frame, "Data of " + df.getName() + " belongs to another type.\nImpossible to merge, close the current dataset(s) first.");
                return false;
            }
            if (this.switchGraphType(df.getGraphType())) {
                df = new DataFile(data, this.plotPanels.size(), this.gs);
            }
            String s = "data(" + (this.plotPanels.size() + 1) + ")";
            this.dataArrays.add(data);
            PanelPlot pp = new PanelPlot(this.jplot, df, this.gs);
            this.tabbedPane.insertTab(s, null, pp, null, this.plotPanels.size());
            pp.updateStyle(0, data);
            this.tabbedPane.setSelectedIndex(this.plotPanels.size());
            this.plotPanels.add(pp);
            this.showGraph(false);
        }
        return res;
    }

    public Vector getDataArray() {
        return this.dataArrays;
    }

    public DataArray getDataArray(int ind) {
        if (ind > this.dataArrays.size()) {
            System.out.println("Wrong index to get DataArray");
            return null;
        }
        return this.dataArrays.elementAt(ind);
    }

    public DataArray getDataArraySelected() {
        int i = this.tabbedPane.getSelectedIndex();
        return this.getDataArray(i);
    }

    void removeDatafile() {
        boolean ret = true;
        int nFiles = this.plotPanels.size();
        int i = this.tabbedPane.getSelectedIndex();
        if (i == -1) {
            return;
        }
        if (i > nFiles) {
            if (nFiles > 0) {
                Utils.oops(this.frame, "Select first a data panel for removal");
            } else {
                Utils.oops(this.frame, "Nothing to remove, no data loaded");
            }
        } else {
            String txt = "Close " + this.tabbedPane.getTitleAt(i) + ", " + this.plotPanels.get(i).getDataFile().getFilenameWithoutPath() + "?";
            int res = JOptionPane.showConfirmDialog(this.jplot, txt, "", 0);
            if (res == 0) {
                this.tabbedPane.removeTabAt(i);
                this.plotPanels.removeElementAt(i);
                for (int k = 0; k < nFiles - 1; ++k) {
                    this.tabbedPane.setTitleAt(k, "data(" + (k + 1) + ")");
                    this.plotPanels.get(k).setDataFileIndex(k);
                }
                if (this.plotFrame != null) {
                    if (nFiles - 1 == 0) {
                        this.dismissGraph();
                    } else {
                        this.updateGraphIfShowing();
                    }
                }
            }
        }
    }

    private void exportImage() {
        ExportVGraphics.exportDialog(this.jplot, JPlot.class.getName(), this.jplot.frame);
    }

    private boolean saveScript() {
        boolean res = true;
        if (this.scriptFile == null) {
            if (!this.saveAsScript()) {
                res = false;
            }
        } else if (!this.writeScript(this.scriptFile)) {
            res = false;
            this.scriptFile = null;
        }
        if (res) {
            this.gs.setDataChanged(false);
            if (this.scriptFile != null) {
                this.gs.setTitleName(this.scriptFile.toString());
            }
        }
        return res;
    }

    private boolean saveAsScript() {
        boolean ret = true;
        JFileChooser chooser = new JFileChooser(new File("."));
        InputFileFilter ff = new InputFileFilter();
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showDialog(this.jplot, "Save As") == 0) {
            int res;
            this.scriptFile = chooser.getSelectedFile();
            if (this.scriptFile == null) {
                return false;
            }
            if (this.scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this.jplot, "The file exist: do you want to overwrite the file?", "", 0)) == 1) {
                ret = false;
            }
            if (ret && !this.writeScript(this.scriptFile)) {
                ret = false;
            }
        }
        return ret;
    }

    public boolean writeScript(File f) {
        boolean res = true;
        XMLWrite xw = new XMLWrite();
        xw.open("jplot");
        xw.setData("look-and-feel", currentLookAndFeel);
        int nFiles = this.plotPanels.size();
        for (int k = 0; k < nFiles; ++k) {
            this.plotPanels.get(k).getDataFile().getSettings(xw, null);
        }
        this.gs.getSettings(xw);
        xw.close();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(f));
            pw.println(xw.getSettings());
            xw.clear();
            pw.close();
        }
        catch (IOException e) {
            Utils.bummer(this.frame, "It's somehow impossible to write to " + f.toString());
            res = false;
        }
        return res;
    }

    private void openScript() {
        JFileChooser chooser = new JFileChooser(new File("."));
        InputFileFilter ff = new InputFileFilter();
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showOpenDialog(this.jplot) == 0) {
            if (this.gs.dataChanged()) {
                int result = JOptionPane.showConfirmDialog(this.jplot, "Settings have changed, save the current project first?");
                if (result == 2) {
                    return;
                }
                if (result == 0 && !this.saveScript()) {
                    return;
                }
            }
            this.scriptFile = chooser.getSelectedFile();
            if (this.scriptFile.exists()) {
                this.loadScript();
            } else {
                this.scriptFile = null;
            }
        }
    }

    public void readProject(String ffile) {
        this.scriptFile = new File(ffile);
        this.loadScript();
    }

    private void loadScript() {
        if (!this.scriptFile.exists() || !this.scriptFile.canRead()) {
            Utils.bummer(this.frame, "Can't read from " + this.scriptFile);
            return;
        }
        XMLRead xr = new XMLRead();
        this.clear();
        if (!xr.parse(this.scriptFile, "jplot")) {
            return;
        }
        String laf = currentLookAndFeel;
        laf = xr.getString("look-and-feel", laf);
        PanelPlot pp = null;
        boolean k = true;
        while (xr.open("datafile")) {
            if (this.insertDatafile(new File(xr.getString("name", "")))) {
                pp = this.plotPanels.get(this.plotPanels.size() - 1);
                pp.getDataFile().updateSettings(xr);
                pp.update();
            }
            xr.close();
            xr.hide("datafile");
        }
        xr.unHide();
        this.gs.updateSettings(xr);
        this.gs.setTitleName(this.scriptFile.toString());
        this.gs.setDataChanged(false);
        this.showGraph(true);
    }

    public void update(String fn) {
        if (fn.equals("") || fn == null) {
            this.clear();
            return;
        }
        boolean found = false;
        Enumeration<PanelPlot> e = this.plotPanels.elements();
        while (e.hasMoreElements()) {
            PanelPlot pp = e.nextElement();
            DataFile df = pp.getDataFile();
            if (!df.getName().equals(fn) && !df.getFilenameWithoutPath().equals(fn)) continue;
            pp.reload();
            found = true;
            break;
        }
        if (!found) {
            this.insertDatafile(new File(fn));
        }
        this.updateGraphIfShowing();
    }

    public void setAutoUpdate(boolean b) {
        this.mi_autoUpdate.setSelected(b);
        if (b) {
            if (this.timer == null) {
                this.timer = new Timer(this.autoUpdateInterval, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Enumeration<PanelPlot> e1 = JPlot.this.plotPanels.elements();
                        while (e1.hasMoreElements()) {
                            DataFile df = e1.nextElement().getDataFile();
                            File tmp = new File(df.getFile().toString());
                            if (tmp.lastModified() <= df.getLastModified()) continue;
                            JPlot.this.jplot;
                            JPlot.this.updateGraphIfShowing(false);
                            df.setLastModified(tmp.lastModified());
                        }
                    }
                });
            }
            this.timer.start();
        } else if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void setGraphLocation(int x, int y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void show(String fn) {
        if (this.isStandAlone) {
            this.frame.setState(0);
            this.frame.setVisible(true);
        }
        this.update(fn);
        if (this.plotFrame == null) {
            this.showGraph(true);
        }
    }

    public void clear() {
        if (this.plotFrame != null) {
            this.dismissGraph();
        }
        if (this.plotPanels.size() > 0) {
            this.plotPanels.removeAllElements();
        }
        if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.removeAll();
        }
        Enumeration<PanelPlot> e = this.plotPanels.elements();
        while (e.hasMoreElements()) {
            this.plotPanels.get(0).clearSelection();
            if (this.tabbedPane == null || this.tabbedPane.getTabCount() <= 0) continue;
            this.tabbedPane.removeTabAt(0);
        }
        this.gs.reset();
        this.repaint();
    }

    public Vector getAllPanels() {
        return this.plotPanels;
    }

    protected boolean isAvailableLookAndFeel(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void updateLookAndFeel(String laf) {
        if (currentLookAndFeel != laf) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            currentLookAndFeel = laf;
            try {
                UIManager.setLookAndFeel(currentLookAndFeel);
                JPlot jPlot = this;
                Frame[] frames = jPlot.frame.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    SwingUtilities.updateComponentTreeUI(frames[i]);
                    Window[] windows = frames[i].getOwnedWindows();
                    for (int j = 0; j < windows.length; ++j) {
                        SwingUtilities.updateComponentTreeUI(windows[j]);
                    }
                }
            }
            catch (Exception ex) {
                String s = currentLookAndFeel.equals(macLaf) ? "Macintosh Look & Feel" : (currentLookAndFeel.equals(metalLaf) ? "Java Look & Feel" : (currentLookAndFeel.equals(motifLaf) ? "Motif Look & Feel" : (currentLookAndFeel.equals(gtkLaf) ? "GTK+ Look & Feel" : "Windows Look & Feel")));
                Utils.oops(this.frame, "Couldn't load the " + s + ".\nIt's probably not available for this platform (copyright problem?).");
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.mi_mac.setSelected(false);
            this.mi_java.setSelected(false);
            this.mi_motif.setSelected(false);
            this.mi_windows.setSelected(false);
            this.mi_gtk.setSelected(false);
            if (currentLookAndFeel.equals(macLaf)) {
                this.mi_mac.setSelected(true);
            } else if (currentLookAndFeel.equals(windowsLaf)) {
                this.mi_windows.setSelected(true);
            } else if (currentLookAndFeel.equals(motifLaf)) {
                this.mi_motif.setSelected(true);
            } else if (currentLookAndFeel.equals(gtkLaf)) {
                this.mi_gtk.setSelected(true);
            } else {
                this.mi_java.setSelected(true);
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.gs.setDataChanged(true);
        }
    }

    private class DataFileFilter1
    extends FileFilter {
        private DataFileFilter1() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".res") || pathname.getName().endsWith(".dat");
        }

        @Override
        public String getDescription() {
            return "data files (*.res, *.dat)";
        }
    }

    private class DataFileFilter2
    extends FileFilter {
        private DataFileFilter2() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".ppr");
        }

        @Override
        public String getDescription() {
            return "piper files (*.ppr)";
        }
    }

    private class InputFileFilter
    extends FileFilter {
        private InputFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".jpt");
        }

        @Override
        public String getDescription() {
            return "JPlot scripts (*.jpt)";
        }
    }
}

