/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JPanel;

public class Axis {
    private static final boolean DEBUG = false;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static final double LOG10SCALE = 1.0 / Math.log(10.0);
    private static NumberFormat numberFormat = null;

    public static double log10(double val) {
        return Math.log(val) * LOG10SCALE;
    }

    public static double exp10(double val) {
        return Math.exp(val / LOG10SCALE);
    }

    public static float flog10(double val) {
        return (float)Axis.log10(val);
    }

    public static float fexp10(double val) {
        return (float)Axis.exp10(val);
    }

    public static double calculateTicSep(double min, double max, int maxNumberOfTicks) {
        double fl;
        double lrange = Axis.log10(Math.abs(min - max));
        double xnorm = Math.pow(10.0, lrange - (fl = Math.floor(lrange)));
        double posns = (double)maxNumberOfTicks / xnorm;
        double tic = posns > 40.0 ? 0.05 : (posns > 20.0 ? 0.1 : (posns > 10.0 ? 0.2 : (posns > 4.0 ? 0.5 : (posns > 1.0 ? 1.0 : (posns > 0.5 ? 2.0 : (posns > 0.2 ? 10.0 : Math.ceil(xnorm)))))));
        return tic *= Math.pow(10.0, fl);
    }

    public static int calculateTicNumber(double ticMinVal, double ticMaxVal, double xStep, boolean isLog) {
        int n = 0;
        if (!isLog) {
            double xStart;
            for (double xpos = xStart = xStep * Math.ceil(ticMinVal / xStep); xpos <= ticMaxVal; xpos += xStep) {
                ++n;
            }
        } else {
            int t1 = 0;
            int t2 = 0;
            if (ticMinVal > 0.0) {
                t1 = (int)Math.floor(Axis.log10(ticMinVal) - 0.5);
            }
            if (ticMinVal < 0.0) {
                t1 = -1 * (int)Math.floor(Axis.log10(-1.0 * ticMinVal) - 0.5);
            }
            if (ticMaxVal > 0.0) {
                t2 = (int)Math.floor(Axis.log10(ticMaxVal) + 1.0);
            }
            if (ticMaxVal < 0.0) {
                t2 = -1 * (int)Math.floor(Axis.log10(-1.0 * ticMaxVal) + 1.0);
            }
            for (int i = t1; i < t2 + 1; ++i) {
                ++n;
            }
        }
        return n;
    }

    public static Vector<String> computeTicks(double ticMinVal, double ticMaxVal, int maxTicks, boolean isLog) {
        double xStep = Axis.calculateTicSep(ticMinVal, ticMaxVal, maxTicks);
        int numfracdigits = Axis.numFracDigits(xStep);
        double xStart = xStep * Math.ceil(ticMinVal / xStep);
        Object xgrid = null;
        Vector<String> labels = new Vector<String>();
        if (!isLog) {
            for (double xpos = xStart; xpos <= ticMaxVal; xpos += xStep) {
                String snum = Axis.formatNum(xpos, numfracdigits);
                labels.addElement(snum);
            }
        } else {
            int t1 = 0;
            int t2 = 0;
            if (ticMinVal > 0.0) {
                t1 = (int)Math.floor(Axis.log10(ticMinVal) - 0.5);
            }
            if (ticMinVal < 0.0) {
                t1 = -1 * (int)Math.floor(Axis.log10(-1.0 * ticMinVal) - 0.5);
            }
            if (ticMaxVal > 0.0) {
                t2 = (int)Math.floor(Axis.log10(ticMaxVal) + 1.0);
            }
            if (ticMaxVal < 0.0) {
                t2 = -1 * (int)Math.floor(Axis.log10(-1.0 * ticMaxVal) + 1.0);
            }
            for (int i = t1; i < t2 + 1; ++i) {
                double pp = Math.pow(10.0, i);
                labels.addElement(Double.toString(pp));
            }
        }
        return labels;
    }

    public static void drawAxis(int axis, int maxTics, int ticLength, float lowVal, float highVal, int screenStart, int screenEnd, int screenOffset, boolean logScale, int screenHeight, Graphics g) {
        if (logScale && (lowVal == 0.0f || highVal == 0.0f)) {
            throw new IllegalArgumentException("Axis.drawAxis: zero range value not allowed in log axes");
        }
        if (axis == 0) {
            g.drawLine(screenStart, screenHeight - screenOffset, screenEnd, screenHeight - screenOffset);
        } else {
            g.drawLine(screenOffset, screenStart, screenOffset, screenEnd);
        }
        Vector<String> tics = Axis.computeTicks(lowVal, highVal, maxTics, logScale);
        int last_label_end = axis == 0 ? -88888 : 88888;
        String dbgstr = "tics:    ";
        Enumeration<String> e = tics.elements();
        while (e.hasMoreElements()) {
            String ticstr = e.nextElement();
            float ticval = Float.parseFloat(ticstr);
            int tic_coord = screenStart;
            Dimension str_size = Axis.stringSize(ticstr, g);
            tic_coord += Axis.plotValue(ticval, lowVal, highVal, screenStart, screenEnd, logScale, screenHeight);
            if (axis == 0) {
                g.drawLine(tic_coord, screenHeight - screenOffset, tic_coord, screenHeight - screenOffset + ticLength);
                if (tic_coord - str_size.width / 2 <= last_label_end) continue;
                g.drawString(ticstr, tic_coord - str_size.width / 2, screenHeight - screenOffset + str_size.height + 5);
                last_label_end = tic_coord + str_size.width / 2 + str_size.height / 2;
                continue;
            }
            tic_coord = screenHeight - tic_coord;
            g.drawLine(screenOffset - ticLength, tic_coord, screenOffset, tic_coord);
            if (tic_coord - str_size.height / 3 >= last_label_end) continue;
            g.drawString(ticstr, screenOffset - ticLength - str_size.width - 5, tic_coord + str_size.height / 3);
            last_label_end = tic_coord - str_size.height;
        }
    }

    public static int plotValue(float val, float lowVal, float highVal, int screenStart, int screenEnd, boolean logScale, int screenHeight) {
        if (logScale && (lowVal == 0.0f || highVal == 0.0f || val == 0.0f)) {
            throw new IllegalArgumentException("Axis.drawAxis: zero range value not allowed in log axes");
        }
        int screen_range = screenEnd - screenStart;
        if (logScale) {
            float log_low = Axis.flog10(lowVal);
            float log_high = Axis.flog10(highVal);
            float log_val = Axis.flog10(val);
            float log_range = log_high - log_low;
            float pixels_per_log_unit = (float)screen_range / log_range;
            return (int)((double)((log_val - log_low) * pixels_per_log_unit) + 0.5);
        }
        float value_range = highVal - lowVal;
        float pixels_per_unit = (float)screen_range / value_range;
        return (int)((double)((val - lowVal) * pixels_per_unit) + 0.5);
    }

    private static double roundUp(double val) {
        int exponent;
        if ((val *= Math.pow(10.0, -(exponent = (int)Math.floor(Axis.log10(val))))) > 5.0) {
            val = 10.0;
        } else if (val > 2.0) {
            val = 5.0;
        } else if (val > 1.0) {
            val = 2.0;
        }
        return val *= Math.pow(10.0, exponent);
    }

    private static int numFracDigits(double num) {
        int numdigits;
        for (numdigits = 0; numdigits <= 15 && num != Math.floor(num); num *= 10.0, ++numdigits) {
        }
        return numdigits;
    }

    private static String formatNum(double num, int numfracdigits) {
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setGroupingUsed(false);
        }
        numberFormat.setMinimumFractionDigits(numfracdigits);
        numberFormat.setMaximumFractionDigits(numfracdigits);
        return numberFormat.format(num);
    }

    public static Dimension stringSize(String str, Graphics g) {
        if (g instanceof Graphics2D) {
            Rectangle2D bounds = g.getFont().getStringBounds(str, ((Graphics2D)g).getFontRenderContext());
            return new Dimension((int)(bounds.getWidth() + 0.5), (int)(bounds.getHeight() + 0.5));
        }
        return new Dimension(g.getFontMetrics().stringWidth(str), g.getFontMetrics().getHeight());
    }

    private static void addField(Container into, Component c, GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        into.add(c, gbc);
    }

    public static void main(String[] args) {
    }

    private static class TestPanel
    extends JPanel {
        private float curLowVal;
        private float curHighVal;
        private boolean logScale;

        public TestPanel(float initialLow, float initialHigh) {
            this.curLowVal = initialLow;
            this.curHighVal = initialHigh;
        }

        public void setLogScale(boolean logScale) {
            this.logScale = logScale;
            this.repaint();
        }

        public void setLow(float val) {
            this.curLowVal = val;
            this.repaint();
        }

        public void setHigh(float val) {
            this.curHighVal = val;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Axis.drawAxis(0, 10, 5, this.curLowVal, this.curHighVal, 50, this.getWidth() - 50, 50, this.logScale, this.getHeight(), g);
            Axis.drawAxis(1, 10, 5, this.curLowVal, this.curHighVal, 50, this.getHeight() - 50, 50, this.logScale, this.getHeight(), g);
            g.drawString("Current Slider Range: " + this.curLowVal + " --> " + this.curHighVal, 10, 20);
        }
    }
}

