/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

public class Vector3d {
    float x;
    float y;
    float z;

    public Vector3d() {
    }

    public Vector3d(Vector3d v) {
        this.copy(v);
    }

    public Vector3d(float x, float y, float z) {
        this.set(x, y, z);
    }

    public void copy(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(Vector3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void sub(Vector3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void cmul(Vector3d v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
    }

    public float dot(Vector3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public void mul(Vector3d v) {
        float tx = this.x;
        float ty = this.y;
        float tz = this.z;
        this.x = ty * v.z - tz * v.y;
        this.y = tz * v.x - tx * v.z;
        this.z = tx * v.y - ty * v.x;
    }

    public void mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void div(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    public boolean equals(Vector3d v) {
        if (v == null) {
            return false;
        }
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public float vabs() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize() {
        float t = this.vabs();
        this.x /= t;
        this.y /= t;
        this.z /= t;
    }

    float cos(Vector3d v) {
        return this.dot(v) / (this.vabs() * v.vabs());
    }

    float sin(Vector3d v) {
        Vector3d t = new Vector3d(this);
        t.mul(v);
        return t.vabs() / (this.vabs() * v.vabs());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public void print() {
        System.out.println(this.toString());
    }
}

