/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.applet.Applet;
import java.awt.Graphics;
import java.util.ArrayList;
import jhplot.v3d.BoundingBox;
import jhplot.v3d.Matrix3d;
import jhplot.v3d.Object3d;
import jhplot.v3d.Position;
import jhplot.v3d.Vector3d;

public class Model3d
extends Position {
    Applet app;
    int width;
    int height;
    Matrix3d mat;
    int nobj;
    float ambient;
    static final float defaultAmbient = 0.0f;
    public float minScale;
    static final float defaultMinScale = 0.5f;
    public float maxScale;
    static final float defaultMaxScale = 1.0f;
    BoundingBox bb;
    float zCamera;
    float zTarget;
    public boolean persp = true;
    boolean moveAfterPaint = true;
    public ArrayList<Object3d> obj;

    public Model3d(Applet app, int width, int height) {
        this.app = app;
        this.width = width;
        this.height = height;
        this.obj = new ArrayList();
        this.nobj = 0;
        this.ambient = this.param("ambient", 0.0f);
        this.minScale = this.param("minscale", 0.5f);
        this.maxScale = this.param("maxscale", 1.0f);
        if (this.ambient < 0.0f || this.ambient > 1.0f) {
            this.ambient = 0.0f;
        }
        if (this.minScale > this.maxScale) {
            this.minScale = 0.5f;
            this.maxScale = 1.0f;
        }
    }

    public String param(String name, String defaultValue) {
        String value = defaultValue;
        if (this.app != null) {
            try {
                value = this.app.getParameter(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return value;
    }

    public boolean param(String name, boolean defaultValue) {
        boolean value = defaultValue;
        if (this.app != null) {
            try {
                value = Boolean.valueOf(this.app.getParameter(name));
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return value;
    }

    public int param(String name, int defaultValue) {
        int value = defaultValue;
        if (this.app != null) {
            try {
                value = Integer.valueOf(this.app.getParameter(name));
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return value;
    }

    public float param(String name, float defaultValue) {
        float value = defaultValue;
        if (this.app != null) {
            try {
                value = Float.valueOf(this.app.getParameter(name)).floatValue();
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return value;
    }

    public int addObject(Object3d o) {
        this.obj.add(o);
        this.nobj = this.obj.size();
        this.computeMatrix();
        return this.nobj;
    }

    synchronized void paint(Graphics g) {
        int i;
        for (i = 0; i < this.nobj; ++i) {
            this.obj.get(i).transformToScreenSpace();
        }
        this.setPaintOrder();
        for (i = 0; i < this.nobj; ++i) {
            this.obj.get(i).paint(g);
        }
        if (this.moveAfterPaint) {
            this.move();
        }
    }

    synchronized String inside(int x, int y) {
        for (int i = this.nobj - 1; i >= 0; --i) {
            Object3d o = this.obj.get(i);
            if (o.inside(x, y) < 0) continue;
            if (o.name != null) {
                return o.name;
            }
            return "noname";
        }
        return null;
    }

    void setPaintOrder() {
        this.zSort();
    }

    void zSort() {
        if (this.nobj <= 1) {
            return;
        }
        boolean cont = true;
        while (cont) {
            cont = false;
            Object3d a = this.obj.get(0);
            for (int i = 1; i < this.nobj; ++i) {
                Object3d b = this.obj.get(i);
                if (a.center.z > b.center.z) {
                    this.obj.set(i - 1, b);
                    this.obj.set(i, a);
                    cont = true;
                }
                a = this.obj.get(i);
            }
        }
    }

    void move() {
    }

    void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.computeMatrix();
    }

    public synchronized void computeMatrix() {
        if (this.bb == null) {
            this.computeBoundingBox();
        }
        Vector3d c = this.bb.getCenter();
        float f1 = (float)this.width / this.bb.getWidth();
        float f2 = (float)this.height / this.bb.getHeight();
        float f = 0.7f * Math.min(f1, f2);
        this.mat = new Matrix3d();
        this.mat.trans(-c.x, -c.y, -c.z);
        this.mat.scale(f, f, f);
        float dz = f * this.bb.getDepth();
        float h1 = dz * this.minScale / (this.maxScale - this.minScale);
        this.zCamera = h1 + dz / 2.0f;
        this.zTarget = -h1 * this.maxScale;
        if (this.persp) {
            this.mat.trans(0.0f, 0.0f, -this.zCamera);
        } else {
            this.mat.scale(1.0f, -1.0f, 1.0f);
            this.mat.trans(this.width / 2, this.height / 2, 0.0f);
        }
    }

    void computeBoundingBox() {
        Object3d o = this.obj.get(0);
        o.transformToCameraSpace();
        this.bb = new BoundingBox(o.vert, o.nvert);
        for (int i = 1; i < this.nobj; ++i) {
            o = this.obj.get(i);
            o.transformToCameraSpace();
            this.bb.combine(new BoundingBox(o.vert, o.nvert));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHight() {
        return this.height;
    }

    void setPersp(boolean persp) {
        if (persp == this.persp) {
            return;
        }
        this.persp = persp;
        if (this.mat == null) {
            return;
        }
        if (persp) {
            this.mat.trans(-this.width / 2, -this.height / 2, 0.0f);
            this.mat.scale(1.0f, -1.0f, 1.0f);
            this.mat.trans(0.0f, 0.0f, -this.zCamera);
        } else {
            this.mat.trans(0.0f, 0.0f, this.zCamera);
            this.mat.scale(1.0f, -1.0f, 1.0f);
            this.mat.trans(this.width / 2, this.height / 2, 0.0f);
        }
    }
}

