/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import jhplot.P1D;
import jhplot.gui.HelpBrowser;

public class BunchingParameters {
    private int Bins = 0;
    private double Min = 0.0;
    private int[][] ICC;
    private int Nmax;
    private double[][] BP;
    private double[][] ER;
    private int[] IBI;
    private double[] BI;
    private int[][][] NCO;
    private int[][][] IH;
    private int[][][][] CM;
    private int Nev = 0;
    private double[][] HB;
    private int IMAX = 0;

    public BunchingParameters(int NmaxOrder, int Bins, int step, double Min, double Max) {
        int i;
        this.Bins = Bins;
        this.Min = Min;
        this.Nmax = NmaxOrder + 1;
        if (this.Bins < 2) {
            System.out.println("Number of bins should be larger than 2");
            return;
        }
        if (this.Nmax < 3) {
            System.out.println("Order if BP should be larger than 2");
            return;
        }
        this.IBI = new int[Bins];
        for (i = 0; i < Bins; ++i) {
            this.IBI[i] = 1 + i * step;
        }
        this.IMAX = this.IBI[Bins - 1];
        this.BI = new double[Bins];
        for (i = 0; i < Bins; ++i) {
            this.BI[i] = (Max - Min) / (double)this.IBI[i];
        }
        this.ICC = new int[Bins][this.IMAX];
        this.NCO = new int[this.Nmax][Bins][this.IMAX];
        this.IH = new int[this.Nmax][Bins][this.IMAX];
        this.CM = new int[this.Nmax][this.Nmax][Bins][this.IMAX];
        this.HB = new double[this.Nmax][this.IMAX];
        this.BP = new double[this.Nmax][Bins];
        this.ER = new double[this.Nmax][Bins];
        this.Nev = 0;
        for (int n = 0; n < this.Nmax; ++n) {
            for (int i2 = 0; i2 < Bins; ++i2) {
                for (int j = 0; j < this.IBI[i2]; ++j) {
                    this.NCO[n][i2][j] = 0;
                    this.IH[n][i2][j] = 0;
                }
            }
        }
    }

    public void run(double[] v) {
        int j;
        int i;
        ++this.Nev;
        for (i = 0; i < this.Bins; ++i) {
            for (j = 0; j < this.IBI[i]; ++j) {
                this.ICC[i][j] = 0;
            }
        }
        for (i = 0; i < this.Bins; ++i) {
            for (j = 0; j < this.IBI[i]; ++j) {
                double m1 = this.Min + this.BI[i] * (double)j;
                double m2 = this.Min + this.BI[i] * (double)(j + 1);
                for (int m = 0; m < v.length; ++m) {
                    if (!(v[m] > m1) || !(v[m] < m2)) continue;
                    int[] nArray = this.ICC[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (int n = 0; n < this.Nmax; ++n) {
            for (int i2 = 0; i2 < this.Bins; ++i2) {
                for (int j2 = 0; j2 < this.IBI[i2]; ++j2) {
                    if (this.ICC[i2][j2] == n) {
                        this.NCO[n][i2][j2] = 1;
                        int[] nArray = this.IH[n][i2];
                        int n2 = j2;
                        nArray[n2] = nArray[n2] + 1;
                        continue;
                    }
                    this.NCO[n][i2][j2] = 0;
                }
            }
        }
        for (i = 0; i < this.Bins; ++i) {
            for (j = 0; j < this.IBI[i]; ++j) {
                for (int n1 = 0; n1 < this.Nmax - 1; ++n1) {
                    for (int n2 = 0; n2 < this.Nmax - 1; ++n2) {
                        this.CM[n1][n2][i][j] = this.CM[n1][n2][i][j] + this.NCO[n1][i][j] * this.NCO[n2][i][j];
                    }
                }
            }
        }
    }

    public boolean eval() {
        int j;
        int i2;
        int i1;
        int i;
        boolean tmp = true;
        this.HB = new double[this.Nmax][this.Bins];
        for (i = 0; i < this.Nmax - 1; ++i) {
            for (int j2 = 0; j2 < this.Bins; ++j2) {
                this.HB[i][j2] = 0.0;
            }
        }
        for (int n = 0; n < this.Nmax; ++n) {
            for (int i3 = 0; i3 < this.Bins; ++i3) {
                for (int j3 = 0; j3 < this.IBI[i3]; ++j3) {
                    this.HB[n][i3] = this.HB[n][i3] + (double)this.IH[n][i3][j3];
                }
                this.HB[n][i3] = this.HB[n][i3] / (double)this.IBI[i3];
            }
        }
        for (i = 1; i < this.Nmax - 1; ++i) {
            double f = (double)(i + 1) / (double)i;
            for (int j4 = 0; j4 < this.Bins; ++j4) {
                if (this.HB[i][j4] == 0.0) {
                    this.BP[i][j4] = -1.0;
                    continue;
                }
                this.BP[i + 1][j4] = f * (this.HB[i + 1][j4] * this.HB[i - 1][j4]) / (this.HB[i][j4] * this.HB[i][j4]);
            }
        }
        double[][] H = new double[this.Nmax][this.Bins];
        double AN = this.Nev;
        for (int i4 = 0; i4 < this.Nmax; ++i4) {
            for (int j5 = 0; j5 < this.Bins; ++j5) {
                H[i4][j5] = this.HB[i4][j5] / AN;
            }
        }
        double[][][] CE = new double[this.Nmax][this.Nmax][this.Bins];
        for (i1 = 0; i1 < this.Nmax; ++i1) {
            for (i2 = 0; i2 < this.Nmax - 1; ++i2) {
                for (j = 0; j < this.Bins; ++j) {
                    CE[i1][i2][j] = 0.0;
                }
            }
        }
        for (i1 = 0; i1 < this.Nmax; ++i1) {
            for (i2 = 0; i2 < this.Nmax; ++i2) {
                for (j = 0; j < this.Bins; ++j) {
                    for (int i5 = 0; i5 < this.IBI[j]; ++i5) {
                        CE[i1][i2][j] = CE[i1][i2][j] + (double)this.CM[i1][i2][j][i5];
                    }
                }
            }
        }
        double XN = AN * AN;
        for (int m = 0; m < this.Bins; ++m) {
            double ba = this.IBI[m];
            double b = ba * ba;
            for (int i12 = 0; i12 < this.Nmax; ++i12) {
                for (int i22 = 0; i22 < this.Nmax; ++i22) {
                    CE[i12][i22][m] = CE[i12][i22][m] - AN * ba * H[i12][m] * H[i22][m];
                    CE[i12][i22][m] = CE[i12][i22][m] / (XN * b);
                }
            }
        }
        for (int i6 = 1; i6 < this.Nmax - 1; ++i6) {
            for (int m = 0; m < this.Bins; ++m) {
                if (H[i6][m] == 0.0) {
                    H[i6][m] = 1.0E-5;
                    tmp = false;
                }
                double p4 = Math.pow(H[i6][m], 4.0);
                double p2 = H[i6 - 1][m] * H[i6 - 1][m];
                double p5 = Math.pow(H[i6][m], 5.0);
                double A1 = CE[i6 + 1][i6 + 1][m] * p2 / p4;
                double A2 = 4.0 * CE[i6][i6][m] * (H[i6 + 1][m] * H[i6 + 1][m]) * p2 / Math.pow(H[i6][m], 6.0);
                double A3 = CE[i6 - 1][i6 - 1][m] * (H[i6 + 1][m] * H[i6 + 1][m]) / p4;
                double A4 = 2.0 * CE[i6 + 1][i6 - 1][m] * H[i6 + 1][m] * H[i6 - 1][m] / p4;
                double A5 = 4.0 * CE[i6 + 1][i6][m] * H[i6 + 1][m] * p2 / p5;
                double A6 = 4.0 * CE[i6][i6 - 1][m] * (H[i6 + 1][m] * H[i6 + 1][m]) * H[i6 - 1][m] / p5;
                double AM = A1 + A2 + A3 + A4 - A5 - A6;
                this.ER[i6 + 1][m] = (double)(i6 + 1) / (double)i6 * Math.sqrt(AM);
            }
        }
        return tmp;
    }

    public P1D getBP(int order) {
        if (order > this.Nmax) {
            System.out.println("BP order is larger then allowed max 8");
            return null;
        }
        if (order < 2) {
            System.out.println("BP order is too small");
            return null;
        }
        P1D pp = new P1D("BP_{" + Integer.toString(order) + "}");
        for (int i = 1; i < this.Bins; ++i) {
            pp.add(this.IBI[i], this.BP[order][i], this.ER[order][i]);
        }
        return pp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

