/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca;

import Jama.Matrix;
import jhplot.math.pca.covmatrixevd.EVDResult;

class EVDWithThreshold {
    public static final double precision = 2.220446E-16;
    private final EVDResult evd;
    private final double threshold;

    public EVDWithThreshold(EVDResult evd) {
        this(evd, Math.sqrt(2.220446E-16));
    }

    public EVDWithThreshold(EVDResult evd, double tol) {
        this.evd = evd;
        this.threshold = EVDWithThreshold.firstComponentSD(evd) * tol;
    }

    private static double firstComponentSD(EVDResult evd) {
        return Math.sqrt(evd.d.get(0, 0));
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Matrix getDAboveThreshold() {
        int aboveThresholdElemsNo = this.getElementsNoAboveThreshold();
        Matrix newD = this.evd.d.getMatrix(0, aboveThresholdElemsNo - 1, 0, aboveThresholdElemsNo - 1);
        return newD;
    }

    public Matrix getVAboveThreshold() {
        return this.evd.v.getMatrix(0, this.evd.v.getRowDimension() - 1, 0, this.getElementsNoAboveThreshold() - 1);
    }

    public Matrix getVBelowThreshold() {
        return this.evd.v.getMatrix(0, this.evd.v.getRowDimension() - 1, this.getElementsNoAboveThreshold(), this.evd.v.getColumnDimension() - 1);
    }

    private int getElementsNoAboveThreshold() {
        for (int i = 0; i < this.evd.d.getColumnDimension(); ++i) {
            double val = Math.sqrt(this.evd.d.get(i, i));
            if (val > this.threshold) continue;
            return i;
        }
        return this.evd.d.getColumnDimension();
    }
}

