/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.root;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.Function;
import jhplot.math.num.IterativeMethod;
import jhplot.math.num.NumericException;

public class FalsePositionRootFinder
extends IterativeMethod {
    private Function function;

    public FalsePositionRootFinder(Function f) {
        this(f, 100, 1.0E-15);
    }

    public FalsePositionRootFinder(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public double findRoot(double min, double max) throws NumericException {
        double error;
        double f;
        double x;
        double x0 = min;
        double x1 = max;
        double f0 = this.function.evaluate(x0);
        double f1 = this.function.evaluate(x1);
        int n = 0;
        if (f0 > 0.0) {
            x = x0;
            x0 = x1;
            x1 = x;
            f = f0;
            f0 = f1;
            f1 = f;
        }
        do {
            double delta = f1 * (x1 - x0) / (f1 - f0);
            x = x1 - delta;
            f = this.function.evaluate(x);
            error = Math.max(Math.abs(f), Math.abs(delta / x1));
            if (f < 0.0) {
                x0 = x;
                f0 = f;
                continue;
            }
            x1 = x;
            f1 = f;
        } while (++n < this.getMaximumIterations() && error > this.getMaximumRelativeError());
        if (n >= this.getMaximumIterations()) {
            throw new ConvergenceException("False position method failed to converge.");
        }
        return x;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }
}

