/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io.images;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import javax.swing.JComponent;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.deploy.svg.WSVGGraphics2D;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSDocumentGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportCanvas {
    private static int containerCounter = 0;
    private static int graphCounter = 0;
    private static int axisCounter = 0;
    private static int plotCounter = 0;
    private static PDFTranscoder transcoder = null;

    private ExportCanvas() {
    }

    public static String saveAsSVG(Component c) throws IOException {
        StringWriter stream = new StringWriter();
        String s = ExportCanvas.doSVG(c, stream);
        return s;
    }

    public static void saveAsSVG(Component c, String str) throws IOException {
        FileOutputStream outputStream = ExportCanvas.createOutputStream(str);
        ExportCanvas.doSVG(c, outputStream);
    }

    public static void saveAsSVG(Component c, File f) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(f);
        ExportCanvas.doSVG(c, outputStream);
        outputStream.close();
    }

    public static void saveAsCompressedSVG(Component c, File f) throws IOException {
        GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(f));
        ExportCanvas.doSVG(c, outputStream);
        outputStream.close();
    }

    public static ByteArrayInputStream saveAsPDF(Component c) throws IOException {
        StringWriter stream = new StringWriter();
        return ExportCanvas.convertSVG2PDF(ExportCanvas.doSVG(c, stream));
    }

    public static void saveAsPDF(Component c, String s) throws IOException {
        ExportCanvas.saveAsPDF(c, new File(s));
    }

    public static void saveAsPDF(Component c, File f) throws IOException {
        StringWriter stream = new StringWriter();
        String s = ExportCanvas.doSVG(c, stream);
        ExportCanvas.convertSVG2PDF(s, f);
    }

    public static ByteArrayOutputStream saveAsEPS(Component c) throws IOException {
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        g2d.setupDocument((OutputStream)stream, c.getWidth(), c.getHeight());
        ExportCanvas.paint(c, (Graphics)g2d);
        g2d.finish();
        return stream;
    }

    public static void saveAsEPS(Component c, File f) throws IOException {
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        FileOutputStream stream = ExportCanvas.createOutputStream(f);
        g2d.setupDocument((OutputStream)stream, c.getWidth(), c.getHeight());
        ExportCanvas.paint(c, (Graphics)g2d);
        g2d.finish();
        stream.close();
    }

    public static ByteArrayOutputStream saveAsPS(Component c) throws IOException {
        PSDocumentGraphics2D g2d = new PSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        g2d.setupDocument((OutputStream)stream, c.getWidth(), c.getHeight());
        ExportCanvas.paint(c, (Graphics)g2d);
        g2d.finish();
        return stream;
    }

    public static void saveAsPS(Component c, File f) throws IOException {
        PSDocumentGraphics2D g2d = new PSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        FileOutputStream stream = ExportCanvas.createOutputStream(f);
        g2d.setupDocument((OutputStream)stream, c.getWidth(), c.getHeight());
        ExportCanvas.paint(c, (Graphics)g2d);
        g2d.finish();
        stream.close();
    }

    private static String doSVG(Component c) throws IOException {
        return ExportCanvas.doSVG(c, new StringWriter(), false);
    }

    private static void doSVG(Component c, OutputStream svgOut) throws IOException {
        ExportCanvas.doSVG(c, svgOut, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSVG(Component c, OutputStream svgOut, boolean textAsStrokes) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated by the Project Waterloo Graphics Library using the Apache Batik SVG Generator");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, textAsStrokes);
        svgGenerator.setSVGCanvasSize(c.getSize());
        Element root = document.getDocumentElement();
        svgGenerator.getRoot(root);
        WSVGGraphics2D g = new WSVGGraphics2D(svgGenerator);
        ExportCanvas.paint(c, g);
        OutputStreamWriter out = null;
        try {
            try {
                out = new OutputStreamWriter(svgOut, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                System.err.println(ex);
            }
            try {
                svgGenerator.stream((Writer)out, textAsStrokes);
            }
            catch (SVGGraphics2DIOException ex) {
                System.err.println((Object)ex);
            }
        }
        finally {
            svgOut.close();
        }
    }

    private static String doSVG(Component c, StringWriter out) throws IOException {
        return ExportCanvas.doSVG(c, out, false);
    }

    private static String doSVG(Component c, StringWriter out, boolean textAsStrokes) throws IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setEmbeddedFontsOn(true);
        ctx.setComment("Generated by the Project Waterloo Graphics Library using the Apache Batik SVG Generator");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        svgGenerator.setSVGCanvasSize(c.getSize());
        Element root = document.getDocumentElement();
        svgGenerator.getRoot(root);
        ExportCanvas.paint(c, (Graphics)svgGenerator);
        try {
            svgGenerator.stream((Writer)out, textAsStrokes);
        }
        catch (SVGGraphics2DIOException ex) {
            System.err.println((Object)ex);
        }
        return out.toString();
    }

    public static void deploySVG(Component c2, File f, Dimension dim, boolean inline, String cssLoc, boolean httpdFlag, ArrayList<String> keyWords, String title, String description) throws IOException {
        String svg = ExportCanvas.doSVG(c2);
        String jsLoc = (String)GJDefaults.getMap().get("SVG.jsLocation");
        if (!((Boolean)GJDefaults.getMap().get("SVG.canvg")).booleanValue()) {
            jsLoc = "";
        }
        WSVGGraphics2D.deploy(f, svg, dim.getSize(), inline, jsLoc, cssLoc, httpdFlag, keyWords, title, description);
    }

    public static String doHTML5(Component c) throws IOException {
        return ExportCanvas.doSVG(c, new StringWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertSVG2PDF(String svg, File pdf) throws IOException {
        if (transcoder == null) {
            transcoder = new PDFTranscoder();
            transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
            transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(svg.getBytes("UTF-8"));){
            TranscoderInput input = new TranscoderInput((InputStream)in);
            OutputStream out = new FileOutputStream(pdf);
            out = new BufferedOutputStream(out);
            try {
                TranscoderOutput output = new TranscoderOutput(out);
                try {
                    transcoder.transcode(input, output);
                }
                catch (TranscoderException ex) {
                    System.err.println((Object)ex);
                }
            }
            finally {
                out.close();
            }
        }
    }

    public static ByteArrayInputStream convertSVG2PDF(String svg) throws IOException {
        if (System.getProperty("waterloo_pdf_supported") != null && System.getProperty("waterloo_pdf_supported").equals("false")) {
            System.err.println("PDFTranscoder not supported");
            return null;
        }
        if (transcoder == null) {
            transcoder = new PDFTranscoder();
            transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
            transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
        }
        TranscoderInput input = new TranscoderInput((Reader)new StringReader(svg));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)out);
        try {
            transcoder.transcode(input, output);
        }
        catch (TranscoderException ex) {
            System.err.print((Object)ex);
        }
        out.flush();
        ByteArrayInputStream pdf = new ByteArrayInputStream(out.toByteArray());
        out.close();
        return pdf;
    }

    private static FileOutputStream createOutputStream(File thisFile) {
        FileOutputStream OutputStream2 = null;
        try {
            OutputStream2 = new FileOutputStream(thisFile);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex);
        }
        return OutputStream2;
    }

    private static FileOutputStream createOutputStream(String str) {
        File thisFile = new File(str);
        return ExportCanvas.createOutputStream(thisFile);
    }

    public static void initGroupMarker() {
        containerCounter = 0;
        graphCounter = 0;
        axisCounter = 0;
        plotCounter = 0;
    }

    public static void createGroupMarker(Object o, String s, Object reference, Graphics g) {
        if (g instanceof SVGGraphics2D) {
            SVGGraphics2D g2 = (SVGGraphics2D)g;
            DOMGroupManager domGroupManager = new DOMGroupManager(g2.getGraphicContext(), g2.getDOMTreeManager());
            g2.getDOMTreeManager().addGroupManager(domGroupManager);
            Element el0 = g2.getDOMFactory().createElementNS(null, "g");
            el0.setAttributeNS(null, "class", "waterloo_graphics_element");
            el0.setAttributeNS(null, "id", String.format("kcl_%x", o.hashCode()));
            Element el1 = g2.getDOMFactory().createElementNS(null, "g");
            el0.appendChild(el1);
            String classString = o.getClass().toString().replaceAll("class ", "");
            el1.setAttributeNS(null, "class", classString);
            if (classString.contains("GraphContainer")) {
                el1.setAttributeNS(null, "id", "Container" + containerCounter);
                ++containerCounter;
            } else if (classString.contains("Graph")) {
                el1.setAttributeNS(null, "id", "Graph" + graphCounter);
                ++graphCounter;
            } else if (classString.contains("AxisPanel")) {
                el1.setAttributeNS(null, "id", "Axis" + axisCounter);
                ++axisCounter;
            } else {
                el1.setAttributeNS(null, "id", "Plot" + plotCounter);
                ++plotCounter;
            }
            Element el2 = g2.getDOMFactory().createElementNS(null, "title");
            el2.setTextContent(s);
            el1.appendChild(el2);
            Element el3 = g2.getDOMFactory().createElementNS(null, "desc");
            el3.setTextContent("Beginning of " + classString + " section");
            el1.appendChild(el3);
            domGroupManager.addElement(el0);
        }
    }

    private static void paint(Component c, Graphics g) {
        if (c instanceof JComponent) {
            boolean state = c.isOpaque();
            ((JComponent)c).setOpaque(true);
            c.paint(g);
            ((JComponent)c).setOpaque(state);
        } else {
            c.paint(g);
        }
    }

    public static final boolean isPresent() {
        return true;
    }
}

