/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.util.Map;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.io.BrowserAida;
import jhplot.io.BrowserHBook;
import jhplot.io.BrowserHFile;
import jhplot.io.BrowserHFileXML;
import jhplot.io.BrowserPFile;
import jhplot.io.BrowserRoot;
import jhplot.io.HBook;
import jhplot.io.HFile;
import jhplot.io.HFileXML;
import jhplot.io.PFile;
import jhplot.utils.Util;

public class BrowserData {
    private Map<String, Object> map;

    public BrowserData(String file, GHFrame frame) {
        String ss = file.toLowerCase();
        if (ss.endsWith(".jser")) {
            HFile hh = new HFile(file);
            if (frame != null) {
                new BrowserHFile(frame, hh, true);
            } else {
                BrowserHFile b = new BrowserHFile(null, hh, true);
                this.map = b.getMap();
            }
        } else if (ss.endsWith(".jxml")) {
            HFileXML hh = new HFileXML(file);
            if (frame != null) {
                new BrowserHFileXML(frame, hh, true);
            } else {
                BrowserHFileXML b = new BrowserHFileXML(null, hh, true);
                this.map = b.getMap();
            }
        } else if (ss.endsWith(".jpbu")) {
            PFile hh = new PFile(file);
            if (frame != null) {
                new BrowserPFile(frame, hh, true);
            } else {
                BrowserPFile b = new BrowserPFile(null, hh, true);
                this.map = b.getMap();
            }
        } else if (ss.endsWith(".jdat")) {
            HBook hb = new HBook(file, "r");
            if (frame != null) {
                new BrowserHBook(frame, hb, true);
            } else {
                BrowserHBook b = new BrowserHBook(null, hb, true);
                this.map = b.getMap();
            }
        } else if (ss.endsWith(".root")) {
            if (frame != null) {
                new BrowserRoot(frame, file, true);
            } else {
                BrowserRoot b = new BrowserRoot(null, file, true);
                this.map = b.getMap();
            }
        } else if (ss.endsWith(".xml") || ss.endsWith(".aida")) {
            if (frame != null) {
                new BrowserAida(frame, file, true);
            } else {
                BrowserAida b = new BrowserAida(null, file, true);
                this.map = b.getMap();
            }
        } else {
            Util.ErrorMessage("Not supported file format. Required:  *.jser, *.jxml, *.jdat, *.root, *.jpbu");
        }
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

