/*
 * Decompiled with CFR 0.152.
 */
package jhplot.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import jhplot.JHPlot;
import jhplot.gui.GHMargin;
import jhplot.io.images.ConvertSVG;
import jhplot.io.images.ExportVGraphics;

public class GHPanel
implements ComponentListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JPanel CanvasPanel;
    protected JPanel mainPanel;
    protected GHMargin topPanel;
    protected int topSize;
    protected GHMargin leftPanel;
    protected int leftSize;
    protected GHMargin rightPanel;
    protected int rightSize;
    protected GHMargin bottomPanel;
    protected int bottomSize;
    protected Color backMargin;
    protected String gTitleText;
    protected Font gTitleFont;
    protected Color gTitleColor;
    protected int Width;
    protected int Height;
    private static final String rootKey = GHPanel.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";

    public GHPanel(int Width, int Height) {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        this.CanvasPanel = new JPanel();
        this.Width = Width;
        this.Height = Height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int Sheight = screenSize.height;
        int Swidth = screenSize.width;
        if (Swidth < this.Width || Sheight < this.Height) {
            this.Width = (int)(0.5 * (double)Swidth);
            this.Height = (int)(0.5 * (double)Sheight);
        }
        this.CanvasPanel.addComponentListener(this);
        this.CanvasPanel.setPreferredSize(new Dimension(Width, Height));
        this.CanvasPanel.setMinimumSize(new Dimension(20, 20));
        this.leftSize = (int)((double)Width * 0.025);
        this.rightSize = (int)((double)Width * 0.025);
        this.bottomSize = (int)((double)Height * 0.025);
        this.topSize = (int)((double)Height * 0.025);
        this.backMargin = Color.white;
        this.mainPanel = new JPanel();
        this.topPanel = new GHMargin(this, "Top");
        this.topPanel.setGBackground(this.backMargin);
        this.topPanel.setGRecBackground(this.backMargin);
        this.leftPanel = new GHMargin(this, "Left");
        this.leftPanel.setGBackground(this.backMargin);
        this.leftPanel.setGRecBackground(this.backMargin);
        this.rightPanel = new GHMargin(this, "Right");
        this.rightPanel.setGBackground(this.backMargin);
        this.rightPanel.setGRecBackground(this.backMargin);
        this.bottomPanel = new GHMargin(this, "Bottom");
        this.bottomPanel.setGBackground(this.backMargin);
        this.rightPanel.setGRecBackground(this.backMargin);
        this.leftPanel.setSizeMargin(this.leftSize, Height);
        this.rightPanel.setSizeMargin(this.rightSize, Height);
        this.bottomPanel.setSizeMargin(Width, this.bottomSize);
        this.topPanel.setSizeMargin(Width, this.topSize);
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.CanvasPanel.setLayout(new BorderLayout());
        this.CanvasPanel.add((Component)this.mainPanel, "Center");
        this.CanvasPanel.add((Component)this.leftPanel, "West");
        this.CanvasPanel.add((Component)this.rightPanel, "East");
        this.CanvasPanel.add((Component)this.bottomPanel, "South");
        this.CanvasPanel.add((Component)this.topPanel, "North");
        this.CanvasPanel.setBorder(BorderFactory.createEmptyBorder());
        JHPlot.init();
    }

    public void convertSVG(String source, String target) {
        ConvertSVG.SVGTo(source, target, false);
    }

    public void convertSVG(String source, String target, boolean isRemove) {
        ConvertSVG.SVGTo(source, target, isRemove);
    }

    public void addGraph(int i1, int i2, Component a) {
        this.mainPanel.add(a);
    }

    public void setMarginBackground(Color backMargin) {
        this.backMargin = backMargin;
        this.leftPanel.setGBackground(backMargin);
        this.leftPanel.setGRecBackground(backMargin);
        this.rightPanel.setGBackground(backMargin);
        this.rightPanel.setGRecBackground(backMargin);
        this.bottomPanel.setGBackground(backMargin);
        this.bottomPanel.setGRecBackground(backMargin);
        this.topPanel.setGBackground(backMargin);
        this.topPanel.setGRecBackground(backMargin);
    }

    public Color getMarginBackground() {
        return this.backMargin;
    }

    public void addComp(Component a) {
        this.mainPanel.add(a);
    }

    public int getSizeX() {
        return this.CanvasPanel.getSize().width;
    }

    public int getSizeY() {
        return this.CanvasPanel.getSize().height;
    }

    public void setGTitle(String sname, Font f, Color c) {
        this.setTextTop(sname, f, c);
        this.gTitleText = sname;
        this.gTitleFont = f;
        this.gTitleColor = c;
    }

    public void setTextTop(String sname, Font f, Color c) {
        this.topPanel.setRotation(0);
        this.topPanel.setString(sname, f, c);
        this.setMarginSizeTop(0.1);
    }

    public void setTextLeft(String sname, Font f, Color c) {
        this.leftPanel.setRotation(-90);
        this.leftPanel.setString(sname, f, c);
        this.setMarginSizeLeft(0.1);
    }

    public void setTextRight(String sname, Font f, Color c) {
        this.rightPanel.setRotation(-90);
        this.rightPanel.setString(sname, f, c);
        this.setMarginSizeRight(0.1);
    }

    public void setTextBottom(String sname, Font f, Color c) {
        this.bottomPanel.setRotation(0);
        this.bottomPanel.setString(sname, f, c);
        this.setMarginSizeBottom(0.1);
    }

    public String getTextBottom() {
        return this.bottomPanel.getString();
    }

    public Font getTextBottomFont() {
        return this.bottomPanel.getMFont();
    }

    public Color getTextBottomColor() {
        return this.bottomPanel.getMColor();
    }

    public String getTextLeft() {
        return this.leftPanel.getString();
    }

    public Font getTextLeftFont() {
        return this.leftPanel.getMFont();
    }

    public void export(String file) {
        if (this.isBorderShown()) {
            this.showBorders(false);
        }
        this.CanvasPanel.validate();
        ExportVGraphics.export(this.CanvasPanel, rootKey, file);
    }

    public Color getTextLeftColor() {
        return this.leftPanel.getMColor();
    }

    public String getTextTop() {
        return this.topPanel.getString();
    }

    public Font getTextTopFont() {
        return this.topPanel.getMFont();
    }

    public Color getTextTopColor() {
        return this.topPanel.getMColor();
    }

    public String getTextRight() {
        return this.rightPanel.getString();
    }

    public Font getTextRightFont() {
        return this.rightPanel.getMFont();
    }

    public Color getTextRightColor() {
        return this.rightPanel.getMColor();
    }

    public void setGTitle(String sname, Font f) {
        this.setTextTop(sname, f, Color.black);
    }

    public void setTextLeft(String sname, Font f) {
        this.setTextLeft(sname, f, Color.black);
    }

    public void setTextTop(String sname, Font f) {
        this.setTextTop(sname, f, Color.black);
    }

    public void setTextRight(String sname, Font f) {
        this.setTextRight(sname, f, Color.black);
    }

    public void setTextBottom(String sname, Font f) {
        this.setTextBottom(sname, f, Color.black);
    }

    public void setGTitle(String sname) {
        this.setTextTop(sname, new Font("Lucida Sans", 1, 18), Color.black);
    }

    public void setGTitle(String sname, double space) {
        this.setTextTop(sname, new Font("Lucida Sans", 1, 18), Color.black);
        this.setMarginSizeTop(space);
    }

    public void setTextLeft(String sname) {
        this.setTextLeft(sname, new Font("Lucida Sans", 1, 16), Color.black);
    }

    public void setTextLeft(String sname, double space) {
        this.setTextLeft(sname, new Font("Lucida Sans", 1, 16), Color.black);
        this.setMarginSizeLeft(space);
    }

    public void setTextRight(String sname) {
        this.setTextRight(sname, new Font("Lucida Sans", 1, 16), Color.black);
    }

    public void setTextRight(String sname, double space) {
        this.setTextRight(sname, new Font("Lucida Sans", 1, 16), Color.black);
        this.setMarginSizeRight(space);
    }

    public void setTextBottom(String sname) {
        this.setTextBottom(sname, new Font("Lucida Sans", 1, 16), Color.black);
    }

    public void setTextTop(String sname) {
        this.setTextTop(sname, new Font("Lucida Sans", 1, 16), Color.black);
    }

    public void resetMargins() {
        this.setMarginSizeLeft(0.01);
        this.setMarginSizeRight(0.01);
        this.setMarginSizeBottom(0.01);
        this.setMarginSizeTop(0.01);
        this.setTextBottom(" ");
        this.setTextLeft(" ");
        this.setTextTop(" ");
        this.setTextRight(" ");
    }

    public void setTextBottom(String sname, double space) {
        this.setTextBottom(sname, new Font("Lucida Sans", 1, 16), Color.black);
        this.setMarginSizeBottom(space);
    }

    public void setGTitle(String sname, Color c) {
        this.setGTitle(sname, new Font("Lucida Sans", 1, 20), c);
    }

    public JPanel getMarginPanelLeft() {
        return this.leftPanel;
    }

    public JPanel getMarginPanelRight() {
        return this.rightPanel;
    }

    public JPanel getMarginPanelTop() {
        return this.topPanel;
    }

    public JPanel getMarginPanelBottom() {
        return this.bottomPanel;
    }

    public JPanel getMarginPanelCenter() {
        return this.mainPanel;
    }

    public JPanel getCanvasPanel() {
        return this.CanvasPanel;
    }

    public void setTextRotationTop(int r) {
        this.topPanel.setRotation(r);
    }

    public int getTextRotationTop() {
        return this.topPanel.getRotation();
    }

    public void setTextRotationLeft(int r) {
        this.leftPanel.setRotation(r);
    }

    public int getTextRotationLeft() {
        return this.leftPanel.getRotation();
    }

    public void setTextRotationRight(int r) {
        this.rightPanel.setRotation(r);
    }

    public int getTextRotationRight() {
        return this.rightPanel.getRotation();
    }

    public void setTextRotationBottom(int r) {
        this.bottomPanel.setRotation(r);
    }

    public int getTextRotationBottom() {
        return this.bottomPanel.getRotation();
    }

    public void setTextPosTopX(double x) {
        this.topPanel.setStringPositionX(x);
    }

    public void setTextPosTopY(double y) {
        this.topPanel.setStringPositionY(y);
    }

    public double getTextPosTopX() {
        return this.topPanel.getStringPositionX();
    }

    public double getTextPosTopY() {
        return this.topPanel.getStringPositionY();
    }

    public void setTextPosLeftX(double x) {
        this.leftPanel.setStringPositionX(x);
    }

    public void setTextPosLeftY(double y) {
        this.leftPanel.setStringPositionY(y);
    }

    public double getTextPosLeftX() {
        return this.leftPanel.getStringPositionX();
    }

    public double getTextPosLeftY() {
        return this.leftPanel.getStringPositionY();
    }

    public void setTextPosRightX(double x) {
        this.rightPanel.setStringPositionX(x);
    }

    public void setTextPosRightY(double y) {
        this.rightPanel.setStringPositionY(y);
    }

    public double getTextPosRightX() {
        return this.rightPanel.getStringPositionX();
    }

    public double getTextPosRightY() {
        return this.rightPanel.getStringPositionY();
    }

    public void setTextPosBottomX(double x) {
        this.bottomPanel.setStringPositionX(x);
    }

    public void setTextPosBottomY(double y) {
        this.bottomPanel.setStringPositionY(y);
    }

    public double getTextPosBottomX() {
        return this.bottomPanel.getStringPositionX();
    }

    public double getTextPosBottomY() {
        return this.bottomPanel.getStringPositionY();
    }

    public Color getTextBottomColorBack() {
        return this.bottomPanel.getGBackground();
    }

    public void setTextBottomColorBack(Color c) {
        this.bottomPanel.setGBackground(c);
    }

    public Color getTextTopColorBack() {
        return this.topPanel.getGBackground();
    }

    public void setTextTopColorBack(Color c) {
        this.topPanel.setGBackground(c);
    }

    public Color getTextLeftColorBack() {
        return this.leftPanel.getGBackground();
    }

    public void setTextLeftColorBack(Color c) {
        this.leftPanel.setGBackground(c);
    }

    public Color getTextRightColorBack() {
        return this.rightPanel.getGBackground();
    }

    public void setTextRightColorBack(Color c) {
        this.rightPanel.setGBackground(c);
    }

    protected void disposeGHPanel() {
        this.CanvasPanel.setVisible(false);
        this.leftPanel.disposeMe();
        this.rightPanel.disposeMe();
        this.bottomPanel.disposeMe();
        this.topPanel.disposeMe();
        this.mainPanel = null;
        this.gTitleColor = null;
        this.CanvasPanel = null;
        System.gc();
    }

    public void showBorders(boolean show) {
        this.leftPanel.showBorderNoUpdate(show);
        this.topPanel.showBorderNoUpdate(show);
        this.bottomPanel.showBorderNoUpdate(show);
        this.rightPanel.showBorderNoUpdate(show);
        this.CanvasPanel.updateUI();
    }

    public boolean isBorderShown() {
        if (this.leftPanel.isBorder()) {
            return true;
        }
        if (this.rightPanel.isBorder()) {
            return true;
        }
        if (this.topPanel.isBorder()) {
            return true;
        }
        return this.rightPanel.isBorder();
    }

    public void printGraph() {
        if (this.isBorderShown()) {
            this.showBorders(false);
        }
        this.CanvasPanel.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    prnJob.setPrintable(new Printable(){

                        @Override
                        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
                            if (pageIndex == 0) {
                                Graphics2D g2d = (Graphics2D)graphics;
                                double ratioX = pageFormat.getImageableWidth() / (double)GHPanel.this.CanvasPanel.getSize().width;
                                double ratioY = pageFormat.getImageableHeight() / (double)GHPanel.this.CanvasPanel.getSize().height;
                                double factor = Math.min(ratioX, ratioY);
                                g2d.scale(factor, factor);
                                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                                GHPanel.disableDoubleBuffering(GHPanel.this.CanvasPanel);
                                GHPanel.this.CanvasPanel.print(g2d);
                                GHPanel.enableDoubleBuffering(GHPanel.this.CanvasPanel);
                                return 0;
                            }
                            return 1;
                        }
                    });
                    if (prnJob.printDialog()) {
                        JHPlot.showStatusBarText("Printing..");
                        prnJob.print();
                    }
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        this.CanvasPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setMarginSizeRight(double rightSize) {
        if (rightSize > 1.0) {
            rightSize = 1.0;
        }
        if (rightSize < 0.01) {
            rightSize = 0.01;
        }
        this.rightSize = (int)(rightSize * (double)this.getSizeX());
        this.rightPanel.setSizeMargin(this.rightSize, this.getSizeY());
        this.CanvasPanel.updateUI();
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }

    public double getMarginSizeRight() {
        return (double)this.rightPanel.getSizeX() / (double)this.getSizeX();
    }

    public void setMarginSizeLeft(double leftSize) {
        if (leftSize > 1.0) {
            leftSize = 1.0;
        }
        if (leftSize < 0.01) {
            leftSize = 0.01;
        }
        this.leftSize = (int)(leftSize * (double)this.getSizeX());
        this.leftPanel.setSizeMargin(this.leftSize, this.getSizeY());
        this.CanvasPanel.updateUI();
    }

    public double getMarginSizeLeft() {
        return (double)this.leftPanel.getSizeX() / (double)this.getSizeX();
    }

    public void setMarginSizeBottom(double bottomSize) {
        if (bottomSize > 1.0) {
            bottomSize = 1.0;
        }
        if (bottomSize < 0.01) {
            bottomSize = 0.01;
        }
        this.bottomSize = (int)(bottomSize * (double)this.getSizeY());
        this.bottomPanel.setSizeMargin(this.getSizeX(), this.bottomSize);
        this.CanvasPanel.updateUI();
    }

    public void setMarginSizeTop(double topSize) {
        if (topSize > 1.0) {
            topSize = 1.0;
        }
        if (topSize < 0.01) {
            topSize = 0.01;
        }
        this.topSize = (int)(topSize * (double)this.getSizeY());
        this.topPanel.setSizeMargin(this.getSizeX(), this.topSize);
        this.CanvasPanel.updateUI();
    }

    public double getMarginSizeBottom() {
        this.bottomSize = this.bottomPanel.getSizeY();
        return (double)this.bottomSize / (double)this.getSizeY();
    }

    public void setSizePanel(int Width, int Height) {
        this.Width = Width;
        this.Width = Height;
        this.CanvasPanel.setPreferredSize(new Dimension(Width, Height));
        this.CanvasPanel.updateUI();
    }

    public double getMarginSizeTop() {
        return (double)this.topPanel.getSizeY() / (double)this.getSizeY();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.topPanel.setDefault(e.getSource());
        this.leftPanel.setDefault();
        this.bottomPanel.setDefault();
        this.rightPanel.setDefault();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

