/*
 * Decompiled with CFR 0.152.
 */
package jhplot.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jhplot.JHPlot;
import jhplot.gui.GHPanel;
import jhplot.gui.VariableSizeGridLayout;
import jhplot.io.images.ExportVGraphics;
import jhplot.utils.AboutDialog;
import jhplot.utils.MemoryMonitor;
import jhplot.utils.Util;
import jplot.Utils;

public abstract class GHFrame
extends GHPanel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean set;
    protected JFrame mainFrame;
    private MemoryMonitor memMon;
    private JPanel infoPanel;
    protected static int N1 = 0;
    protected static int N2 = 0;
    protected int N1final;
    protected int N2final;
    protected int N1edit;
    protected int N2edit;
    protected JMenuBar bar;
    protected JMenu menu;
    protected JMenu about;
    protected JMenuItem item11;
    protected JMenuItem item00;
    protected JMenuItem item01;
    protected JMenuItem item02;
    protected JMenuItem item03;
    protected JMenuItem item04;
    protected JMenuItem item05;
    protected JMenuItem item06;
    protected JMenuItem item12;
    protected JMenuItem item13;
    protected int menusets = 0;

    public GHFrame(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        this(title, xsize, ysize, n1, n2, set, 0);
    }

    public GHFrame(String title, int xsize, int ysize, int n1, int n2, boolean set, int menusets) {
        super(xsize, ysize);
        this.menusets = menusets;
        if (n1 > 24 || n2 > 24) {
            this.N1final = 1;
            this.N2final = 1;
            xsize = 600;
            ysize = 440;
            Util.ErrorMessage("Too many plot regions given! Maximum number is 25 by 25. Set to the defalts.");
        }
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GHFrame.this.quitFrame();
            }
        });
        this.set = set;
        N1 = 0;
        N2 = 0;
        if (n1 == 0 || n2 == 0) {
            n1 = 1;
            n2 = 1;
        }
        this.N1final = n1;
        this.N2final = n2;
        this.mainFrame.setTitle(title);
        ImageIcon icone = new ImageIcon(this.getClass().getClassLoader().getResource("jhplot/images/logo_jhepwork_24x24.jpg"));
        this.mainFrame.setIconImage(icone.getImage());
        this.mainPanel.setLayout(new VariableSizeGridLayout(this.N2final, this.N1final, 0, 0));
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.setBorder(new EtchedBorder());
        this.infoPanel.add((Component)JHPlot.statusbar, "West");
        this.memMon = new MemoryMonitor();
        this.memMon.setPreferredSize(new Dimension(100, 14));
        this.memMon.setMinimumSize(new Dimension(80, 10));
        this.infoPanel.add((Component)this.memMon, "East");
        this.mainFrame.add((Component)this.CanvasPanel, "Center");
        this.mainFrame.add((Component)this.infoPanel, "South");
        this.bar = new JMenuBar();
        this.menu = new JMenu("File");
        this.about = new JMenu("Help");
        this.item02 = new JMenuItem(new PrintAction());
        this.item01 = new JMenuItem(new ExportAction());
        this.item00 = new JMenuItem(new ExitAction());
        this.item03 = new JMenuItem(new SaveAction());
        this.item04 = new JMenuItem(new ReadAction());
        this.item05 = new JMenuItem(new ClearAction());
        this.item06 = new JMenuItem(new RefreshAction());
        this.item13 = new JMenuItem(new ReadDataAction());
        if (menusets == 0) {
            this.menu.add(this.item01);
            this.menu.add(this.item02);
            this.menu.add(this.item03);
            this.menu.add(this.item04);
            this.menu.add(this.item13);
            this.menu.add(this.item05);
            this.menu.add(this.item06);
            this.menu.insertSeparator(6);
            this.menu.add(this.item00);
        }
        if (menusets == 1) {
            this.menu.add(this.item01);
            this.menu.add(this.item02);
            this.menu.insertSeparator(6);
            this.menu.add(this.item00);
        }
        this.bar.add(this.menu);
        this.item11 = new JMenuItem(new ShowAboutAction());
        this.about.add(this.item11);
        this.item12 = new JMenuItem(new ShowHelpAction());
        this.about.add(this.item12);
        this.bar.add(this.about);
        this.mainFrame.setJMenuBar(this.bar);
        this.mainFrame.pack();
    }

    public GHFrame(String title, int n1, int n2) {
        this(title, n1, n2, 1, 1, true);
    }

    public GHFrame(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public GHFrame(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
    }

    public GHFrame(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public GHFrame() {
        this("Default", 600, 400, 1, 1, true);
    }

    @Override
    public void addGraph(int i1, int i2, Component a) {
        this.addComp(a);
    }

    public void cd(int cols, int rows) {
        N1 = cols - 1;
        N2 = rows - 1;
        if (cols > this.N1final || rows > this.N2final) {
            this.errorMessage("Wrong number of canvas in cd() method\n  ");
            N1 = 0;
            N2 = 0;
            return;
        }
    }

    public int getCdX() {
        return N1;
    }

    public void setPlotsNum(int nx, int ny) {
        this.N1final = nx;
        this.N2final = ny;
        this.mainPanel.setLayout(new GridLayout(this.N2final, this.N1final, 0, 0));
        this.CanvasPanel.updateUI();
    }

    public void updateFrame() {
        this.CanvasPanel.repaint();
        this.CanvasPanel.updateUI();
        this.mainFrame.repaint();
    }

    public int getNtotX() {
        return this.N1final;
    }

    public int getNtotY() {
        return this.N2final;
    }

    public int getCdY() {
        return N2;
    }

    protected void doNotShowFrame() {
        this.mainFrame.setVisible(false);
    }

    protected void removeFrame() {
        this.item00 = null;
        this.item11 = null;
        this.item01 = null;
        this.item02 = null;
        this.item03 = null;
        this.menu = null;
        this.about = null;
        this.memMon = null;
        this.infoPanel = null;
        this.disposeGHPanel();
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        System.gc();
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public URL getHTMLUrl(String name) {
        URL url = null;
        try {
            url = this.getClass().getResource("/html/" + name);
        }
        catch (Exception e) {
            Utils.oops(this.mainFrame, "Impossible to load the About content.\nSomething's wrong with the installation.");
        }
        return url;
    }

    protected void showAbout() {
        new AboutDialog((Component)this.mainFrame);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    protected void exportImage() {
        if (this.isBorderShown()) {
            this.showBorders(false);
        }
        JHPlot.showStatusBarText("Export to an image file");
        ExportVGraphics.exportDialog(this.CanvasPanel, GHFrame.class.getName(), this.mainFrame);
    }

    protected abstract void openWriteDialog();

    protected abstract void openReadDialog();

    protected abstract void openReadDataDialog();

    protected abstract void clearFrame();

    protected abstract void refreshFrame();

    protected abstract void showHelp();

    protected abstract void quitFrame();

    private void errorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    private class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PrintAction() {
            super("Print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.printGraph();
        }
    }

    protected class ExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExportAction() {
            super("Export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.exportImage();
        }
    }

    protected class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.quitFrame();
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        SaveAction() {
            super("Save as");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.openWriteDialog();
        }
    }

    private class ReadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ReadAction() {
            super("Open graph");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.openReadDialog();
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ClearAction() {
            super("Clear frame");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.clearFrame();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
            super("Refresh frame");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.refreshFrame();
        }
    }

    private class ReadDataAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ReadDataAction() {
            super("Open data file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.openReadDataDialog();
        }
    }

    private class ShowAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowAboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.showAbout();
        }
    }

    private class ShowHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowHelpAction() {
            super("Help");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GHFrame.this.showHelp();
        }
    }
}

