/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jhplot.JHPlot;
import jhplot.gui.CommonGUI;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.Export;
import jhplot.io.images.ExportVGraphics;
import jhplot.io.images.ImageType;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;

public class HPlotChart {
    private static final long serialVersionUID = 1L;
    private int xsize;
    private int ysize;
    private JFrame frame;
    private static final String rootKey = HPlotChart.class.getName();
    private final Color DEFAULT_BG_COLOR = Color.white;
    private Thread1 m_Close;
    private JFreeChart chart;
    private ChartPanel cp;

    public HPlotChart(JFreeChart jchart, int xsize, int ysize) {
        this.xsize = xsize;
        this.ysize = ysize;
        this.frame = new JFrame("HPloatChart");
        this.chart = jchart;
        this.cp = new ChartPanel(this.chart);
        this.cp.setPreferredSize(new Dimension(xsize, ysize));
        this.cp.setBackground(this.DEFAULT_BG_COLOR);
        this.cp.setLayout(new BorderLayout());
        this.cp.setDomainZoomable(true);
        this.cp.setRangeZoomable(true);
        this.chart.setAntiAlias(true);
        this.chart.setBorderPaint(this.DEFAULT_BG_COLOR);
        this.chart.setBackgroundPaint(this.DEFAULT_BG_COLOR);
        this.chart.setBorderVisible(false);
        Plot pp = this.chart.getPlot();
        pp.setBackgroundPaint(this.DEFAULT_BG_COLOR);
        this.setTheme("LEGACY_THEME");
        this.frame.add(this.cp);
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item1 = new JMenuItem("Export");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPlotChart.this.exportDialog();
            }
        });
        JMenuItem item2 = new JMenuItem("Close");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HPlotChart.this.close();
            }
        });
        this.frame.setDefaultCloseOperation(2);
        menu.add(item1);
        menu.add(item2);
        bar.add(menu);
        this.frame.setJMenuBar(bar);
        this.frame.setPreferredSize(new Dimension(xsize, ysize));
    }

    public void visible(boolean vs) {
        if (vs) {
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public void visible() {
        this.visible(true);
    }

    public HPlotChart(JFreeChart jchart) {
        this(jchart, 600, 400);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void close() {
        this.frame.setVisible(false);
        this.chart = null;
        this.cp = null;
        this.frame.dispose();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ChartPanel getPanel() {
        return this.cp;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setTheme(String s) {
        if (s.equals("LEGACY_THEME")) {
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());
            ChartUtilities.applyCurrentTheme(this.chart);
        } else if (s.equals("JFREE_THEME")) {
            ChartFactory.setChartTheme(StandardChartTheme.createJFreeTheme());
            ChartUtilities.applyCurrentTheme(this.chart);
        } else if (s.equals("DARKNESS_THEME")) {
            ChartFactory.setChartTheme(StandardChartTheme.createDarknessTheme());
            ChartUtilities.applyCurrentTheme(this.chart);
        }
    }

    public void destroy() {
        this.close();
    }

    public void export(String filename) {
        int calculatedWidth = this.xsize;
        int calculatedHeight = this.ysize;
        if (calculatedWidth <= 0) {
            calculatedWidth = 600;
        }
        if (calculatedHeight <= 0) {
            calculatedHeight = 400;
        }
        this.export(filename, calculatedWidth, calculatedHeight);
    }

    protected void exportImage() {
        JFrame jm = this.getFrame();
        JFileChooser fileChooser = CommonGUI.openImageFileChooser(jm);
        if (fileChooser.showDialog(jm, "Save As") == 0) {
            int res;
            final File scriptFile = fileChooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(jm, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            JHPlot.showStatusBarText(mess);
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HPlotChart.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    public void export(String filename, int width, int height) {
        block21: {
            String fname = filename;
            String filetype = "pdf";
            int i = filename.lastIndexOf(46);
            if (i > 0) {
                filetype = fname.substring(i + 1);
            }
            try {
                if (filetype.equalsIgnoreCase("png")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "png", new File(fname));
                    break block21;
                }
                if (filetype.equalsIgnoreCase("jpg") || filetype.equalsIgnoreCase("jpeg")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "jpg", new File(fname));
                    break block21;
                }
                if (filetype.equalsIgnoreCase("ps")) {
                    try {
                        ImageType currentImageType = ImageType.PS;
                        java.awt.Rectangle r = new java.awt.Rectangle(0, 0, width, height);
                        Export.exportComponent(this.cp, r, new File(filename), currentImageType);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (TranscoderException e) {
                        e.printStackTrace();
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("eps")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        EpsGraphics2D g = new EpsGraphics2D("HChart canvas", outputStream, 0, 0, width, height);
                        this.drawToGraphics2D(g, width, height);
                        g.flush();
                        g.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Problem writing eps");
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("pdf")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        DefaultFontMapper mapper = new DefaultFontMapper();
                        Rectangle pagesize = new Rectangle((float)width, (float)height);
                        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
                        try {
                            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
                            document.open();
                            PdfContentByte cb = writer.getDirectContent();
                            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                            Graphics2D g = tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
                            this.drawToGraphics2D(g, width, height);
                            g.dispose();
                            cb.addTemplate(tp, 0.0f, 0.0f);
                        }
                        catch (DocumentException de) {
                            System.err.println(de.getMessage());
                        }
                        document.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Cannot find itext library, cannot create pdf.");
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("svg")) {
                    try {
                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                        org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
                        svgGenerator.getGeneratorContext().setPrecision(6);
                        this.drawToGraphics2D((Graphics2D)svgGenerator, width, height);
                        boolean useCSS = true;
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename)), "UTF-8");
                        svgGenerator.stream((Writer)out, useCSS);
                        ((Writer)out).close();
                    }
                    catch (DOMException e) {
                        System.err.println("Problem writing to SVG");
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Missing Batik libraries?");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void drawToGraphics2D(Graphics2D g, int width, int height) {
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        int cols = 1;
        int rows = 1;
        int boxWidth = width / cols;
        int boxHeight = height / rows;
        int currentChartIndex = 0;
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int i1 = 0; i1 < cols; ++i1) {
                ++currentChartIndex;
                if (this.chart == null) continue;
                int rowsUsed = 1;
                boolean colsUsed = true;
                int chartX = boxWidth * i1;
                int chartY = boxHeight * i2;
                int chartwidth = boxWidth;
                int chartheight = boxHeight;
                chartwidth = boxWidth * rowsUsed;
                chartheight = boxHeight;
                this.chart.plotChanged(new PlotChangeEvent(this.chart.getPlot()));
                ChartRenderingInfo info = new ChartRenderingInfo();
                this.chart.draw(g, new java.awt.Rectangle(chartX -= (rowsUsed - 1) * boxWidth, chartY, chartwidth, chartheight), new Point(chartX, chartY), info);
            }
        }
    }

    private void exportDialog() {
        JFileChooser fc = CommonGUI.openImageFileChooser(this.frame);
        if (fc.showDialog(this.frame, "Export to ") == 0) {
            int res;
            final File scriptFile = ExportVGraphics.getSelectedFileWithExtension(fc);
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this.frame, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HPlotChart.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HPlotChart.this.close();
        }
    }
}

