/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import javax.swing.JOptionPane;
import jhplot.DrawOptions;
import jhplot.FProxy;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class FND
extends DrawOptions {
    private FProxy proxy;
    final int maxpoints = 200;
    private static final long serialVersionUID = 1L;
    private double[] x = null;
    private double[] y = null;
    private boolean isEvaluated = false;
    private XJep jep = null;
    private Node node = null;
    private Node processed = null;
    private Node simp = null;
    private String[] avars = null;
    private Node diff = null;
    private String fixedVars = "";

    public FND(String title, String name, String vars) {
        this.title = title;
        this.proxy = new FProxy(3, title, name, null, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 200, true);
        name = this.proxy.getName();
        this.proxy.setVariables(vars);
        this.setTitle(title);
        this.lpp.setType(102);
        this.jep = new XJep();
        this.jep.addStandardConstants();
        this.jep.addStandardFunctions();
        this.jep.setAllowUndeclared(true);
        this.jep.setImplicitMul(true);
        this.jep.setAllowAssignment(true);
        this.avars = vars.split(",");
        for (int i = 0; i < this.avars.length; ++i) {
            this.jep.addVariable(this.avars[i].trim(), 0.0);
        }
        this.jep.addVariable("x", 0.0);
        try {
            this.node = this.jep.parse(name);
            this.processed = this.jep.preprocess(this.node);
        }
        catch (ParseException i) {
        }
        catch (Exception e) {
            this.ErrorMessage("Error in parsing " + name);
        }
    }

    public FND(String name, String vars) {
        this(name, name, vars);
    }

    public FND(FProxy f) {
        this.proxy = f;
        String name = this.proxy.getName();
        if (this.proxy.getType() != 4) {
            this.ErrorMessage("Error in parsing FND. Wrong type! " + name);
            return;
        }
        this.setTitle(this.proxy.getTitle());
        this.lpp.setType(102);
        this.jep = new XJep();
        this.jep.addStandardConstants();
        this.jep.addStandardFunctions();
        this.jep.setAllowUndeclared(true);
        this.jep.setImplicitMul(true);
        this.jep.setAllowAssignment(true);
        String vars = this.proxy.getVariables();
        this.avars = vars.split(",");
        for (int i = 0; i < this.avars.length; ++i) {
            this.jep.addVariable(this.avars[i].trim(), 0.0);
        }
        this.jep.addVariable("x", 0.0);
        try {
            this.node = this.jep.parse(name);
            this.processed = this.jep.preprocess(this.node);
        }
        catch (ParseException i) {
        }
        catch (Exception e) {
            this.ErrorMessage("Error in parsing " + name);
        }
    }

    public void setComplex() {
        this.jep.addComplex();
    }

    public void simplify() {
        String name = this.proxy.getName();
        try {
            this.simp = this.jep.simplify(this.processed);
        }
        catch (ParseException parseException) {
        }
        catch (Exception e) {
            this.ErrorMessage("Error in simplification of " + name);
        }
    }

    public void diff(String var) {
        String name = this.proxy.getName();
        DJep j = new DJep();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setAllowAssignment(true);
        j.setImplicitMul(true);
        j.addStandardDiffRules();
        try {
            this.node = j.parse(name);
            this.diff = j.differentiate(this.node, var);
            this.simp = j.simplify(this.diff);
        }
        catch (ParseException e) {
            this.ErrorMessage("Error in parsing " + name);
        }
    }

    public String[] getVars() {
        return this.avars;
    }

    public String toString() {
        if (this.simp != null) {
            return this.jep.toString(this.simp);
        }
        return this.jep.toString(this.node);
    }

    public double eval(String vars) {
        String[] tmp = vars.split(",");
        for (int i = 0; i < tmp.length; ++i) {
            String[] vv = tmp[i].split("=");
            if (vv.length != 2) {
                this.ErrorMessage("Error in parsing list of input variablse. Did you use val=number? ");
            }
            try {
                double d = Double.valueOf(vv[1].trim());
                this.jep.addVariable(vv[0].trim(), d);
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException: " + nfe.getMessage());
            }
        }
        try {
            Object result = this.jep.evaluate(this.node);
            if (result instanceof Double) {
                return (Double)this.jep.evaluate(this.node);
            }
        }
        catch (ParseException e) {
            return 0.0;
        }
        return 0.0;
    }

    public boolean eval(String indvars, double xmin, double xmax, String vars) {
        String name = this.proxy.getName();
        int points = this.proxy.getPoints();
        boolean suc = true;
        String[] tmp = vars.split(",");
        this.fixedVars = vars;
        for (int i = 0; i < tmp.length; ++i) {
            String[] vv = tmp[i].split("=");
            if (vv.length != 2) {
                this.ErrorMessage("Error in parsing list of input variablse. Did you use val=number? ");
            }
            try {
                double d = Double.valueOf(vv[1].trim());
                this.jep.addVariable(vv[0].trim(), d);
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("NumberFormatException: " + nfe.getMessage());
                suc = false;
            }
        }
        double min = xmin;
        double max = xmax;
        this.x = new double[points];
        this.y = new double[points];
        for (int i = 0; i < points; ++i) {
            this.x[i] = min + (double)i * (max - min) / (double)(points - 1);
            this.jep.addVariable(indvars.trim(), this.x[i]);
            try {
                Object result = this.jep.evaluate(this.node);
                if (!(result instanceof Double)) continue;
                this.y[i] = (Double)this.jep.evaluate(this.node);
                continue;
            }
            catch (ParseException e) {
                Util.ErrorMessage("Failed to parse function " + name + " Error:" + e.toString());
                suc = false;
            }
        }
        if (suc) {
            this.isEvaluated = true;
        }
        return suc;
    }

    public boolean eval(String indvars, double xmin, double xmax) {
        boolean suc = true;
        String name = this.proxy.getName();
        int points = this.proxy.getPoints();
        double min = xmin;
        double max = xmax;
        this.x = new double[points];
        this.y = new double[points];
        for (int i = 0; i < points; ++i) {
            this.x[i] = min + (double)i * (max - min) / (double)(points - 1);
            this.jep.addVariable(indvars.trim(), this.x[i]);
            try {
                Object result = this.jep.evaluate(this.node);
                if (!(result instanceof Double)) continue;
                this.y[i] = (Double)this.jep.evaluate(this.node);
                continue;
            }
            catch (ParseException e) {
                Util.ErrorMessage("Failed to parse function " + name + " Error:" + e.toString());
                suc = false;
            }
        }
        if (suc) {
            this.isEvaluated = true;
        }
        return suc;
    }

    public boolean isEvaluated() {
        return this.isEvaluated;
    }

    public double getX(int i) {
        return this.x[i];
    }

    public double getY(int i) {
        return this.y[i];
    }

    public void setName(String name) {
        this.proxy.setName(name);
    }

    public FProxy get() {
        return this.proxy;
    }

    public String getName() {
        return this.proxy.getName();
    }

    public String getVarString() {
        return this.proxy.getVariables();
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void setMin(double min) {
        this.proxy.setLimit(0, min);
    }

    public double getMin() {
        double[] d = this.proxy.getLimits();
        return d[0];
    }

    public void setMax(double max) {
        this.proxy.setLimit(1, max);
    }

    public double getMax() {
        double[] d = this.proxy.getLimits();
        return d[1];
    }

    public void setPoints(int bins) {
        this.proxy.setPoints(bins);
    }

    public int getPoints() {
        return this.proxy.getPoints();
    }

    public String getFixedVars() {
        return this.fixedVars;
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }
}

