/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;
import smile.clustering.CLARANS;
import smile.clustering.KMeans;
import smile.data.Attribute;
import smile.math.Math;
import smile.math.distance.Metric;
import smile.math.rbf.GaussianRadialBasis;
import smile.sort.QuickSort;

public class SmileUtils {
    private SmileUtils() {
    }

    public static int[][] sort(Attribute[] attributes, double[][] x) {
        int n = x.length;
        int p = x[0].length;
        double[] a = new double[n];
        int[][] index = new int[p][];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].getType() != Attribute.Type.NUMERIC) continue;
            for (int i = 0; i < n; ++i) {
                a[i] = x[i][j];
            }
            index[j] = QuickSort.sort(a);
        }
        return index;
    }

    public static GaussianRadialBasis learnGaussianRadialBasis(double[][] x, double[][] centers) {
        int k = centers.length;
        KMeans kmeans = new KMeans(x, k, 10);
        System.arraycopy(kmeans.centroids(), 0, centers, 0, k);
        double r0 = 0.0;
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = Math.distance(centers[i], centers[j]);
                if (!(r0 < d)) continue;
                r0 = d;
            }
        }
        return new GaussianRadialBasis(r0 /= Math.sqrt(2 * k));
    }

    public static GaussianRadialBasis[] learnGaussianRadialBasis(double[][] x, double[][] centers, int p) {
        if (p < 1) {
            throw new IllegalArgumentException("Invalid number of nearest neighbors: " + p);
        }
        int k = centers.length;
        KMeans kmeans = new KMeans(x, k, 10);
        System.arraycopy(kmeans.centroids(), 0, centers, 0, k);
        p = Math.min(p, k - 1);
        double[] r = new double[k];
        GaussianRadialBasis[] rbf = new GaussianRadialBasis[k];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                r[j] = Math.distance(centers[i], centers[j]);
            }
            Arrays.sort(r);
            double r0 = 0.0;
            for (int j = 1; j <= p; ++j) {
                r0 += r[j];
            }
            rbf[i] = new GaussianRadialBasis(r0 /= (double)p);
        }
        return rbf;
    }

    public static GaussianRadialBasis[] learnGaussianRadialBasis(double[][] x, double[][] centers, double r) {
        if (r <= 0.0) {
            throw new IllegalArgumentException("Invalid scaling parameter: " + r);
        }
        int k = centers.length;
        KMeans kmeans = new KMeans(x, k, 10);
        System.arraycopy(kmeans.centroids(), 0, centers, 0, k);
        int n = x.length;
        int[] y = kmeans.getClusterLabel();
        double[] sigma = new double[k];
        for (int i = 0; i < n; ++i) {
            int n2 = y[i];
            sigma[n2] = sigma[n2] + Math.squaredDistance(x[i], centers[y[i]]);
        }
        int[] ni = kmeans.getClusterSize();
        GaussianRadialBasis[] rbf = new GaussianRadialBasis[k];
        for (int i = 0; i < k; ++i) {
            if (ni[i] >= 5 || sigma[i] != 0.0) {
                sigma[i] = Math.sqrt(sigma[i] / (double)ni[i]);
            } else {
                sigma[i] = Double.POSITIVE_INFINITY;
                for (int j = 0; j < k; ++j) {
                    double d;
                    if (i == j || !((d = Math.distance(centers[i], centers[j])) < sigma[i])) continue;
                    sigma[i] = d;
                }
                int n3 = i;
                sigma[n3] = sigma[n3] / 2.0;
            }
            rbf[i] = new GaussianRadialBasis(r * sigma[i]);
        }
        return rbf;
    }

    public static <T> GaussianRadialBasis learnGaussianRadialBasis(T[] x, T[] centers, Metric<T> distance) {
        int k = centers.length;
        CLARANS<T> clarans = new CLARANS<T>(x, distance, k, Math.min(100, (int)Math.round(0.01 * (double)k * (double)(x.length - k))));
        System.arraycopy(clarans.medoids(), 0, centers, 0, k);
        double r0 = 0.0;
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = distance.d(centers[i], centers[j]);
                if (!(r0 < d)) continue;
                r0 = d;
            }
        }
        return new GaussianRadialBasis(r0 /= Math.sqrt(2 * k));
    }

    public static <T> GaussianRadialBasis[] learnGaussianRadialBasis(T[] x, T[] centers, Metric<T> distance, int p) {
        if (p < 1) {
            throw new IllegalArgumentException("Invalid number of nearest neighbors: " + p);
        }
        int k = centers.length;
        CLARANS<T> clarans = new CLARANS<T>(x, distance, k, Math.min(100, (int)Math.round(0.01 * (double)k * (double)(x.length - k))));
        System.arraycopy(clarans.medoids(), 0, centers, 0, k);
        p = Math.min(p, k - 1);
        double[] r = new double[k];
        GaussianRadialBasis[] rbf = new GaussianRadialBasis[k];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                r[j] = distance.d(centers[i], centers[j]);
            }
            Arrays.sort(r);
            double r0 = 0.0;
            for (int j = 1; j <= p; ++j) {
                r0 += r[j];
            }
            rbf[i] = new GaussianRadialBasis(r0 /= (double)p);
        }
        return rbf;
    }

    public static <T> GaussianRadialBasis[] learnGaussianRadialBasis(T[] x, T[] centers, Metric<T> distance, double r) {
        if (r <= 0.0) {
            throw new IllegalArgumentException("Invalid scaling parameter: " + r);
        }
        int k = centers.length;
        CLARANS<T> clarans = new CLARANS<T>(x, distance, k, Math.min(100, (int)Math.round(0.01 * (double)k * (double)(x.length - k))));
        System.arraycopy(clarans.medoids(), 0, centers, 0, k);
        int n = x.length;
        int[] y = clarans.getClusterLabel();
        double[] sigma = new double[k];
        for (int i = 0; i < n; ++i) {
            int n2 = y[i];
            sigma[n2] = sigma[n2] + Math.sqr(distance.d(x[i], centers[y[i]]));
        }
        int[] ni = clarans.getClusterSize();
        GaussianRadialBasis[] rbf = new GaussianRadialBasis[k];
        for (int i = 0; i < k; ++i) {
            if (ni[i] >= 5 || sigma[i] == 0.0) {
                sigma[i] = Math.sqrt(sigma[i] / (double)ni[i]);
            } else {
                sigma[i] = Double.POSITIVE_INFINITY;
                for (int j = 0; j < k; ++j) {
                    double d;
                    if (i == j || !((d = distance.d(centers[i], centers[j])) < sigma[i])) continue;
                    sigma[i] = d;
                }
                int n3 = i;
                sigma[n3] = sigma[n3] / 2.0;
            }
            rbf[i] = new GaussianRadialBasis(r * sigma[i]);
        }
        return rbf;
    }
}

