/*
 * Decompiled with CFR 0.152.
 */
package smile.swing;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Printer {
    private static final Logger logger = LoggerFactory.getLogger(Printer.class);
    private PrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
    private PrinterJob printer = PrinterJob.getPrinterJob();
    private static Printer singleton = null;

    private Printer() {
    }

    public static Printer getPrinter() {
        if (singleton == null) {
            singleton = new Printer();
        }
        return singleton;
    }

    public void print(Printable painter) {
        this.printer.setPrintable(painter);
        if (this.printer.printDialog(this.printAttributes)) {
            try {
                this.printer.print(this.printAttributes);
            }
            catch (PrinterException ex) {
                logger.error("Failed to print", ex);
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        }
    }
}

