/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.projection.GHA;

public class GHATest {
    double[][] USArrests = new double[][]{{13.2, 236.0, 58.0, 21.2}, {10.0, 263.0, 48.0, 44.5}, {8.1, 294.0, 80.0, 31.0}, {8.8, 190.0, 50.0, 19.5}, {9.0, 276.0, 91.0, 40.6}, {7.9, 204.0, 78.0, 38.7}, {3.3, 110.0, 77.0, 11.1}, {5.9, 238.0, 72.0, 15.8}, {15.4, 335.0, 80.0, 31.9}, {17.4, 211.0, 60.0, 25.8}, {5.3, 46.0, 83.0, 20.2}, {2.6, 120.0, 54.0, 14.2}, {10.4, 249.0, 83.0, 24.0}, {7.2, 113.0, 65.0, 21.0}, {2.2, 56.0, 57.0, 11.3}, {6.0, 115.0, 66.0, 18.0}, {9.7, 109.0, 52.0, 16.3}, {15.4, 249.0, 66.0, 22.2}, {2.1, 83.0, 51.0, 7.8}, {11.3, 300.0, 67.0, 27.8}, {4.4, 149.0, 85.0, 16.3}, {12.1, 255.0, 74.0, 35.1}, {2.7, 72.0, 66.0, 14.9}, {16.1, 259.0, 44.0, 17.1}, {9.0, 178.0, 70.0, 28.2}, {6.0, 109.0, 53.0, 16.4}, {4.3, 102.0, 62.0, 16.5}, {12.2, 252.0, 81.0, 46.0}, {2.1, 57.0, 56.0, 9.5}, {7.4, 159.0, 89.0, 18.8}, {11.4, 285.0, 70.0, 32.1}, {11.1, 254.0, 86.0, 26.1}, {13.0, 337.0, 45.0, 16.1}, {0.8, 45.0, 44.0, 7.3}, {7.3, 120.0, 75.0, 21.4}, {6.6, 151.0, 68.0, 20.0}, {4.9, 159.0, 67.0, 29.3}, {6.3, 106.0, 72.0, 14.9}, {3.4, 174.0, 87.0, 8.3}, {14.4, 279.0, 48.0, 22.5}, {3.8, 86.0, 45.0, 12.8}, {13.2, 188.0, 59.0, 26.9}, {12.7, 201.0, 80.0, 25.5}, {3.2, 120.0, 80.0, 22.9}, {2.2, 48.0, 32.0, 11.2}, {8.5, 156.0, 63.0, 20.7}, {4.0, 145.0, 73.0, 26.2}, {5.7, 81.0, 39.0, 9.3}, {2.6, 53.0, 66.0, 10.8}, {6.8, 161.0, 60.0, 15.6}};
    double[][] loadings = new double[][]{{-0.0417043206282872, -0.0448216562696701, -0.0798906594208108, -0.994921731246978}, {-0.995221281426497, -0.058760027857223, 0.0675697350838043, 0.0389382976351601}, {-0.0463357461197108, 0.97685747990989, 0.200546287353866, -0.0581691430589319}, {-0.075155500585547, 0.200718066450337, -0.974080592182491, 0.0723250196376097}};
    double[] eigenvalues = new double[]{7011.114851, 201.992366, 42.112651, 6.164246};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        int i;
        int i2;
        System.out.println("learn");
        int k = 3;
        double[] mu = Math.colMeans(this.USArrests);
        DenseMatrix cov = Matrix.newInstance(Math.cov(this.USArrests));
        for (int i3 = 0; i3 < this.USArrests.length; ++i3) {
            Math.minus(this.USArrests[i3], mu);
        }
        double r = 1.0E-5;
        GHA gha = new GHA(4, k, r);
        int t = 0;
        for (int iter = 1; iter <= 1000; ++iter) {
            double error = 0.0;
            i2 = 0;
            while (i2 < this.USArrests.length) {
                error += gha.learn(this.USArrests[i2]);
                ++i2;
                ++t;
            }
            error /= (double)this.USArrests.length;
            if (iter % 100 != 0) continue;
            System.out.format("Iter %3d, Error = %.5g%n", iter, error);
        }
        DenseMatrix p = gha.getProjection();
        DenseMatrix t2 = p.ata();
        for (int i4 = 0; i4 < t2.nrows(); ++i4) {
            for (int j = 0; j < t2.ncols(); ++j) {
                System.out.format("% .4f ", t2.get(i4, j));
            }
            System.out.println();
        }
        DenseMatrix s = (DenseMatrix)((DenseMatrix)p.abmm(cov)).abtmm(p);
        double[] ev = new double[k];
        System.out.println("Relative error of eigenvalues:");
        for (i2 = 0; i2 < k; ++i2) {
            ev[i2] = Math.abs(this.eigenvalues[i2] - s.get(i2, i2)) / this.eigenvalues[i2];
            System.out.format("%.4f ", ev[i2]);
        }
        System.out.println();
        for (i2 = 0; i2 < k; ++i2) {
            Assert.assertTrue(ev[i2] < 0.1);
        }
        double[][] lt = Math.transpose(this.loadings);
        double[] evdot = new double[k];
        double[][] pa = p.array();
        System.out.println("Dot products of learned eigenvectors to true eigenvectors:");
        for (i = 0; i < k; ++i) {
            evdot[i] = Math.dot(lt[i], pa[i]);
            System.out.format("%.4f ", evdot[i]);
        }
        System.out.println();
        for (i = 0; i < k; ++i) {
            Assert.assertTrue(Math.abs(1.0 - Math.abs(evdot[i])) < 0.1);
        }
    }
}

