/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class StaircasePlot
extends Plot {
    private double[][] data;

    public StaircasePlot(double[][] data) {
        this.data = data;
    }

    public StaircasePlot(double[][] data, Color color) {
        super(color);
        this.data = data;
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        Color c = g.getColor();
        g.setColor(this.getColor());
        double[] begin = new double[this.data[0].length];
        double[] end = new double[this.data[0].length];
        for (i = 0; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[0].length; ++j) {
                begin[j] = this.data[i][j];
                end[j] = this.data[i + 1][j];
            }
            end[end.length - 1] = this.data[i][end.length - 1];
            g.drawLine(begin, end);
        }
        for (i = 1; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[0].length; ++j) {
                begin[j] = this.data[i][j];
                end[j] = this.data[i][j];
            }
            begin[end.length - 1] = this.data[i - 1][end.length - 1];
            g.drawLine(begin, end);
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[] ... data) {
        return StaircasePlot.plot(null, data);
    }

    public static PlotCanvas plot(String id, double[] ... data) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        StaircasePlot plot = new StaircasePlot(data);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }
}

