/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smile.math.Math;
import smile.plot.Axis;
import smile.plot.Base;
import smile.plot.BaseGrid;
import smile.plot.Graphics;
import smile.plot.Grid;
import smile.plot.Histogram;
import smile.plot.Label;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.Plot;
import smile.plot.Point;
import smile.plot.Projection2D;
import smile.plot.Projection3D;
import smile.plot.ScatterPlot;
import smile.plot.Shape;
import smile.plot.StaircasePlot;
import smile.projection.PCA;
import smile.swing.Button;
import smile.swing.FileChooser;
import smile.swing.Printer;
import smile.swing.Table;

public class PlotCanvas
extends JPanel {
    private static final double DEFAULT_MARGIN = 0.15;
    private static final Font DEFAULT_TITLE_FONT = new Font("Arial", 1, 16);
    private static final Color DEFAULT_TITLE_COLOR = Color.BLACK;
    Base base;
    Graphics graphics;
    double margin = 0.15;
    private String title;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private Color titleColor = DEFAULT_TITLE_COLOR;
    private Base backupBase;
    private BaseGrid baseGrid;
    private List<Shape> shapes = new ArrayList<Shape>();
    private MathCanvas canvas;
    private JToolBar toolbar;
    private JPopupMenu popup;
    private JTable propertyTable;
    private transient Action saveAction = new SaveAction();
    private transient Action printAction = new PrintAction();
    private transient Action zoomInAction = new ZoomInAction();
    private transient Action zoomOutAction = new ZoomOutAction();
    private transient Action resetAction = new ResetAction();
    private transient Action enlargePlotAreaAction = new EnlargePlotAreaAction();
    private transient Action shrinkPlotAreaAction = new ShrinkPlotAreaAction();
    private transient Action propertyAction = new PropertyAction();
    private transient Action increaseHeightAction = new IncreaseHeightAction();
    private transient Action increaseWidthAction = new IncreaseWidthAction();
    private transient Action decreaseHeightAction = new DecreaseHeightAction();
    private transient Action decreaseWidthAction = new DecreaseWidthAction();
    private JScrollPane scrollPane;

    public PlotCanvas(double[] lowerBound, double[] upperBound) {
        this.initCanvas();
        this.initBase(lowerBound, upperBound);
        this.initGraphics();
    }

    public PlotCanvas(double[] lowerBound, double[] upperBound, boolean extendBound) {
        this.initCanvas();
        this.initBase(lowerBound, upperBound, extendBound);
        this.initGraphics();
    }

    public PlotCanvas(double[] lowerBound, double[] upperBound, String[] axisLabels) {
        this.initCanvas();
        this.initBase(lowerBound, upperBound, axisLabels);
        this.initGraphics();
    }

    public PlotCanvas(double[] lowerBound, double[] upperBound, String[] axisLabels, boolean extendBound) {
        this.initCanvas();
        this.initBase(lowerBound, upperBound, axisLabels, extendBound);
        this.initGraphics();
    }

    public JComponent getToolbar() {
        return this.toolbar;
    }

    private void initCanvas() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.isHeadless()) {
            this.setPreferredSize(new Dimension(1600, 1200));
        }
        this.setLayout(new BorderLayout());
        this.canvas = new MathCanvas();
        this.add((Component)this.canvas, "Center");
        this.initContextMenauAndToolBar();
    }

    private void initContextMenauAndToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.add(new Button(this.saveAction));
        this.toolbar.add(new Button(this.printAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.zoomInAction));
        this.toolbar.add(new Button(this.zoomOutAction));
        this.toolbar.add(new Button(this.resetAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.enlargePlotAreaAction));
        this.toolbar.add(new Button(this.shrinkPlotAreaAction));
        this.toolbar.add(new Button(this.increaseHeightAction));
        this.toolbar.add(new Button(this.decreaseHeightAction));
        this.toolbar.add(new Button(this.increaseWidthAction));
        this.toolbar.add(new Button(this.decreaseWidthAction));
        this.toolbar.addSeparator();
        this.toolbar.add(new Button(this.propertyAction));
        this.decreaseHeightAction.setEnabled(false);
        this.decreaseWidthAction.setEnabled(false);
        this.popup = new JPopupMenu();
        this.popup.add(new JMenuItem(this.saveAction));
        this.popup.add(new JMenuItem(this.printAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.zoomInAction));
        this.popup.add(new JMenuItem(this.zoomOutAction));
        this.popup.add(new JMenuItem(this.resetAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.enlargePlotAreaAction));
        this.popup.add(new JMenuItem(this.shrinkPlotAreaAction));
        this.popup.add(new JMenuItem(this.increaseHeightAction));
        this.popup.add(new JMenuItem(this.decreaseHeightAction));
        this.popup.add(new JMenuItem(this.increaseWidthAction));
        this.popup.add(new JMenuItem(this.decreaseWidthAction));
        this.popup.addSeparator();
        this.popup.add(new JMenuItem(this.propertyAction));
        AncestorListener ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                boolean inScrollPane = false;
                for (Container parent = PlotCanvas.this.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof JScrollPane)) continue;
                    inScrollPane = true;
                    PlotCanvas.this.scrollPane = (JScrollPane)parent;
                    break;
                }
                PlotCanvas.this.increaseHeightAction.setEnabled(inScrollPane);
                PlotCanvas.this.increaseWidthAction.setEnabled(inScrollPane);
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        };
        this.addAncestorListener(ancestorListener);
    }

    private JDialog createPropertyDialog() {
        Object[][] data;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        JDialog dialog = new JDialog(frame, "Plot Properties", true);
        PropertyDialogOKAction okAction = new PropertyDialogOKAction(dialog);
        PropertyDialogCancelAction cancelAction = new PropertyDialogCancelAction(dialog);
        JButton okButton = new JButton(okAction);
        JButton cancelButton = new JButton(cancelAction);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(4));
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(25, 0, 10, 10));
        ActionMap actionMap = buttonsPanel.getActionMap();
        actionMap.put(cancelAction.getValue("Default"), cancelAction);
        actionMap.put(okAction.getValue("Default"), okAction);
        InputMap inputMap = buttonsPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), cancelAction.getValue("Default"));
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), okAction.getValue("Default"));
        Object[] columnNames = new String[]{"Property", "Value"};
        if (this.base.dimension == 2) {
            data = new Object[][]{{"Title", this.title}, {"Title Font", this.titleFont}, {"Title Color", this.titleColor}, {"X Axis Title", this.getAxis(0).getAxisLabel()}, {"X Axis Range", new double[]{this.base.getLowerBounds()[0], this.base.getUpperBounds()[0]}}, {"Y Axis Title", this.getAxis(1).getAxisLabel()}, {"Y Axis Range", new double[]{this.base.getLowerBounds()[1], this.base.getUpperBounds()[1]}}};
            this.propertyTable = new Table(data, columnNames);
        } else {
            data = new Object[][]{{"Title", this.title}, {"Title Font", this.titleFont}, {"Title Color", this.titleColor}, {"X Axis Title", this.getAxis(0).getAxisLabel()}, {"X Axis Range", new double[]{this.base.getLowerBounds()[0], this.base.getUpperBounds()[0]}}, {"Y Axis Title", this.getAxis(1).getAxisLabel()}, {"Y Axis Range", new double[]{this.base.getLowerBounds()[1], this.base.getUpperBounds()[1]}}, {"Z Axis Title", this.getAxis(2).getAxisLabel()}, {"Z Axis Range", new double[]{this.base.getLowerBounds()[2], this.base.getUpperBounds()[2]}}};
            this.propertyTable = new Table(data, columnNames);
        }
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertyTable.setFillsViewportHeight(true);
        JScrollPane tablePanel = new JScrollPane(this.propertyTable);
        dialog.getContentPane().add((Component)tablePanel, "Center");
        dialog.getContentPane().add((Component)buttonsPanel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        return dialog;
    }

    public void save() throws IOException {
        FileChooser.SimpleFileFilter filter = FileChooser.SimpleFileFilter.getWritableImageFIlter();
        FileChooser chooser = FileChooser.getInstance();
        chooser.setFileFilter(filter);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setSelectedFiles(new File[0]);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (!filter.accept(file)) {
                file = new File(file.getParentFile(), file.getName() + ".png");
            }
            this.save(file);
        }
    }

    public void save(File file) throws IOException {
        BufferedImage bi = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        this.canvas.print(g2d);
        ImageIO.write((RenderedImage)bi, FileChooser.getExtension(file), file);
    }

    public void print() {
        Printer.getPrinter().print(this.canvas);
    }

    public void zoom(boolean inout) {
        int i = 0;
        while (i < this.base.dimension) {
            int s = this.baseGrid.getAxis(i).getLinearSlices();
            double r = inout ? -1.0 / (double)s : 1.0 / (double)s;
            double d = (this.base.upperBound[i] - this.base.lowerBound[i]) * r;
            int n = i;
            this.base.lowerBound[n] = this.base.lowerBound[n] - d;
            int n2 = i++;
            this.base.upperBound[n2] = this.base.upperBound[n2] + d;
        }
        for (i = 0; i < this.base.dimension; ++i) {
            this.base.setPrecisionUnit(i);
        }
        this.base.initBaseCoord();
        this.graphics.projection.reset();
        this.baseGrid.setBase(this.base);
        this.canvas.repaint();
    }

    public void reset() {
        this.base.reset();
        this.graphics.projection.reset();
        this.baseGrid.setBase(this.base);
        if (this.graphics.projection instanceof Projection3D) {
            ((Projection3D)this.graphics.projection).setDefaultView();
        }
        this.canvas.repaint();
    }

    private void initGraphics() {
        this.graphics = this.base.dimension == 2 ? new Graphics(new Projection2D(this)) : new Graphics(new Projection3D(this));
    }

    private void initBase(double[] lowerBound, double[] upperBound) {
        this.backupBase = this.base = new Base(lowerBound, upperBound);
        this.baseGrid = new BaseGrid(this.base);
    }

    private void initBase(double[] lowerBound, double[] upperBound, boolean extendBound) {
        this.backupBase = this.base = new Base(lowerBound, upperBound, extendBound);
        this.baseGrid = new BaseGrid(this.base);
    }

    private void initBase(double[] lowerBound, double[] upperBound, String[] axisLabels) {
        this.backupBase = this.base = new Base(lowerBound, upperBound);
        this.baseGrid = new BaseGrid(this.base, axisLabels);
    }

    private void initBase(double[] lowerBound, double[] upperBound, String[] axisLabels, boolean extendBound) {
        this.backupBase = this.base = new Base(lowerBound, upperBound, extendBound);
        this.baseGrid = new BaseGrid(this.base, axisLabels);
    }

    public double getMargin() {
        return this.margin;
    }

    public PlotCanvas setMargin(double margin) {
        if (margin < 0.0 || margin >= 0.3) {
            throw new IllegalArgumentException("Invalid margin: " + margin);
        }
        this.margin = margin;
        this.repaint();
        return this;
    }

    public Base getBase() {
        return this.base;
    }

    public String getTitle() {
        return this.title;
    }

    public PlotCanvas setTitle(String title) {
        this.title = title;
        this.repaint();
        return this;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public PlotCanvas setTitleFont(Font font) {
        this.titleFont = font;
        this.repaint();
        return this;
    }

    public PlotCanvas setTitleColor(Color color) {
        this.titleColor = color;
        this.repaint();
        return this;
    }

    public Axis getAxis(int i) {
        return this.baseGrid.getAxis(i);
    }

    public String[] getAxisLabels() {
        String[] labels = new String[this.base.dimension];
        for (int i = 0; i < this.base.dimension; ++i) {
            labels[i] = this.baseGrid.getAxis(i).getAxisLabel();
        }
        return labels;
    }

    public String getAxisLabel(int axis) {
        return this.baseGrid.getAxis(axis).getAxisLabel();
    }

    public PlotCanvas setAxisLabels(String ... labels) {
        this.baseGrid.setAxisLabel(labels);
        this.repaint();
        return this;
    }

    public PlotCanvas setAxisLabel(int axis, String label) {
        this.baseGrid.setAxisLabel(axis, label);
        this.repaint();
        return this;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public void add(Shape p) {
        this.shapes.add(p);
        this.repaint();
    }

    public void remove(Shape p) {
        this.shapes.remove(p);
        this.repaint();
    }

    public void add(Plot p) {
        this.shapes.add(p);
        JComponent[] tb = p.getToolBar();
        if (tb != null) {
            this.toolbar.addSeparator();
            for (JComponent comp : tb) {
                this.toolbar.add(comp);
            }
        }
        this.repaint();
    }

    public void remove(Plot p) {
        this.shapes.remove(p);
        JComponent[] tb = p.getToolBar();
        if (tb != null) {
            for (JComponent comp : tb) {
                this.toolbar.remove(comp);
            }
        }
        this.repaint();
    }

    public void clear() {
        this.shapes.clear();
        this.repaint();
    }

    public double[] getLowerBounds() {
        return this.base.lowerBound;
    }

    public double[] getUpperBounds() {
        return this.base.upperBound;
    }

    public void extendLowerBound(double[] bound) {
        this.base.extendLowerBound(bound);
        this.baseGrid.setBase(this.base);
        this.repaint();
    }

    public void extendUpperBound(double[] bound) {
        this.base.extendUpperBound(bound);
        this.baseGrid.setBase(this.base);
        this.repaint();
    }

    public void extendBound(double[] lowerBound, double[] upperBound) {
        this.base.extendBound(lowerBound, upperBound);
        this.baseGrid.setBase(this.base);
        this.repaint();
    }

    public void label(String text, double ... coord) {
        this.add(new Label(text, coord));
    }

    public void label(String text, Font font, double ... coord) {
        Label label = new Label(text, coord);
        label.setFont(font);
        this.add(label);
    }

    public void label(String text, Color color, double ... coord) {
        Label label = new Label(text, coord);
        label.setColor(color);
        this.add(label);
    }

    public void label(String text, Font font, Color color, double ... coord) {
        Label label = new Label(text, coord);
        label.setFont(font);
        label.setColor(color);
        this.add(label);
    }

    public void point(double ... coord) {
        this.add(new Point(coord));
    }

    public void point(char legend, double ... coord) {
        this.add(new Point(legend, coord));
    }

    public void point(Color color, double ... coord) {
        this.add(new Point(color, coord));
    }

    public void point(char legend, Color color, double ... coord) {
        this.add(new Point(legend, color, coord));
    }

    public ScatterPlot points(double[] ... data) {
        return this.points((String)null, data);
    }

    public ScatterPlot points(String id, double[] ... data) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public ScatterPlot points(double[][] data, String[] labels) {
        return this.points(null, data, labels);
    }

    public ScatterPlot points(String id, double[][] data, String[] labels) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        if (data.length != labels.length) {
            throw new IllegalArgumentException("The number of points and that of labels are not same.");
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, labels);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public ScatterPlot points(double[][] data, char legend) {
        return this.points(null, data, legend);
    }

    public ScatterPlot points(String id, double[][] data, char legend) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, legend);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public ScatterPlot points(double[][] data, Color color) {
        return this.points(null, data, color);
    }

    public ScatterPlot points(String id, double[][] data, Color color) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public ScatterPlot points(double[][] data, char legend, Color color) {
        return this.points(null, data, legend, color);
    }

    public ScatterPlot points(String id, double[][] data, char legend, Color color) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, legend);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[] y) {
        return this.line((String)null, y);
    }

    public LinePlot line(String id, double[] y) {
        double[] lowerBound = new double[]{0.0, Math.min(y)};
        double[] upperBound = new double[]{y.length, Math.max(y)};
        this.extendBound(lowerBound, upperBound);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[] y, Color color) {
        return this.line(null, y, color);
    }

    public LinePlot line(String id, double[] y, Color color) {
        double[] lowerBound = new double[]{0.0, Math.min(y)};
        double[] upperBound = new double[]{y.length, Math.max(y)};
        this.extendBound(lowerBound, upperBound);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[] y, Line.Style style) {
        return this.line(null, y, style);
    }

    public LinePlot line(String id, double[] y, Line.Style style) {
        double[] lowerBound = new double[]{0.0, Math.min(y)};
        double[] upperBound = new double[]{y.length, Math.max(y)};
        this.extendBound(lowerBound, upperBound);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[] y, Line.Style style, Color color) {
        return this.line(null, y, style, color);
    }

    public LinePlot line(String id, double[] y, Line.Style style, Color color) {
        double[] lowerBound = new double[]{0.0, Math.min(y)};
        double[] upperBound = new double[]{y.length, Math.max(y)};
        this.extendBound(lowerBound, upperBound);
        double[][] data = new double[y.length][2];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[] ... data) {
        return this.line((String)null, data);
    }

    public LinePlot line(String id, double[] ... data) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[][] data, Color color) {
        return this.line(null, data, color);
    }

    public LinePlot line(String id, double[][] data, Color color) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[][] data, Line.Style style) {
        return this.line(null, data, style);
    }

    public LinePlot line(String id, double[][] data, Line.Style style) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        this.add(plot);
        return plot;
    }

    public LinePlot line(double[][] data, Line.Style style, Color color) {
        return this.line(null, data, style, color);
    }

    public LinePlot line(String id, double[][] data, Line.Style style, Color color) {
        if (data[0].length != this.base.dimension) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        this.extendBound(lowerBound, upperBound);
        LinePlot plot = new LinePlot(data, style);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public StaircasePlot staircase(double[][] data, Color color) {
        return this.staircase(null, data, color);
    }

    public StaircasePlot staircase(String id, double[][] data, Color color) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        StaircasePlot plot = new StaircasePlot(data);
        plot.setID(id);
        plot.setColor(color);
        this.add(plot);
        return plot;
    }

    public Histogram histogram(double[] data, Color color) {
        return this.histogram((String)null, data, color);
    }

    public Histogram histogram(String id, double[] data, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{Math.min(data), 0.0};
        double[] upperBound = new double[]{Math.max(data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Histogram histogram(double[] data, int k, Color color) {
        return this.histogram(null, data, k, color);
    }

    public Histogram histogram(String id, double[] data, int k, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data, k);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{Math.min(data), 0.0};
        double[] upperBound = new double[]{Math.max(data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Histogram histogram(double[] data, double[] breaks, Color color) {
        return this.histogram(null, data, breaks, color);
    }

    public Histogram histogram(String id, double[] data, double[] breaks, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data, breaks);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{Math.min(data), 0.0};
        double[] upperBound = new double[]{Math.max(data), 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Histogram histogram(int[] data, Color color) {
        return this.histogram((String)null, data, color);
    }

    public Histogram histogram(String id, int[] data, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{(double)Math.min(data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max(data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Histogram histogram(int[] data, int k, Color color) {
        return this.histogram((String)null, data, k, color);
    }

    public Histogram histogram(String id, int[] data, int k, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data, k);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{(double)Math.min(data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max(data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Histogram histogram(int[] data, double[] breaks, Color color) {
        return this.histogram((String)null, data, breaks, color);
    }

    public Histogram histogram(String id, int[] data, double[] breaks, Color color) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Histogram can be only painted in a 2D canvas.");
        }
        Histogram histogram = new Histogram(data, breaks);
        histogram.setID(id);
        histogram.setColor(color);
        double[] lowerBound = new double[]{(double)Math.min(data) - 0.5, 0.0};
        double[] upperBound = new double[]{(double)Math.max(data) + 0.5, 0.0};
        double[][] freq = histogram.getHistogram();
        for (int i = 0; i < freq.length; ++i) {
            if (!(freq[i][1] > upperBound[1])) continue;
            upperBound[1] = freq[i][1];
        }
        this.extendBound(lowerBound, upperBound);
        this.add(histogram);
        return histogram;
    }

    public Grid grid(double[][][] data) {
        if (this.base.dimension != 2) {
            throw new IllegalArgumentException("Grid can be only painted in a 2D canvas. Try surface() for 3D grid.");
        }
        Grid grid = new Grid(data);
        this.add(grid);
        return grid;
    }

    public static PlotCanvas screeplot(PCA pca) {
        int n = pca.getVarianceProportion().length;
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{n + 1, 1.0};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.setAxisLabels("Principal Component", "Proportion of Variance");
        String[] labels = new String[n];
        double[] x = new double[n];
        double[][] data = new double[n][2];
        double[][] data2 = new double[n][2];
        for (int i = 0; i < n; ++i) {
            labels[i] = "PC" + (i + 1);
            x[i] = i + 1;
            data[i][0] = x[i];
            data[i][1] = pca.getVarianceProportion()[i];
            data2[i][0] = x[i];
            data2[i][1] = pca.getCumulativeVarianceProportion()[i];
        }
        LinePlot plot = new LinePlot(data);
        plot.setID("Variance");
        plot.setColor(Color.RED);
        plot.setLegend('@');
        canvas.add(plot);
        canvas.getAxis(0).addLabel(labels, x);
        LinePlot plot2 = new LinePlot(data2);
        plot2.setID("Cumulative Variance");
        plot2.setColor(Color.BLUE);
        plot2.setLegend('@');
        canvas.add(plot2);
        return canvas;
    }

    private class PropertyDialogCancelAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "Cancel";
        private JDialog dialog;

        protected PropertyDialogCancelAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(false);
        }
    }

    private class PropertyDialogOKAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "OK";
        private JDialog dialog;

        protected PropertyDialogOKAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotCanvas.this.setTitle((String)PlotCanvas.this.propertyTable.getValueAt(0, 1));
            PlotCanvas.this.setTitleFont((Font)PlotCanvas.this.propertyTable.getValueAt(1, 1));
            PlotCanvas.this.setTitleColor((Color)PlotCanvas.this.propertyTable.getValueAt(2, 1));
            PlotCanvas.this.getAxis(0).setAxisLabel((String)PlotCanvas.this.propertyTable.getValueAt(3, 1));
            double[] xbound = (double[])PlotCanvas.this.propertyTable.getValueAt(4, 1);
            PlotCanvas.this.base.lowerBound[0] = xbound[0];
            PlotCanvas.this.base.upperBound[0] = xbound[1];
            PlotCanvas.this.getAxis(1).setAxisLabel((String)PlotCanvas.this.propertyTable.getValueAt(5, 1));
            double[] ybound = (double[])PlotCanvas.this.propertyTable.getValueAt(6, 1);
            PlotCanvas.this.base.lowerBound[1] = ybound[0];
            PlotCanvas.this.base.upperBound[1] = ybound[1];
            if (PlotCanvas.this.base.dimension > 2) {
                PlotCanvas.this.getAxis(2).setAxisLabel((String)PlotCanvas.this.propertyTable.getValueAt(7, 1));
                double[] zbound = (double[])PlotCanvas.this.propertyTable.getValueAt(8, 1);
                PlotCanvas.this.base.lowerBound[2] = zbound[0];
                PlotCanvas.this.base.upperBound[2] = zbound[1];
            }
            for (int i = 0; i < PlotCanvas.this.base.dimension; ++i) {
                PlotCanvas.this.base.setPrecisionUnit(i);
            }
            PlotCanvas.this.base.initBaseCoord();
            PlotCanvas.this.graphics.projection.reset();
            PlotCanvas.this.baseGrid.setBase(PlotCanvas.this.base);
            this.dialog.setVisible(false);
            PlotCanvas.this.canvas.repaint();
        }
    }

    private class PropertyAction
    extends AbstractAction {
        public PropertyAction() {
            super("Properties", new ImageIcon(PlotCanvas.class.getResource("images/property16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = PlotCanvas.this.createPropertyDialog();
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
            dialog = null;
        }
    }

    private class DecreaseHeightAction
    extends AbstractAction {
        public DecreaseHeightAction() {
            super("Decrease Height", new ImageIcon(PlotCanvas.class.getResource("images/decrease-height16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotCanvas.this.getSize();
            d.height -= 100;
            Dimension vd = PlotCanvas.this.scrollPane.getViewport().getSize();
            if (d.height <= vd.height) {
                d.height = vd.height;
                PlotCanvas.this.decreaseHeightAction.setEnabled(false);
            }
            PlotCanvas.this.setPreferredSize(d);
            PlotCanvas.this.invalidate();
            PlotCanvas.this.scrollPane.getParent().validate();
        }
    }

    private class DecreaseWidthAction
    extends AbstractAction {
        public DecreaseWidthAction() {
            super("Decrease Width", new ImageIcon(PlotCanvas.class.getResource("images/decrease-width16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotCanvas.this.getSize();
            d.width -= 100;
            Dimension vd = PlotCanvas.this.scrollPane.getViewport().getSize();
            if (d.width <= vd.width) {
                d.width = vd.width;
                PlotCanvas.this.decreaseWidthAction.setEnabled(false);
            }
            PlotCanvas.this.setPreferredSize(d);
            PlotCanvas.this.invalidate();
            PlotCanvas.this.scrollPane.getParent().validate();
        }
    }

    private class IncreaseHeightAction
    extends AbstractAction {
        public IncreaseHeightAction() {
            super("Increase Height", new ImageIcon(PlotCanvas.class.getResource("images/increase-height16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotCanvas.this.getSize();
            d.height += 100;
            PlotCanvas.this.setPreferredSize(d);
            PlotCanvas.this.invalidate();
            PlotCanvas.this.scrollPane.getParent().validate();
            if (!PlotCanvas.this.decreaseHeightAction.isEnabled()) {
                PlotCanvas.this.decreaseHeightAction.setEnabled(true);
            }
        }
    }

    private class IncreaseWidthAction
    extends AbstractAction {
        public IncreaseWidthAction() {
            super("Increase Width", new ImageIcon(PlotCanvas.class.getResource("images/increase-width16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = PlotCanvas.this.getSize();
            d.width += 100;
            PlotCanvas.this.setPreferredSize(d);
            PlotCanvas.this.invalidate();
            PlotCanvas.this.scrollPane.getParent().validate();
            if (!PlotCanvas.this.decreaseWidthAction.isEnabled()) {
                PlotCanvas.this.decreaseWidthAction.setEnabled(true);
            }
        }
    }

    private class ShrinkPlotAreaAction
    extends AbstractAction {
        public ShrinkPlotAreaAction() {
            super("Shrink", new ImageIcon(PlotCanvas.class.getResource("images/resize-smaller16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PlotCanvas.this.margin < 0.3) {
                PlotCanvas.this.margin += 0.05;
                PlotCanvas.this.graphics.projection.reset();
                PlotCanvas.this.repaint();
            }
            if (PlotCanvas.this.margin >= 0.3) {
                this.setEnabled(false);
            }
            if (!PlotCanvas.this.enlargePlotAreaAction.isEnabled()) {
                PlotCanvas.this.enlargePlotAreaAction.setEnabled(true);
            }
        }
    }

    private class EnlargePlotAreaAction
    extends AbstractAction {
        public EnlargePlotAreaAction() {
            super("Enlarge", new ImageIcon(PlotCanvas.class.getResource("images/resize-larger16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PlotCanvas.this.margin > 0.05) {
                PlotCanvas.this.margin -= 0.05;
                PlotCanvas.this.graphics.projection.reset();
                PlotCanvas.this.repaint();
            }
            if (PlotCanvas.this.margin <= 0.05) {
                this.setEnabled(false);
            }
            if (!PlotCanvas.this.shrinkPlotAreaAction.isEnabled()) {
                PlotCanvas.this.shrinkPlotAreaAction.setEnabled(true);
            }
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset", new ImageIcon(PlotCanvas.class.getResource("images/refresh16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotCanvas.this.reset();
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction() {
            super("Zoom Out", new ImageIcon(PlotCanvas.class.getResource("images/zoom-out16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotCanvas.this.zoom(false);
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        public ZoomInAction() {
            super("Zoom In", new ImageIcon(PlotCanvas.class.getResource("images/zoom-in16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotCanvas.this.zoom(true);
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super("Print", new ImageIcon(PlotCanvas.class.getResource("images/print16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlotCanvas.this.print();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save", new ImageIcon(PlotCanvas.class.getResource("images/save16.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PlotCanvas.this.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        }
    }

    private class MathCanvas
    extends JComponent
    implements Printable,
    ComponentListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    ActionListener {
        private boolean mouseDoubleClicked = false;
        private int mouseClickX = -1;
        private int mouseClickY = -1;
        private int mouseDraggingX = -1;
        private int mouseDraggingY = -1;

        MathCanvas() {
            this.init();
        }

        private void init() {
            this.setBackground(Color.white);
            this.setDoubleBuffered(true);
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paintComponent(java.awt.Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            PlotCanvas.this.graphics.setGraphics(g2d);
            Color color = g2d.getColor();
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g2d.setColor(color);
            PlotCanvas.this.baseGrid.paint(PlotCanvas.this.graphics);
            PlotCanvas.this.graphics.clip();
            int k = 0;
            for (int i = 0; i < PlotCanvas.this.shapes.size(); ++i) {
                Plot p;
                Shape s = (Shape)PlotCanvas.this.shapes.get(i);
                s.paint(PlotCanvas.this.graphics);
                if (!(s instanceof Plot) || (p = (Plot)s).getID() == null) continue;
                ++k;
            }
            PlotCanvas.this.graphics.clearClip();
            if (k > 1) {
                Font font = g2d.getFont();
                int x = (int)((double)this.getWidth() * (1.0 - PlotCanvas.this.margin) + 20.0);
                int y = (int)((double)this.getHeight() * PlotCanvas.this.margin + 50.0);
                int width = font.getSize();
                int height = font.getSize();
                for (int i = 0; i < PlotCanvas.this.shapes.size(); ++i) {
                    Plot p;
                    Shape s = (Shape)PlotCanvas.this.shapes.get(i);
                    if (!(s instanceof Plot) || (p = (Plot)s).getID() == null) continue;
                    g2d.setColor(p.getColor());
                    g2d.fillRect(x, y, width, height);
                    g2d.drawRect(x, y, width, height);
                    g2d.drawString(p.getID(), x + 2 * width, y + height);
                    y += 2 * width;
                }
            }
            if (PlotCanvas.this.title != null) {
                g2d.setFont(PlotCanvas.this.titleFont);
                g2d.setColor(PlotCanvas.this.titleColor);
                FontMetrics fm = g.getFontMetrics();
                int x = (this.getWidth() - fm.stringWidth(PlotCanvas.this.title)) / 2;
                int y = (int)((double)this.getHeight() * PlotCanvas.this.margin) / 2;
                g2d.drawString(PlotCanvas.this.title, x, y);
            }
            if (this.mouseDraggingX >= 0 && this.mouseDraggingY >= 0) {
                g.drawRect(Math.min(this.mouseClickX, this.mouseDraggingX), Math.min(this.mouseClickY, this.mouseDraggingY), Math.abs(this.mouseClickX - this.mouseDraggingX), Math.abs(this.mouseClickY - this.mouseDraggingY));
            }
            g2d.setColor(color);
        }

        @Override
        public int print(java.awt.Graphics g, PageFormat pf, int page) throws PrinterException {
            if (page > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            double scaleX = pf.getImageableWidth() / (double)PlotCanvas.this.canvas.getWidth();
            double scaleY = pf.getImageableHeight() / (double)PlotCanvas.this.canvas.getHeight();
            g2d.scale(scaleX, scaleY);
            PlotCanvas.this.canvas.setDoubleBuffered(false);
            PlotCanvas.this.canvas.print(g);
            PlotCanvas.this.canvas.setDoubleBuffered(true);
            return 0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PlotCanvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            } else {
                this.mouseClickX = e.getX();
                this.mouseClickY = e.getY();
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (PlotCanvas.this.base.dimension == 2) {
                this.mouseDraggingX = e.getX();
                this.mouseDraggingY = e.getY();
                this.repaint();
            } else if (PlotCanvas.this.base.dimension == 3) {
                PlotCanvas.this.graphics.rotate(e.getX() - this.mouseClickX, e.getY() - this.mouseClickY);
                this.mouseClickX = e.getX();
                this.mouseClickY = e.getY();
                this.repaint();
            }
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PlotCanvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
            } else if (this.mouseDraggingX != -1 && this.mouseDraggingY != -1) {
                double[] sc2;
                double[] sc1;
                this.mouseDraggingX = -1;
                this.mouseDraggingY = -1;
                if (PlotCanvas.this.base.dimension == 2 && Math.abs(e.getX() - this.mouseClickX) > 20 && Math.abs(e.getY() - this.mouseClickY) > 20 && Math.min((sc1 = ((Projection2D)PlotCanvas.this.graphics.projection).inverseProjection(this.mouseClickX, this.mouseClickY))[0], (sc2 = ((Projection2D)PlotCanvas.this.graphics.projection).inverseProjection(e.getX(), e.getY()))[0]) < PlotCanvas.this.base.upperBound[0] && Math.max(sc1[0], sc2[0]) > PlotCanvas.this.base.lowerBound[0] && Math.min(sc1[1], sc2[1]) < PlotCanvas.this.base.upperBound[1] && Math.max(sc1[1], sc2[1]) > PlotCanvas.this.base.lowerBound[1]) {
                    PlotCanvas.this.base.lowerBound[0] = Math.max(PlotCanvas.this.base.lowerBound[0], Math.min(sc1[0], sc2[0]));
                    PlotCanvas.this.base.upperBound[0] = Math.min(PlotCanvas.this.base.upperBound[0], Math.max(sc1[0], sc2[0]));
                    PlotCanvas.this.base.lowerBound[1] = Math.max(PlotCanvas.this.base.lowerBound[1], Math.min(sc1[1], sc2[1]));
                    PlotCanvas.this.base.upperBound[1] = Math.min(PlotCanvas.this.base.upperBound[1], Math.max(sc1[1], sc2[1]));
                    for (int i = 0; i < PlotCanvas.this.base.dimension; ++i) {
                        PlotCanvas.this.base.setPrecisionUnit(i);
                    }
                    PlotCanvas.this.base.initBaseCoord();
                    PlotCanvas.this.graphics.projection.reset();
                    PlotCanvas.this.baseGrid.setBase(PlotCanvas.this.base);
                }
                this.repaint();
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.mouseDoubleClicked = true;
                PlotCanvas.this.backupBase = PlotCanvas.this.base;
            } else {
                this.mouseDoubleClicked = false;
            }
            this.mouseClickX = e.getX();
            this.mouseClickY = e.getY();
            e.consume();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PlotCanvas.this.base.dimension == 2) {
                if (this.mouseDoubleClicked) {
                    double y;
                    double x = this.mouseClickX - e.getX();
                    if (Math.abs(x) > 20.0) {
                        int s = PlotCanvas.this.baseGrid.getAxis(0).getLinearSlices();
                        x = x > 0.0 ? 1.0 / (double)s : -1.0 / (double)s;
                        PlotCanvas.this.base.lowerBound[0] = ((PlotCanvas)PlotCanvas.this).backupBase.lowerBound[0] + (x *= ((PlotCanvas)PlotCanvas.this).backupBase.upperBound[0] - ((PlotCanvas)PlotCanvas.this).backupBase.lowerBound[0]);
                        PlotCanvas.this.base.upperBound[0] = ((PlotCanvas)PlotCanvas.this).backupBase.upperBound[0] + x;
                        this.mouseClickX = e.getX();
                    }
                    if (Math.abs(y = (double)(this.mouseClickY - e.getY())) > 20.0) {
                        int s = PlotCanvas.this.baseGrid.getAxis(1).getLinearSlices();
                        y = y > 0.0 ? -1.0 / (double)s : 1.0 / (double)s;
                        PlotCanvas.this.base.lowerBound[1] = ((PlotCanvas)PlotCanvas.this).backupBase.lowerBound[1] + (y *= ((PlotCanvas)PlotCanvas.this).backupBase.upperBound[1] - ((PlotCanvas)PlotCanvas.this).backupBase.lowerBound[1]);
                        PlotCanvas.this.base.upperBound[1] = ((PlotCanvas)PlotCanvas.this).backupBase.upperBound[1] + y;
                        this.mouseClickY = e.getY();
                    }
                    PlotCanvas.this.base.initBaseCoord();
                    PlotCanvas.this.graphics.projection.reset();
                    PlotCanvas.this.baseGrid.setBase(PlotCanvas.this.base);
                    this.repaint();
                } else {
                    String tooltip = null;
                    double[] sc = ((Projection2D)PlotCanvas.this.graphics.projection).inverseProjection(e.getX(), e.getY());
                    String firstid = null;
                    for (Shape shape : PlotCanvas.this.shapes) {
                        String id;
                        Plot plot;
                        String s;
                        if (!(shape instanceof Plot) || (s = (plot = (Plot)shape).getToolTip(sc)) == null) continue;
                        if (tooltip == null) {
                            tooltip = s;
                            firstid = plot.getID();
                            continue;
                        }
                        if (firstid != null) {
                            tooltip = "<b>" + firstid + ":</b><br>" + tooltip;
                            firstid = null;
                        }
                        if ((id = plot.getID()) != null) {
                            tooltip = tooltip + "<br><b>" + id + ":</b><br>" + s;
                            continue;
                        }
                        tooltip = tooltip + "<br>----------<br>" + s;
                    }
                    if (tooltip != null) {
                        this.setToolTipText(String.format("<html>%s</html>", tooltip));
                    } else {
                        this.setToolTipText(null);
                    }
                }
            }
            e.consume();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int i;
            if (e.getWheelRotation() == 0) {
                return;
            }
            for (i = 0; i < PlotCanvas.this.base.dimension; ++i) {
                double r;
                int s = PlotCanvas.this.baseGrid.getAxis(i).getLinearSlices();
                double d = r = e.getWheelRotation() > 0 ? 1.0 / (double)s : -1.0 / (double)s;
                if (!(r > -0.5)) continue;
                double d2 = (PlotCanvas.this.base.upperBound[i] - PlotCanvas.this.base.lowerBound[i]) * r;
                int n = i;
                PlotCanvas.this.base.lowerBound[n] = PlotCanvas.this.base.lowerBound[n] - d2;
                int n2 = i;
                PlotCanvas.this.base.upperBound[n2] = PlotCanvas.this.base.upperBound[n2] + d2;
            }
            for (i = 0; i < PlotCanvas.this.base.dimension; ++i) {
                PlotCanvas.this.base.setPrecisionUnit(i);
            }
            PlotCanvas.this.base.initBaseCoord();
            PlotCanvas.this.graphics.projection.reset();
            PlotCanvas.this.baseGrid.setBase(PlotCanvas.this.base);
            this.repaint();
            e.consume();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (PlotCanvas.this.graphics != null) {
                PlotCanvas.this.base.initBaseCoord();
                PlotCanvas.this.graphics.projection.reset();
                PlotCanvas.this.baseGrid.setBase(PlotCanvas.this.base);
            }
            this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

