/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.relevance;

import smile.nlp.Corpus;
import smile.nlp.TextTerms;
import smile.nlp.relevance.RelevanceRanker;

public class TFIDF
implements RelevanceRanker {
    private double a = 0.4;

    public TFIDF() {
        this(0.4);
    }

    public TFIDF(double smoothing) {
        this.a = smoothing;
    }

    public double rank(int tf, int maxtf, long N, long n) {
        if (tf == 0) {
            return 0.0;
        }
        return (this.a + (1.0 - this.a) * (double)tf / (double)maxtf) * Math.log((double)N / (double)n);
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String term, int tf, int n) {
        if (tf == 0) {
            return 0.0;
        }
        int N = corpus.getNumDocuments();
        int maxtf = doc.maxtf();
        return this.rank(tf, maxtf, N, n);
    }

    @Override
    public double rank(Corpus corpus, TextTerms doc, String[] terms, int[] tf, int n) {
        int N = corpus.getNumDocuments();
        int maxtf = doc.maxtf();
        double r = 0.0;
        for (int i = 0; i < terms.length; ++i) {
            r += this.rank(tf[i], maxtf, N, n);
        }
        return r;
    }
}

