/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import smile.nlp.dictionary.Dictionary;

public class SimpleDictionary
implements Dictionary {
    private HashSet<String> dict = new HashSet();

    public SimpleDictionary(String resource) {
        File file = new File(resource);
        try (BufferedReader input = file.exists() ? new BufferedReader(new FileReader(resource)) : new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource)));){
            String line = null;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.matches("^[A-Z]$")) continue;
                this.dict.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean contains(String word) {
        return this.dict.contains(word);
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.dict.iterator();
    }
}

