/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.collocation;

public class BigramCollocation
implements Comparable<BigramCollocation> {
    private String w1;
    private String w2;
    private int frequency;
    private double score;

    public BigramCollocation(String w1, String w2, int frequency, double score) {
        this.w1 = w1;
        this.w2 = w2;
        this.frequency = frequency;
        this.score = score;
    }

    public String w1() {
        return this.w1;
    }

    public String w2() {
        return this.w2;
    }

    public int frequency() {
        return this.frequency;
    }

    public double score() {
        return this.score;
    }

    public String toString() {
        return String.format("(%s %s, %d, %.2f)", this.w1, this.w2, this.frequency, this.score);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.w1.hashCode();
        hash = 37 * hash + this.w2.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigramCollocation other = (BigramCollocation)obj;
        if (this.w1 == null ? other.w1 != null : !this.w1.equals(other.w1)) {
            return false;
        }
        return !(this.w2 == null ? other.w2 != null : !this.w2.equals(other.w2));
    }

    @Override
    public int compareTo(BigramCollocation o) {
        return (int)Math.signum(this.score - o.score);
    }
}

