/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.KDTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

public class KDTreeTest {
    double[][] data = new double[10000][];
    KDTree<double[]> kdtree = null;
    LinearSearch<double[]> naive = null;

    public KDTreeTest() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new double[10];
            for (int j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = Math.random();
            }
        }
        this.kdtree = new KDTree(this.data, (E[])this.data);
        this.naive = new LinearSearch<double[]>((T[])this.data, new EuclideanDistance());
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNearest() {
        System.out.println("nearest");
        for (int i = 0; i < this.data.length; ++i) {
            Neighbor<double[], double[]> n1 = this.kdtree.nearest(this.data[i]);
            Neighbor<double[], double[]> n2 = this.naive.nearest(this.data[i]);
            Assert.assertEquals(n1.index, n2.index);
            Assert.assertEquals(n1.value, n2.value);
            Assert.assertEquals(n1.distance, n2.distance, 1.0E-7);
        }
    }

    @Test
    public void testKnn() {
        System.out.println("knn");
        for (int i = 0; i < this.data.length; ++i) {
            Neighbor<double[], double[]>[] n1 = this.kdtree.knn(this.data[i], 10);
            Neighbor<double[], double[]>[] n2 = this.naive.knn(this.data[i], 10);
            for (int j = 0; j < n1.length; ++j) {
                Assert.assertEquals(n1[j].index, n2[j].index);
                Assert.assertEquals(n1[j].value, n2[j].value);
                Assert.assertEquals(n1[j].distance, n2[j].distance, 1.0E-7);
            }
        }
    }

    @Test
    public void testRange() {
        System.out.println("range 0.5");
        ArrayList n1 = new ArrayList();
        ArrayList n2 = new ArrayList();
        for (int i = 0; i < this.data.length; ++i) {
            this.kdtree.range(this.data[i], 0.5, (List<Neighbor<double[], double[]>>)n1);
            this.naive.range(this.data[i], 0.5, n2);
            Collections.sort(n1);
            Collections.sort(n2);
            Assert.assertEquals(n1.size(), n2.size());
            for (int j = 0; j < n1.size(); ++j) {
                Assert.assertEquals(((Neighbor)n1.get((int)j)).index, ((Neighbor)n2.get((int)j)).index);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).value, ((Neighbor)n2.get((int)j)).value);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).distance, ((Neighbor)n2.get((int)j)).distance, 1.0E-7);
            }
            n1.clear();
            n2.clear();
        }
    }

    @Test
    public void testRange2() {
        System.out.println("range 1.5");
        ArrayList n1 = new ArrayList();
        ArrayList n2 = new ArrayList();
        for (int i = 0; i < this.data.length; ++i) {
            this.kdtree.range(this.data[i], 1.5, (List<Neighbor<double[], double[]>>)n1);
            this.naive.range(this.data[i], 1.5, n2);
            Collections.sort(n1);
            Collections.sort(n2);
            Assert.assertEquals(n1.size(), n2.size());
            for (int j = 0; j < n1.size(); ++j) {
                Assert.assertEquals(((Neighbor)n1.get((int)j)).index, ((Neighbor)n2.get((int)j)).index);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).value, ((Neighbor)n2.get((int)j)).value);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).distance, ((Neighbor)n2.get((int)j)).distance, 1.0E-7);
            }
            n1.clear();
            n2.clear();
        }
    }
}

