/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.CoverTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

public class CoverTreeTest {
    double[][] data = new double[1000][];
    CoverTree<double[]> coverTree = null;
    LinearSearch<double[]> naive = null;

    public CoverTreeTest() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new double[10];
            for (int j = 0; j < this.data[i].length; ++j) {
                this.data[i][j] = Math.random();
            }
        }
        this.coverTree = new CoverTree<double[]>((E[])this.data, new EuclideanDistance());
        this.naive = new LinearSearch<double[]>((T[])this.data, new EuclideanDistance());
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNearest() {
        System.out.println("nearest");
        for (int i = 0; i < this.data.length; ++i) {
            Neighbor<double[], double[]> n1 = this.coverTree.nearest(this.data[i]);
            Neighbor<double[], double[]> n2 = this.naive.nearest(this.data[i]);
            Assert.assertEquals(n1.index, n2.index);
            Assert.assertEquals(n1.value, n2.value);
            Assert.assertEquals(n1.distance, n2.distance, 1.0E-7);
        }
    }

    @Test
    public void testKnn() {
        System.out.println("knn");
        for (int i = 0; i < this.data.length; ++i) {
            Neighbor<double[], double[]>[] n1 = this.coverTree.knn(this.data[i], 10);
            Neighbor<double[], double[]>[] n2 = this.naive.knn(this.data[i], 10);
            Assert.assertEquals(n1.length, n2.length);
            for (int j = 0; j < n1.length; ++j) {
                Assert.assertEquals(n1[j].index, n2[j].index);
                Assert.assertEquals(n1[j].value, n2[j].value);
                Assert.assertEquals(n1[j].distance, n2[j].distance, 1.0E-7);
            }
        }
    }

    @Test
    public void testKnn1() {
        System.out.println("knn1");
        double[][] data1 = new double[][]{this.data[0]};
        EuclideanDistance d = new EuclideanDistance();
        this.coverTree = new CoverTree<double[]>(data1, d);
        Neighbor<double[], double[]>[] n1 = this.coverTree.knn(this.data[1], 1);
        Assert.assertEquals(1L, n1.length);
        Assert.assertEquals(0L, n1[0].index);
        Assert.assertEquals((Object)this.data[0], n1[0].value);
        Assert.assertEquals(d.d(this.data[0], this.data[1]), n1[0].distance, 1.0E-7);
    }

    @Test
    public void testRange() {
        System.out.println("range");
        ArrayList n1 = new ArrayList();
        ArrayList n2 = new ArrayList();
        for (int i = 0; i < this.data.length; ++i) {
            this.coverTree.range(this.data[i], 0.5, n1);
            this.naive.range(this.data[i], 0.5, n2);
            Collections.sort(n1);
            Collections.sort(n2);
            Assert.assertEquals(n1.size(), n2.size());
            for (int j = 0; j < n1.size(); ++j) {
                Assert.assertEquals(((Neighbor)n1.get((int)j)).index, ((Neighbor)n2.get((int)j)).index);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).value, ((Neighbor)n2.get((int)j)).value);
                Assert.assertEquals(((Neighbor)n1.get((int)j)).distance, ((Neighbor)n2.get((int)j)).distance, 1.0E-7);
            }
            n1.clear();
            n2.clear();
        }
    }
}

