/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.parser.IOUtils;
import smile.math.distance.EditDistance;
import smile.neighbor.CoverTree;

public class CoverTreeStringSpeedTest {
    List<String> words = new ArrayList<String>();
    CoverTree<String> cover;

    public CoverTreeStringSpeedTest() {
        long start = System.currentTimeMillis();
        try {
            BufferedReader input = IOUtils.getTestDataReader("neighbor/index.noun");
            String line = input.readLine();
            while (line != null) {
                if (!line.startsWith(" ")) {
                    String[] w = line.split("\\s");
                    this.words.add(w[0].replace('_', ' '));
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading data: %.2fs%n", time);
        String[] data = this.words.toArray(new String[this.words.size()]);
        start = System.currentTimeMillis();
        this.cover = new CoverTree<String>(data, new EditDistance(50, true));
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Building cover tree: %.2fs%n", time);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNaiveSpeed() {
        System.out.println("cover tree");
        long start = System.currentTimeMillis();
        ArrayList neighbors = new ArrayList();
        for (int i = 1000; i < 1100; ++i) {
            this.cover.range(this.words.get(i), 1.0, neighbors);
            neighbors.clear();
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Cover tree string search: %.2fs%n", time);
    }
}

