/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.parser.IOUtils;
import smile.math.distance.EditDistance;
import smile.neighbor.BKTree;
import smile.neighbor.Neighbor;

public class BKTreeSpeedTest {
    List<String> words = new ArrayList<String>();
    BKTree<String> bktree;

    public BKTreeSpeedTest() {
        long start = System.currentTimeMillis();
        try {
            BufferedReader input = IOUtils.getTestDataReader("neighbor/index.noun");
            String line = input.readLine();
            while (line != null) {
                if (!line.startsWith(" ")) {
                    String[] w = line.split("\\s");
                    this.words.add(w[0].replace('_', ' '));
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Loading data: %.2fs%n", time);
        String[] data = this.words.toArray(new String[this.words.size()]);
        start = System.currentTimeMillis();
        this.bktree = new BKTree<String>(new EditDistance(50, true));
        this.bktree.add((String)data);
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("Building BK-tree: %.2fs%n", time);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBKTreeSpeed() {
        int i;
        System.out.println("BK-Tree range 1 speed");
        long start = System.currentTimeMillis();
        ArrayList neighbors = new ArrayList();
        for (int i2 = 1000; i2 < 1100; ++i2) {
            this.bktree.range(this.words.get(i2), 1, (List<Neighbor<String, String>>)neighbors);
            neighbors.clear();
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("BK-tree range 1 search: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 1000; i < 1100; ++i) {
            this.bktree.range(this.words.get(i), 2, (List<Neighbor<String, String>>)neighbors);
            neighbors.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("BK-tree range 2 search: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 1000; i < 1100; ++i) {
            this.bktree.range(this.words.get(i), 3, (List<Neighbor<String, String>>)neighbors);
            neighbors.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("BK-tree range 3 search: %.2fs%n", time);
        start = System.currentTimeMillis();
        for (i = 1000; i < 1100; ++i) {
            this.bktree.range(this.words.get(i), 4, (List<Neighbor<String, String>>)neighbors);
            neighbors.clear();
        }
        time = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.format("BK-tree range 4 search: %.2fs%n", time);
    }
}

