/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.math.Math;
import smile.mds.MDS;

public class MDSTest {
    double[][] eurodist = new double[][]{{0.0, 3313.0, 2963.0, 3175.0, 3339.0, 2762.0, 3276.0, 2610.0, 4485.0, 2977.0, 3030.0, 4532.0, 2753.0, 3949.0, 2865.0, 2282.0, 2179.0, 3000.0, 817.0, 3927.0, 1991.0}, {3313.0, 0.0, 1318.0, 1326.0, 1294.0, 1498.0, 2218.0, 803.0, 1172.0, 2018.0, 1490.0, 1305.0, 645.0, 636.0, 521.0, 1014.0, 1365.0, 1033.0, 1460.0, 2868.0, 1802.0}, {2963.0, 1318.0, 0.0, 204.0, 583.0, 206.0, 966.0, 677.0, 2256.0, 597.0, 172.0, 2084.0, 690.0, 1558.0, 1011.0, 925.0, 747.0, 285.0, 1511.0, 1616.0, 1175.0}, {3175.0, 1326.0, 204.0, 0.0, 460.0, 409.0, 1136.0, 747.0, 2224.0, 714.0, 330.0, 2052.0, 739.0, 1550.0, 1059.0, 1077.0, 977.0, 280.0, 1662.0, 1786.0, 1381.0}, {3339.0, 1294.0, 583.0, 460.0, 0.0, 785.0, 1545.0, 853.0, 2047.0, 1115.0, 731.0, 1827.0, 789.0, 1347.0, 1101.0, 1209.0, 1160.0, 340.0, 1794.0, 2196.0, 1588.0}, {2762.0, 1498.0, 206.0, 409.0, 785.0, 0.0, 760.0, 1662.0, 2436.0, 460.0, 269.0, 2290.0, 714.0, 1764.0, 1035.0, 911.0, 583.0, 465.0, 1497.0, 1403.0, 937.0}, {3276.0, 2218.0, 966.0, 1136.0, 1545.0, 760.0, 0.0, 1418.0, 3196.0, 460.0, 269.0, 2971.0, 1458.0, 2498.0, 1778.0, 1537.0, 1104.0, 1176.0, 2050.0, 650.0, 1455.0}, {2610.0, 803.0, 677.0, 747.0, 853.0, 1662.0, 1418.0, 0.0, 1975.0, 1118.0, 895.0, 1936.0, 158.0, 1439.0, 425.0, 328.0, 591.0, 513.0, 995.0, 2068.0, 1019.0}, {4485.0, 1172.0, 2256.0, 2224.0, 2047.0, 2436.0, 3196.0, 1975.0, 0.0, 2897.0, 2428.0, 676.0, 1817.0, 698.0, 1693.0, 2185.0, 2565.0, 1971.0, 2631.0, 3886.0, 2974.0}, {2977.0, 2018.0, 597.0, 714.0, 1115.0, 460.0, 460.0, 1118.0, 2897.0, 0.0, 550.0, 2671.0, 1159.0, 2198.0, 1479.0, 1238.0, 805.0, 877.0, 1751.0, 949.0, 1155.0}, {3030.0, 1490.0, 172.0, 330.0, 731.0, 269.0, 269.0, 895.0, 2428.0, 550.0, 0.0, 2280.0, 863.0, 1730.0, 1183.0, 1098.0, 851.0, 457.0, 1683.0, 1500.0, 1205.0}, {4532.0, 1305.0, 2084.0, 2052.0, 1827.0, 2290.0, 2971.0, 1936.0, 676.0, 2671.0, 2280.0, 0.0, 1178.0, 668.0, 1762.0, 2250.0, 2507.0, 1799.0, 2700.0, 3231.0, 2937.0}, {2753.0, 645.0, 690.0, 739.0, 789.0, 714.0, 1458.0, 158.0, 1817.0, 1159.0, 863.0, 1178.0, 0.0, 1281.0, 320.0, 328.0, 724.0, 471.0, 1048.0, 2108.0, 1157.0}, {3949.0, 636.0, 1558.0, 1550.0, 1347.0, 1764.0, 2498.0, 1439.0, 698.0, 2198.0, 1730.0, 668.0, 1281.0, 0.0, 1157.0, 1724.0, 2010.0, 1273.0, 2097.0, 3188.0, 2409.0}, {2865.0, 521.0, 1011.0, 1059.0, 1101.0, 1035.0, 1778.0, 425.0, 1693.0, 1479.0, 1183.0, 1762.0, 320.0, 1157.0, 0.0, 618.0, 1109.0, 792.0, 1011.0, 2428.0, 1363.0}, {2282.0, 1014.0, 925.0, 1077.0, 1209.0, 911.0, 1537.0, 328.0, 2185.0, 1238.0, 1098.0, 2250.0, 328.0, 1724.0, 618.0, 0.0, 331.0, 856.0, 586.0, 2187.0, 898.0}, {2179.0, 1365.0, 747.0, 977.0, 1160.0, 583.0, 1104.0, 591.0, 2565.0, 805.0, 851.0, 2507.0, 724.0, 2010.0, 1109.0, 331.0, 0.0, 821.0, 946.0, 1754.0, 428.0}, {3000.0, 1033.0, 285.0, 280.0, 340.0, 465.0, 1176.0, 513.0, 1971.0, 877.0, 457.0, 1799.0, 471.0, 1273.0, 792.0, 856.0, 821.0, 0.0, 1476.0, 1827.0, 1249.0}, {817.0, 1460.0, 1511.0, 1662.0, 1794.0, 1497.0, 2050.0, 995.0, 2631.0, 1751.0, 1683.0, 2700.0, 1048.0, 2097.0, 1011.0, 586.0, 946.0, 1476.0, 0.0, 2707.0, 1209.0}, {3927.0, 2868.0, 1616.0, 1786.0, 2196.0, 1403.0, 650.0, 2068.0, 3886.0, 949.0, 1500.0, 3231.0, 2108.0, 3188.0, 2428.0, 2187.0, 1754.0, 1827.0, 2707.0, 0.0, 2105.0}, {1991.0, 1802.0, 1175.0, 1381.0, 1588.0, 937.0, 1455.0, 1019.0, 2974.0, 1155.0, 1205.0, 2937.0, 1157.0, 2409.0, 1363.0, 898.0, 428.0, 1249.0, 1209.0, 2105.0, 0.0}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn_doubleArrArr() {
        int i;
        System.out.println("learn");
        double[] eigs = new double[]{1.95383770895E7, 1.1856555334E7};
        double[][] points = new double[][]{{2290.27468, 1798.80293}, {-825.38279, 546.81148}, {59.183341, -367.08135}, {-82.845973, -429.91466}, {-352.499435, -290.90843}, {293.689633, -405.31194}, {681.931545, -1108.64478}, {-9.423364, 240.406}, {-2048.449113, 642.45854}, {561.10897, -773.36929}, {164.921799, -549.36704}, {-1935.040811, 49.12514}, {-226.423236, 187.08779}, {-1423.353697, 305.87513}, {-299.49871, 388.80726}, {260.878046, 416.67381}, {587.675679, 81.18224}, {-156.836257, -211.13911}, {709.413282, 1109.36665}, {839.445911, -1836.79055}, {911.2305, 205.9302}};
        MDS mds = new MDS(this.eurodist);
        for (i = 0; i < eigs.length; ++i) {
            System.out.print(eigs[i] + " ");
        }
        System.out.println("==============");
        for (i = 0; i < mds.getEigenValues().length; ++i) {
            System.out.print(mds.getEigenValues()[i] + " ");
        }
        System.out.println();
        Assert.assertTrue(Math.equals(eigs, mds.getEigenValues(), 1.0E-4));
        double[][] coords = mds.getCoordinates();
        for (int i2 = 0; i2 < points.length; ++i2) {
            for (int j = 0; j < points[0].length; ++j) {
                Assert.assertEquals(Math.abs(points[i2][j]), Math.abs(coords[i2][j]), 0.01);
            }
        }
    }

    @Test
    public void testLearn_doubleArrArr_double() {
        System.out.println("learn");
        double[] eigs = new double[]{4.22749738E7, 3.16661864E7};
        double[][] points = new double[][]{{2716.56182, 3549.216493}, {-1453.753109, 455.895291}, {217.426476, -1073.442137}, {1.682974, -1135.742982}, {-461.875781, -871.913389}, {594.256798, -1029.818247}, {1271.216005, -1622.039302}, {-88.721376, 4.068005}, {-3059.18099, 836.535103}, {1056.316198, -1350.037932}, {445.663432, -1304.392098}, {-2866.160085, 211.043554}, {-436.147722, -140.147837}, {-2300.753691, 234.863677}, {-586.877042, 217.428075}, {336.906562, 350.948939}, {928.407679, -112.132182}, {-193.653844, -847.157498}, {908.6821, 1742.395923}, {1499.140467, -1897.522865}, {1319.918808, 295.010834}};
        MDS mds = new MDS(this.eurodist, 2, true);
        Assert.assertTrue(Math.equals(eigs, mds.getEigenValues(), 0.1));
        double[][] coords = mds.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[0].length; ++j) {
                Assert.assertEquals(Math.abs(points[i][j]), Math.abs(coords[i][j]), 0.01);
            }
        }
    }
}

