/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.kernel.MercerKernel;

public class SparseGaussianKernel
implements MercerKernel<SparseArray>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double gamma;

    public SparseGaussianKernel(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive.");
        }
        this.gamma = 0.5 / (sigma * sigma);
    }

    public String toString() {
        return String.format("Sparse Gaussian Kernel (\u02e0 = %.4f)", Math.sqrt(0.5 / this.gamma));
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        return Math.exp(-this.gamma * Math.squaredDistance(x, y));
    }
}

