/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.SparseDataset;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.Math;
import smile.math.SparseArray;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.SparseMatrix;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;

public class LaplacianEigenmap {
    private static final Logger logger = LoggerFactory.getLogger(LaplacianEigenmap.class);
    private double t;
    private int[] index;
    private double[][] coordinates;
    private Graph graph;

    public LaplacianEigenmap(double[][] data, int d, int k) {
        this(data, d, k, -1.0);
    }

    /*
     * WARNING - void declaration
     */
    public LaplacianEigenmap(double[][] data, int d, int k, double t) {
        void var16_23;
        int j;
        Iterable<Graph.Edge> edges;
        int i;
        this.t = t;
        int n = data.length;
        NearestNeighborSearch knn = null;
        knn = data[0].length < 10 ? new KDTree(data, (E[])data) : new CoverTree<double[]>((E[])data, new EuclideanDistance());
        this.graph = new AdjacencyList(n);
        for (int i2 = 0; i2 < n; ++i2) {
            Neighbor<double[], V>[] neighbors = knn.knn(data[i2], k);
            for (int j2 = 0; j2 < k; ++j2) {
                this.graph.setWeight(i2, neighbors[j2].index, neighbors[j2].distance);
            }
        }
        int[][] cc = this.graph.bfs();
        if (cc.length == 1) {
            this.index = new int[n];
            for (int i3 = 0; i3 < n; ++i3) {
                this.index[i3] = i3;
            }
        } else {
            n = 0;
            int component = 0;
            for (int i4 = 0; i4 < cc.length; ++i4) {
                if (cc[i4].length <= n) continue;
                component = i4;
                n = cc[i4].length;
            }
            logger.info("Laplacian Eigenmap: {} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            this.index = cc[component];
            this.graph = this.graph.subgraph(this.index);
        }
        SparseDataset W = new SparseDataset(n);
        double[] D = new double[n];
        double gamma = -1.0 / t;
        for (i = 0; i < n; ++i) {
            edges = this.graph.getEdges(i);
            for (Graph.Edge edge : edges) {
                j = edge.v2;
                if (i == j) {
                    j = edge.v1;
                }
                double w = t <= 0.0 ? 1.0 : Math.exp(gamma * Math.sqr(edge.weight));
                W.set(i, j, w);
                int n2 = i;
                D[n2] = D[n2] + w;
            }
            D[i] = 1.0 / Math.sqrt(D[i]);
        }
        for (i = 0; i < n; ++i) {
            edges = (SparseArray)W.get((int)i).x;
            for (SparseArray.Entry entry : edges) {
                j = entry.i;
                double s = D[i] * entry.x * D[j];
                W.set(i, j, s);
            }
            W.set(i, i, 0.0);
        }
        SparseMatrix L = W.toSparseMatrix();
        L.setSymmetric(true);
        EVD eigen = L.eigen(Math.min(10 * (d + 1), n - 1));
        DenseMatrix V = eigen.getEigenVectors();
        this.coordinates = new double[n][d];
        boolean bl = false;
        while (var16_23 < d) {
            double norm = 0.0;
            for (int i5 = 0; i5 < n; ++i5) {
                this.coordinates[i5][var16_23] = V.get(i5, (int)(var16_23 + true)) * D[i5];
                norm += this.coordinates[i5][var16_23] * this.coordinates[i5][var16_23];
            }
            norm = Math.sqrt(norm);
            for (int i2 = 0; i2 < n; ++i2) {
                double[] dArray = this.coordinates[i2];
                void v2 = var16_23;
                dArray[v2] = dArray[v2] / norm;
            }
            ++var16_23;
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public Graph getNearestNeighborGraph() {
        return this.graph;
    }

    public double getHeatKernelWidth() {
        return this.t;
    }
}

