/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation;
import smile.math.Math;

public class ShepardInterpolation1D
implements Interpolation {
    private double[] x;
    private double[] y;
    private double p;

    public ShepardInterpolation1D(double[] x, double[] y) {
        this(x, y, 2.0);
    }

    public ShepardInterpolation1D(double[] x, double[] y, double p) {
        this.x = x;
        this.y = y;
        this.p = -p;
    }

    @Override
    public double interpolate(double x) {
        double weight = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            double r = Math.abs(x - this.x[i]);
            if (r == 0.0) {
                return this.y[i];
            }
            double w = Math.pow(r, this.p);
            weight += w;
            sum += w * this.y[i];
        }
        return sum / weight;
    }
}

