/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.rbf.GaussianRadialBasis;
import smile.math.rbf.RadialBasisFunction;

public class RBFInterpolation {
    private double[][] x;
    private double[] w;
    private RadialBasisFunction rbf;
    private boolean normalized;

    public RBFInterpolation(double[][] x, double[] y, RadialBasisFunction normalized) {
        this(x, y, normalized, false);
    }

    public RBFInterpolation(double[][] x, double[] y, RadialBasisFunction rbf, boolean normalized) {
        this.x = x;
        this.rbf = rbf;
        this.normalized = normalized;
        int n = x.length;
        DenseMatrix G = Matrix.zeros(n, n);
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j <= i; ++j) {
                double r = rbf.f(Math.distance(x[i], x[j]));
                G.set(i, j, r);
                G.set(j, i, r);
                sum += 2.0 * r;
            }
            rhs[i] = normalized ? sum * y[i] : y[i];
        }
        if (rbf instanceof GaussianRadialBasis) {
            Cholesky cholesky = G.cholesky();
            cholesky.solve(rhs);
            this.w = rhs;
        } else {
            LU lu = G.lu(true);
            lu.solve(rhs);
            this.w = rhs;
        }
    }

    public double interpolate(double ... x) {
        if (x.length != this.x[0].length) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.x[0].length));
        }
        double sum = 0.0;
        double sumw = 0.0;
        for (int i = 0; i < this.x.length; ++i) {
            double f = this.rbf.f(Math.distance(x, this.x[i]));
            sumw += this.w[i] * f;
            sum += f;
        }
        return this.normalized ? sumw / sum : sumw;
    }
}

