/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation2D;
import smile.interpolation.LinearInterpolation;

public class BilinearInterpolation
implements Interpolation2D {
    private double[][] y;
    private LinearInterpolation x1terp;
    private LinearInterpolation x2terp;

    public BilinearInterpolation(double[] x1, double[] x2, double[][] y) {
        this.y = y;
        this.x1terp = new LinearInterpolation(x1, x1);
        this.x2terp = new LinearInterpolation(x2, x2);
    }

    @Override
    public double interpolate(double x1, double x2) {
        int i = this.x1terp.search(x1);
        int j = this.x2terp.search(x2);
        double t = (x1 - this.x1terp.xx[i]) / (this.x1terp.xx[i + 1] - this.x1terp.xx[i]);
        double u = (x2 - this.x2terp.xx[j]) / (this.x2terp.xx[j + 1] - this.x2terp.xx[j]);
        double yy = (1.0 - t) * (1.0 - u) * this.y[i][j] + t * (1.0 - u) * this.y[i + 1][j] + (1.0 - t) * u * this.y[i][j + 1] + t * u * this.y[i + 1][j + 1];
        return yy;
    }
}

