/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.gap.BitString;

public class BitStringTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNewInstance() {
        System.out.println("newInstance");
        int[] father = new int[]{1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0};
        BitString instance = new BitString(father, null, BitString.Crossover.SINGLE_POINT, 1.0, 0.0);
        BitString result = instance.newInstance();
        Assert.assertEquals(father.length, result.length);
        Assert.assertEquals(father.length, result.bits().length);
        boolean same = true;
        for (int i = 0; i < father.length; ++i) {
            if (father[i] == result.bits()[i]) continue;
            same = false;
        }
        Assert.assertFalse(same);
    }

    @Test
    public void testCrossoverOne() {
        System.out.println("crossover one point");
        int[] father = new int[]{1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0};
        int[] mother = new int[]{0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1};
        BitString instance = new BitString(father, null, BitString.Crossover.SINGLE_POINT, 1.0, 0.0);
        BitString another = new BitString(mother, null, BitString.Crossover.SINGLE_POINT, 1.0, 0.0);
        int[] son = new int[]{1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        int[] daughter = new int[]{0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0};
        BitString[] result = instance.crossover(another);
        Assert.assertEquals(son.length, result[0].bits().length);
        Assert.assertEquals(daughter.length, result[1].bits().length);
        for (int i = 0; i < son.length; ++i) {
            Assert.assertTrue(father[i] == result[0].bits()[i] && mother[i] == result[1].bits()[i] || father[i] == result[1].bits()[i] && mother[i] == result[0].bits()[i]);
        }
    }

    @Test
    public void testCrossoverTwo() {
        System.out.println("crossover two point");
        int[] father = new int[]{1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0};
        int[] mother = new int[]{0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1};
        BitString instance = new BitString(father, null, BitString.Crossover.TWO_POINT, 1.0, 0.0);
        BitString another = new BitString(mother, null, BitString.Crossover.TWO_POINT, 1.0, 0.0);
        int[] son = new int[]{1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0};
        int[] daughter = new int[]{0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1};
        BitString[] result = instance.crossover(another);
        Assert.assertEquals(son.length, result[0].bits().length);
        Assert.assertEquals(daughter.length, result[1].bits().length);
        for (int i = 0; i < son.length; ++i) {
            Assert.assertTrue(father[i] == result[0].bits()[i] && mother[i] == result[1].bits()[i] || father[i] == result[1].bits()[i] && mother[i] == result[0].bits()[i]);
        }
    }

    @Test
    public void testCrossoverUniform() {
        System.out.println("crossover uniform");
        int[] father = new int[]{1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0};
        int[] mother = new int[]{0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1};
        BitString instance = new BitString(father, null, BitString.Crossover.UNIFORM, 1.0, 0.0);
        BitString another = new BitString(mother, null, BitString.Crossover.UNIFORM, 1.0, 0.0);
        BitString[] result = instance.crossover(another);
        Assert.assertEquals(father.length, result[0].bits().length);
        Assert.assertEquals(mother.length, result[1].bits().length);
        boolean same = true;
        for (int i = 0; i < father.length; ++i) {
            Assert.assertTrue(father[i] == result[0].bits()[i] && mother[i] == result[1].bits()[i] || father[i] == result[1].bits()[i] && mother[i] == result[0].bits()[i]);
            if (father[i] == result[0].bits()[i]) continue;
            same = false;
        }
        Assert.assertFalse(same);
    }

    @Test
    public void testMutate() {
        System.out.println("mutate");
        int[] father = new int[]{1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0};
        BitString instance = new BitString((int[])father.clone(), null, BitString.Crossover.SINGLE_POINT, 1.0, 1.0);
        instance.mutate();
        Assert.assertEquals(father.length, instance.length);
        Assert.assertEquals(father.length, instance.bits().length);
        boolean same = true;
        for (int i = 0; i < father.length; ++i) {
            if (father[i] == instance.bits()[i]) continue;
            same = false;
        }
        Assert.assertFalse(same);
    }
}

