/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.math.Math;
import smile.plot.PlotCanvas;
import smile.plot.Surface;
import smile.stat.distribution.MultivariateGaussianDistribution;

public class MultivariateGaussianDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private PlotCanvas pdf;
    private JSlider sigma1Slider;
    private JSlider sigma2Slider;
    private double[] mu = new double[]{0.0, 0.0};
    private double[] sigma = new double[]{1.0, 1.0};
    private int n = 30;
    private int m = 30;
    private double[][][] z = new double[this.m][this.n][3];

    public MultivariateGaussianDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 30; i += 10) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 10.0)));
        }
        this.sigma1Slider = new JSlider(0, 30, (int)(this.sigma[0] * 10.0));
        this.sigma1Slider.addChangeListener(this);
        this.sigma1Slider.setLabelTable(labelTable);
        this.sigma1Slider.setMajorTickSpacing(10);
        this.sigma1Slider.setMinorTickSpacing(2);
        this.sigma1Slider.setPaintTicks(true);
        this.sigma1Slider.setPaintLabels(true);
        this.sigma2Slider = new JSlider(0, 30, (int)(this.sigma[1] * 10.0));
        this.sigma2Slider.addChangeListener(this);
        this.sigma2Slider.setLabelTable(labelTable);
        this.sigma2Slider.setMajorTickSpacing(10);
        this.sigma2Slider.setMinorTickSpacing(2);
        this.sigma2Slider.setPaintTicks(true);
        this.sigma2Slider.setPaintLabels(true);
        this.optionPane = new JPanel();
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("<html>\u03c3<sub>1</sub>:</html>"));
        this.optionPane.add(this.sigma1Slider);
        this.optionPane.add(new JLabel("<html>\u03c3<sub>2</sub>:</html>"));
        this.optionPane.add(this.sigma2Slider);
        this.add((Component)this.optionPane, "North");
        MultivariateGaussianDistribution g = new MultivariateGaussianDistribution(this.mu, this.sigma);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.z[i][j][0] = 6.0 * (double)(i - this.m / 2) / (double)this.m;
                this.z[i][j][1] = 6.0 * (double)(j - this.n / 2) / (double)this.n;
                double[] point = new double[]{this.z[i][j][0], this.z[i][j][1]};
                this.z[i][j][2] = g.p(point);
            }
        }
        this.pdf = Surface.plot(this.z);
        this.pdf.setTitle("Multivariate Gaussian");
        this.add((Component)this.pdf, "Center");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sigma1Slider || e.getSource() == this.sigma2Slider) {
            this.sigma[0] = Math.sqr((double)this.sigma1Slider.getValue() / 10.0);
            this.sigma[1] = Math.sqr((double)this.sigma2Slider.getValue() / 10.0);
            if (this.sigma[0] == 0.0) {
                this.sigma[0] = 0.01;
            }
            if (this.sigma[1] == 0.0) {
                this.sigma[1] = 0.01;
            }
            MultivariateGaussianDistribution g = new MultivariateGaussianDistribution(this.mu, this.sigma);
            for (int i = 0; i < this.m; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.z[i][j][0] = 6.0 * (double)(i - this.m / 2) / (double)this.m;
                    this.z[i][j][1] = 6.0 * (double)(j - this.n / 2) / (double)this.n;
                    double[] point = new double[]{this.z[i][j][0], this.z[i][j][1]};
                    this.z[i][j][2] = g.p(point);
                }
            }
            this.pdf.repaint();
        }
    }

    @Override
    public String toString() {
        return "Multivariate Gaussian";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MultivariateGaussian Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new MultivariateGaussianDistributionDemo());
        frame.setVisible(true);
    }
}

