/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.FDistribution;

public class FDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider d1Slider;
    private JSlider d2Slider;
    private int d1 = 20;
    private int d2 = 20;

    public FDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(1, new JLabel(String.valueOf(1)));
        for (int i = 20; i <= 100; i += 20) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.d1Slider = new JSlider(1, 100, this.d1);
        this.d1Slider.addChangeListener(this);
        this.d1Slider.setLabelTable(labelTable);
        this.d1Slider.setMajorTickSpacing(10);
        this.d1Slider.setMinorTickSpacing(2);
        this.d1Slider.setPaintTicks(true);
        this.d1Slider.setPaintLabels(true);
        this.d2Slider = new JSlider(1, 100, this.d2);
        this.d2Slider.addChangeListener(this);
        this.d2Slider.setLabelTable(labelTable);
        this.d2Slider.setMajorTickSpacing(10);
        this.d2Slider.setMinorTickSpacing(2);
        this.d2Slider.setPaintTicks(true);
        this.d2Slider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("Degree of Freedom 1:"));
        this.optionPane.add(this.d1Slider);
        this.optionPane.add(new JLabel("Degree of Freedom 2:"));
        this.optionPane.add(this.d2Slider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        FDistribution dist = new FDistribution(this.d1, this.d2);
        double[][] p = new double[100][2];
        double[][] q = new double[100][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)(i + 1) / 20.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)(i + 1) / 20.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.d1Slider || e.getSource() == this.d2Slider) {
            this.d1 = this.d1Slider.getValue();
            if (this.d1 == 0) {
                this.d1 = 1;
            }
            this.d2 = this.d2Slider.getValue();
            if (this.d2 == 0) {
                this.d2 = 1;
            }
            FDistribution dist = new FDistribution(this.d1, this.d2);
            double[][] p = new double[100][2];
            double[][] q = new double[100][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)(i + 1) / 20.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)(i + 1) / 20.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "F";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("F-Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new FDistributionDemo());
        frame.setVisible(true);
    }
}

